/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.common.constant;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bundle.BosRes;
import kd.bos.kdtx.common.constant.Status;

public enum GlobalTxStatus implements Status
{
    NOT_FOUND(0, BosRes.get((String)"bos_kdtx_common", (String)"GlobalTxStatusNotFound", (String)"\u4e8b\u52a1\u672a\u5f00\u542f", (Object[])new Object[0])),
    PREPARING(1, BosRes.get((String)"bos_kdtx_common", (String)"GlobalTxStatusPreparing", (String)"\u5206\u652f\u4e8b\u52a1\u6267\u884c\u4e2d", (Object[])new Object[0])),
    COMMITTING(2, BosRes.get((String)"bos_kdtx_common", (String)"GlobalTxStatusCommitting", (String)"\u4e8b\u52a1\u63d0\u4ea4\u4e2d", (Object[])new Object[0])),
    ROLLBACKING(3, BosRes.get((String)"bos_kdtx_common", (String)"GlobalTxStatusRollbacking", (String)"\u4e8b\u52a1\u56de\u6eda\u4e2d", (Object[])new Object[0])),
    COMMITTED(4, BosRes.get((String)"bos_kdtx_common", (String)"GlobalTxStatusCommitted", (String)"\u4e8b\u52a1\u5df2\u63d0\u4ea4", (Object[])new Object[0])),
    ROLLBACKED(5, BosRes.get((String)"bos_kdtx_common", (String)"GlobalTxStatusRollbacked", (String)"\u4e8b\u52a1\u5df2\u56de\u6eda", (Object[])new Object[0])),
    ROLLBACK_FAILED(6, BosRes.get((String)"bos_kdtx_common", (String)"GlobalTxStatusRollbackFailed", (String)"\u4e8b\u52a1\u56de\u6eda\u5931\u8d25", (Object[])new Object[0])),
    COMMIT_FAILED(7, BosRes.get((String)"bos_kdtx_common", (String)"GlobalTxStatusCommittedFailed", (String)"\u4e8b\u52a1\u63d0\u4ea4\u5931\u8d25", (Object[])new Object[0]));

    private int code;
    private String name;
    private static final Map<Integer, GlobalTxStatus> MAP;

    private GlobalTxStatus(int code, String name) {
        this.code = code;
        this.name = name;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static GlobalTxStatus get(int code) {
        GlobalTxStatus status = MAP.get(code);
        if (status == null) {
            throw new IllegalArgumentException("Unknown GlobalStatus[" + code + "]");
        }
        return status;
    }

    public static boolean compensateEnable(int code) {
        List<Integer> compensates = Arrays.asList(COMMIT_FAILED.getCode(), ROLLBACK_FAILED.getCode());
        return compensates.contains(code);
    }

    public static boolean compensateEnable(GlobalTxStatus status) {
        return GlobalTxStatus.compensateEnable(status.getCode());
    }

    public static GlobalTxStatus[] getCompensateEnable() {
        return new GlobalTxStatus[]{COMMITTING, COMMIT_FAILED, ROLLBACKING, ROLLBACK_FAILED};
    }

    public static GlobalTxStatus[] getFinished() {
        return new GlobalTxStatus[]{COMMITTED, ROLLBACKED};
    }

    static {
        MAP = new HashMap<Integer, GlobalTxStatus>(GlobalTxStatus.values().length);
        for (GlobalTxStatus status : GlobalTxStatus.values()) {
            MAP.put(status.code, status);
        }
    }
}

