/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.common.constant;

import java.util.HashMap;
import java.util.Map;

public enum InvokeType {
    TX_BEGIN(1, "tx_begin"),
    PREPARE(2, "prepare"),
    BRANCH_REGISTER(3, "branch_register"),
    TX_COMMIT(4, "tx_commit"),
    BRANCH_COMMIT(5, "branch_commit"),
    TX_ROLLBACK(6, "tx_rollback"),
    BRANCH_ROLLBACK(7, "branch_rollback"),
    BRANCH_REPORT(8, "branch_report"),
    MANUAL_COMPENSATE(10, "manual_compensate"),
    CASCADE_BRANCH_REGISTER(11, "cascade_branch_register"),
    SET_BUSINESS_INFO(12, "set_business_info");

    private int code;
    private String name;
    private static final Map<Integer, InvokeType> MAP;

    private InvokeType(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static InvokeType get(int code) {
        InvokeType enumVal = MAP.get(code);
        if (enumVal == null) {
            throw new IllegalArgumentException("Unknown enumVal[" + code + "]");
        }
        return enumVal;
    }

    public static boolean assertInvokeType(InvokeType invokeType) {
        return InvokeType.isTxType(invokeType) || InvokeType.isBranchType(invokeType);
    }

    public static boolean isBranchType(InvokeType invokerType) {
        return PREPARE == invokerType || BRANCH_COMMIT == invokerType || BRANCH_ROLLBACK == invokerType;
    }

    public static boolean isTxType(InvokeType invokerType) {
        return TX_BEGIN == invokerType || BRANCH_REGISTER == invokerType || BRANCH_REPORT == invokerType || TX_COMMIT == invokerType || TX_ROLLBACK == invokerType || CASCADE_BRANCH_REGISTER == invokerType || SET_BUSINESS_INFO == invokerType;
    }

    static {
        MAP = new HashMap<Integer, InvokeType>(InvokeType.values().length);
        for (InvokeType enumVal : InvokeType.values()) {
            MAP.put(enumVal.code, enumVal);
        }
    }
}

