/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.common.constant;

import java.util.HashMap;
import java.util.Map;

public enum TCCMethod {
    TRY(1, "doTry", 1),
    CONFIRM(2, "doConfirm", 2),
    CANCEL(3, "doCancel", 1);

    private int code;
    private String name;
    private int methodParamCount;
    private static final Map<Integer, TCCMethod> MAP;

    private TCCMethod(int code, String name, int methodParamCount) {
        this.code = code;
        this.name = name;
        this.methodParamCount = methodParamCount;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public int getMethodParamCount() {
        return this.methodParamCount;
    }

    public static TCCMethod get(int code) {
        TCCMethod enumVal = MAP.get(code);
        if (enumVal == null) {
            throw new IllegalArgumentException("Unknown enumVal[" + code + "]");
        }
        return enumVal;
    }

    static {
        MAP = new HashMap<Integer, TCCMethod>(TCCMethod.values().length);
        for (TCCMethod enumVal : TCCMethod.values()) {
            MAP.put(enumVal.code, enumVal);
        }
    }
}

