/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.common.dao;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.kdtx.common.entity.Scene;
import kd.bos.kdtx.common.entity.TxSceneInfo;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.trace.util.TraceIdUtil;

public class SceneDao {
    private static final String GET_SCENES_INFO_SOL = "select fcode,fname,fphone from t_cbs_dtx_tx_scenes";
    private static final String GET_BRANCH_SCENCE_ID_SQL = "SELECT bs.fentryid FROM t_cbs_dtx_branch_scenes bs  where bs.fid in( select ts.fid from t_cbs_dtx_tx_scenes ts where ts.fcode=?)  and bs.fcode=?";
    private static final String GET_SCENES_INFO_BY_CODE = "SELECT fid,fcode,fname,fapp,fphone,fremark,fbusiness_type FROM t_cbs_dtx_tx_scenes WHERE fcode = ?";
    private static final String INSERT = "INSERT INTO t_cbs_dtx_tx_scenes (fid,fcode,fname,fapp,fphone,fremark,fbusiness_type) VALUES(?,?,?,?,?,?,?)";

    public static TxSceneInfo getSceneInfo(String sceneCode) {
        TxSceneInfo txSceneInfo = (TxSceneInfo)DB.query((DBRoute)DBRoute.base, (String)GET_SCENES_INFO_BY_CODE, (Object[])new Object[]{sceneCode}, rs -> {
            TxSceneInfo info = new TxSceneInfo();
            if (rs.next()) {
                info.setId(rs.getString("fid"));
                info.setBusinessType(rs.getString("fbusiness_type"));
                info.setCode(rs.getString("fcode"));
                info.setName(rs.getString("fname"));
                info.setApp(rs.getString("fapp"));
                info.setPhone(rs.getString("fphone"));
                info.setRemark(rs.getString("fremark"));
            }
            return info;
        });
        return txSceneInfo;
    }

    public static Set<Scene> getAllAccountScenesInfo() {
        HashSet<Scene> scenes = new HashSet<Scene>();
        List accounts = AccountUtils.getAllAccountsOfCurrentEnv();
        accounts.forEach(account -> {
            ThreadLifeCycleManager.start();
            try {
                RequestContext context = RequestContext.create();
                context.setAccountId(account.getAccountId());
                context.setTenantId(account.getTenantId());
                context.setTraceId(TraceIdUtil.getCurrentTraceIdString());
                Set scenesSet = (Set)DB.query((DBRoute)DBRoute.basedata, (String)GET_SCENES_INFO_SOL, rs -> {
                    HashSet<Scene> scenesTemp = new HashSet<Scene>(rs.getFetchSize());
                    while (rs.next()) {
                        Scene scene = new Scene();
                        scene.setCode(rs.getString(1));
                        scene.setName(rs.getString(2));
                        scene.setPhone(rs.getString(3));
                        scenesTemp.add(scene);
                    }
                    return scenesTemp;
                });
                scenes.addAll(scenesSet);
            }
            catch (Exception e) {
                ExceptionLogger.error(SceneDao.class, "KdtxMonitorLog accountId:" + account.getAccountId() + " query scene info error will ignore");
            }
        });
        return scenes;
    }

    public static long getSceneBranchIdByCode(String sceneCode, String branchCode) {
        Object[] queryParamsBranch = new Object[]{sceneCode, branchCode};
        return (Long)DB.query((DBRoute)DBRoute.base, (String)GET_BRANCH_SCENCE_ID_SQL, (Object[])queryParamsBranch, rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return -1L;
        });
    }

    public static void saveSceneInfo(TxSceneInfo sceneInfo) {
        DB.execute((DBRoute)DBRoute.basedata, (String)INSERT, (Object[])new Object[]{Long.parseLong(sceneInfo.getId()), sceneInfo.getCode(), sceneInfo.getName(), sceneInfo.getApp(), sceneInfo.getPhone(), sceneInfo.getRemark(), sceneInfo.getBusinessType()});
    }
}

