/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.common.idemponent.helper;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.config.client.ConfigurationFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.kdtx.common.idemponent.concurrent.QuickExceptionStrategy;
import kd.bos.kdtx.common.idemponent.concurrent.QuickReturnStrategy;
import kd.bos.kdtx.common.idemponent.concurrent.ResultCopyStrategy;
import kd.bos.kdtx.common.idemponent.exception.RetryIdempotentException;
import kd.bos.kdtx.common.idemponent.helper.IdempotentSchedule;
import kd.bos.kdtx.common.idemponent.properties.ConcurrentPolicyEnum;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.properties.StorageStrategyEnum;
import kd.bos.kdtx.common.idemponent.storage.IdempotentStorageHelper;
import kd.bos.kdtx.common.idemponent.watchdog.IdempotentWatchDog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class IdempotentServiceHelper<T> {
    private static final Long MAX_ALIVE_TIME = 5184000000L;
    private static final String CREATE_TABLE_SQL = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 'T_IDEM_RPCIDEMPOTENTPROCESS')CREATE TABLE T_IDEM_RPCIDEMPOTENTPROCESS (FIDEMPOTENTKEY VARCHAR(64) DEFAULT ' ' NOT NULL,FCREATEDTIME DATETIME,FRENEWALINSTANCE VARCHAR(20) DEFAULT ' ' NOT NULL,FRENEWALTIME BIGINT DEFAULT 0 NOT NULL,FALIVEDTIME BIGINT DEFAULT 0 NOT NULL,FRESULT NCLOB,FEXECUTESTATUS CHAR(1) DEFAULT '0' NOT NULL);";
    private static final String CREATE_PK_ID = "EXEC P_ALTERPK 'PK_T_IDEM_RIPP', 'T_IDEM_RPCIDEMPOTENTPROCESS', 'FIDEMPOTENTKEY', '1'";
    private static final Map<String, Boolean> initTableMap = new ConcurrentHashMap<String, Boolean>(4);
    private static final String TABLE_NAME = "T_IDEM_RPCIDEMPOTENTPROCESS";
    private static Log logger = LogFactory.getLog(IdempotentServiceHelper.class);

    public static boolean idempotent(IdempotentProperties idempotentProperties) {
        if (IdempotentServiceHelper.skipIdempotentCheck()) {
            return false;
        }
        IdempotentServiceHelper.initTable(idempotentProperties.getDbRoute());
        IdempotentServiceHelper.validate(idempotentProperties);
        IdempotentSchedule.prepare(idempotentProperties.getDbRoute());
        return IdempotentServiceHelper.doIdempotentByBlocking(idempotentProperties);
    }

    /*
     * Unable to fully structure code
     */
    private static boolean doIdempotentByBlocking(IdempotentProperties idempotentProperties) {
        concurrentPolicy = idempotentProperties.getConcurrentPolicy();
        count = 1;
        while (true) {
            block8: {
                block7: {
                    if ((rpcIdem = IdempotentStorageHelper.get(idempotentProperties.getStorageStrategy(), idempotentProperties.getDbRoute(), idempotentProperties.getIdempotentKey())) == null) {
                        IdempotentStorageHelper.save(idempotentProperties.getStorageStrategy(), idempotentProperties.getDbRoute(), idempotentProperties);
                        return false;
                    }
                    currentTimeMillis = System.currentTimeMillis();
                    if (currentTimeMillis >= rpcIdem.getAliveTime() + rpcIdem.getRenewalTime()) ** GOTO lbl25
                    executeStatus = rpcIdem.getExecuteStatus();
                    if ("1".equals(executeStatus)) {
                        return true;
                    }
                    if (!"2".equals(executeStatus)) break block7;
                    IdempotentStorageHelper.deleteIdem(idempotentProperties.getStorageStrategy(), idempotentProperties.getDbRoute(), idempotentProperties.getIdempotentKey());
                    break block8;
                }
                if (currentTimeMillis >= rpcIdem.getRenewalTime() + IdempotentWatchDog.INTERVAL_TIME) ** GOTO lbl25
                if (ConcurrentPolicyEnum.COPY_EXECUTE_RESULT == concurrentPolicy) {
                    try {
                        Thread.sleep(100L * (long)count);
                    }
                    catch (InterruptedException e) {
                        IdempotentServiceHelper.logger.error("kd.bos.kdtx.common.idemponent.helper.IdempotentServiceHelper.doIdempotentByBlocking:Thread name={},error={}", (Object)Thread.currentThread().getName(), (Object)e.getMessage());
                    }
                } else {
                    return true;
lbl25:
                    // 2 sources

                    IdempotentStorageHelper.deleteIdem(idempotentProperties.getStorageStrategy(), idempotentProperties.getDbRoute(), idempotentProperties.getIdempotentKey());
                }
            }
            ++count;
        }
    }

    public static <T extends Serializable> T getConcurrentResult(IdempotentProperties idempotentProperties, Class<T> tClass) {
        ConcurrentPolicyEnum concurrentPolicy = idempotentProperties.getConcurrentPolicy();
        if (ConcurrentPolicyEnum.QUICK_RETURN == concurrentPolicy) {
            return (T)QuickReturnStrategy.result(tClass);
        }
        if (ConcurrentPolicyEnum.COPY_EXECUTE_RESULT == concurrentPolicy) {
            return ResultCopyStrategy.result(idempotentProperties, tClass);
        }
        return QuickExceptionStrategy.result();
    }

    public static void executeCompleted(StorageStrategyEnum storageStrategy, DBRoute dbRoute, String idempotentKey, ConcurrentPolicyEnum concurrentPolicy, String result) throws Exception {
        if (IdempotentServiceHelper.skipIdempotentCheck()) {
            return;
        }
        IdempotentStorageHelper.executeCompleted(storageStrategy, dbRoute, idempotentKey, result);
    }

    public static void executeException(StorageStrategyEnum storageStrategy, DBRoute dbRoute, String idempotentKey) {
        if (IdempotentServiceHelper.skipIdempotentCheck()) {
            return;
        }
        IdempotentStorageHelper.executeException(storageStrategy, dbRoute, idempotentKey);
    }

    public static void retryIdempotent(IdempotentProperties idemProp) {
        try {
            IdempotentServiceHelper.idempotent(idemProp);
        }
        catch (Exception e) {
            throw new RetryIdempotentException(e);
        }
    }

    @Deprecated
    private static void deleteAndRetryIdempotent(IdempotentProperties properties) {
        IdempotentStorageHelper.deleteIdem(properties.getStorageStrategy(), properties.getDbRoute(), properties.getIdempotentKey());
        IdempotentServiceHelper.retryIdempotent(properties);
    }

    private static void validate(IdempotentProperties idempotentProperties) {
        if (idempotentProperties.getAlivedTime() > MAX_ALIVE_TIME) {
            throw new KDException(new ErrorCode("IdempotentServiceHelper.idempotent", ResManager.loadKDString((String)"\u6709\u6548\u65f6\u957falivetime\u5927\u4e8e60\u5929\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"IdempotentServiceHelper_0", (String)"bos-kdtx-common", (Object[])new Object[0])), new Object[0]);
        }
    }

    private static boolean skipIdempotentCheck() {
        boolean lightWeightDeploy = Instance.isLightWeightDeploy();
        String skipIdemCheck = ConfigurationFactory.getGlobalConfiguration().getProperty("skipidemcheck");
        return lightWeightDeploy || "true".equals(skipIdemCheck);
    }

    private static void initTable(DBRoute dbRoute) {
        if (dbRoute == null) {
            return;
        }
        String tableExitsKey = IdempotentServiceHelper.getKey(dbRoute);
        if (!initTableMap.getOrDefault(tableExitsKey, false).booleanValue()) {
            if (!DB.exitsTable((DBRoute)dbRoute, (String)TABLE_NAME)) {
                DB.execute((DBRoute)dbRoute, (String)CREATE_TABLE_SQL);
                DB.execute((DBRoute)dbRoute, (String)CREATE_PK_ID);
            }
            initTableMap.put(tableExitsKey, true);
        }
        for (String alterSql : IdempotentServiceHelper.getAlterTableSql(dbRoute)) {
            DB.execute((DBRoute)dbRoute, (String)alterSql);
        }
    }

    private static List<String> getAlterTableSql(DBRoute dbRoute) {
        return new ArrayList<String>();
    }

    private static String getKey(DBRoute routeKey) {
        StringBuilder sb = new StringBuilder(RequestContext.get().getTenantId());
        sb.append("_");
        sb.append(RequestContext.get().getAccountId());
        sb.append("_");
        sb.append(routeKey.getRouteKey());
        return sb.toString();
    }
}

