/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.common.idemponent.storage;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.common.idemponent.exception.IdemKeyConflictException;
import kd.bos.kdtx.common.idemponent.pojo.RpcIdempotentProcess;
import kd.bos.kdtx.common.idemponent.storage.IdempotentStorageService;
import kd.bos.kdtx.common.idemponent.utils.DateUtils;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;

public class IdempotentRedisStorageImpl
implements IdempotentStorageService {
    private static final String REDIS_REGION = "idempontent";
    private static final String PREFIX = "IDEM:";
    private static final String PATTERN = "yyyy-MM-dd HH:mm:ss.sss";

    @Override
    public void save(DBRoute dbRoute, RpcIdempotentProcess rpcIdempotentProcess) {
        String idempotentKey = rpcIdempotentProcess.getIdempotentKey();
        String createdTime = DateUtils.formatDateToStr(rpcIdempotentProcess.getCreatedTime(), PATTERN);
        Long expireTime = rpcIdempotentProcess.getAliveTime();
        String aliveTime = String.valueOf(expireTime);
        String executeStatus = rpcIdempotentProcess.getExecuteStatus();
        String renewalTime = String.valueOf(rpcIdempotentProcess.getRenewalTime());
        String renewalInstance = rpcIdempotentProcess.getRenewalInstance();
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String redisIdemKey = PREFIX + tenantId + ":" + accountId + ":" + idempotentKey;
        String renewalInstanceKey = PREFIX + tenantId + ":" + accountId + ":" + renewalInstance;
        try (JedisClient jedisClient = IdempotentRedisStorageImpl.getJedisClient();){
            String rpcLua = "if (redis.call('exists', KEYS[1]) == 0) then redis.call('hmset', KEYS[1], 'idempotentKey', ARGV[1], 'createdTime', ARGV[2], 'aliveTime', ARGV[3], 'executeStatus', ARGV[4], 'renewalTime', ARGV[5], 'renewalInstance', ARGV[6]); redis.call('pexpire',KEYS[1] , ARGV[8]); return 1;else return 0;end;";
            Object result = jedisClient.eval(rpcLua, 1, new String[]{redisIdemKey, idempotentKey, createdTime, aliveTime, executeStatus, renewalTime, renewalInstance, idempotentKey, String.valueOf(expireTime + 90000L)});
            if ("0".equals(result.toString())) {
                throw new RuntimeException("Idempotent key conflict!");
            }
            String jvmLua = "redis.call('sadd', KEYS[1], ARGV[1]);redis.call('pexpire',KEYS[1] , 90000);";
            jedisClient.eval(jvmLua, 1, new String[]{renewalInstanceKey, redisIdemKey});
        }
        catch (IdemKeyConflictException e) {
            throw e;
        }
        catch (Exception e) {
            ExceptionLogger.error(IdempotentRedisStorageImpl.class, "hmset error. ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RpcIdempotentProcess get(DBRoute dbRoute, String idempotentKey) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String redisIdemKey = PREFIX + tenantId + ":" + accountId + ":" + idempotentKey;
        try (JedisClient jedisClient = IdempotentRedisStorageImpl.getJedisClient();){
            List hmGetList = jedisClient.hmget(redisIdemKey, new String[]{"idempotentKey", "createdTime", "aliveTime", "executeStatus", "renewalTime", "renewalInstance"});
            if (hmGetList != null) {
                hmGetList.removeIf(new Predicate<String>(){

                    @Override
                    public boolean test(String s) {
                        return s == null;
                    }
                });
            }
            if (hmGetList == null || hmGetList.isEmpty()) {
                RpcIdempotentProcess rpcIdempotentProcess2 = null;
                return rpcIdempotentProcess2;
            }
            String instanceId = (String)hmGetList.get(5);
            String key = PREFIX + tenantId + ":" + accountId + ":" + instanceId;
            boolean isUseNewRenewalTime = jedisClient.sismember(key, idempotentKey);
            Long renewalTime = isUseNewRenewalTime ? System.currentTimeMillis() : Long.parseLong((String)hmGetList.get(4));
            RpcIdempotentProcess rpcIdempotentProcess3 = new RpcIdempotentProcess();
            rpcIdempotentProcess3.setIdempotentKey((String)hmGetList.get(0));
            try {
                rpcIdempotentProcess3.setCreatedTime(DateUtils.formatStrToDate((String)hmGetList.get(1), PATTERN));
            }
            catch (ParseException e) {
                rpcIdempotentProcess3.setCreatedTime(new Date());
                ExceptionLogger.error(IdempotentRedisStorageImpl.class, "createTime parse exception" + (String)hmGetList.get(1), e);
            }
            rpcIdempotentProcess3.setAliveTime(Long.valueOf((String)hmGetList.get(2)));
            rpcIdempotentProcess3.setExecuteStatus((String)hmGetList.get(3));
            rpcIdempotentProcess3.setRenewalTime(renewalTime);
            rpcIdempotentProcess3.setRenewalInstance((String)hmGetList.get(5));
            RpcIdempotentProcess rpcIdempotentProcess = rpcIdempotentProcess3;
            return rpcIdempotentProcess;
        }
        catch (Exception e) {
            ExceptionLogger.error(IdempotentRedisStorageImpl.class, "get idempotentKey. ", e);
            return null;
        }
    }

    @Override
    public void renewal(DBRoute dbRoute, String renewalInstance) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String renewalInstanceKey = PREFIX + tenantId + ":" + accountId + ":" + renewalInstance;
        try (JedisClient jedisClient = IdempotentRedisStorageImpl.getJedisClient();){
            Set rpcKeys = jedisClient.smembers(renewalInstanceKey);
            jedisClient.pexpire(renewalInstanceKey, 90000L);
            for (String rpcKey : rpcKeys) {
                String lua = "if (redis.call('exists', KEYS[1]) == 1) then local expiretime = redis.call('hget', KEYS[1], 'aliveTime');if expiretime ~= nil then    redis.call('pexpire', KEYS[1], tonumber(expiretime) + tonumber(90000));end;end;";
                jedisClient.eval(lua, 1, new String[]{rpcKey});
            }
        }
        catch (Exception e) {
            ExceptionLogger.error(IdempotentRedisStorageImpl.class, "redis renewal err " + renewalInstanceKey, e);
        }
    }

    @Override
    public String copySuccessResult(DBRoute dbRoute, String idempotentKey) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String redisIdemKey = PREFIX + tenantId + ":" + accountId + ":" + idempotentKey;
        String result = "";
        try (JedisClient jedisClient = IdempotentRedisStorageImpl.getJedisClient();){
            if (jedisClient.exists(redisIdemKey).booleanValue()) {
                result = jedisClient.hget(redisIdemKey, "result");
            }
        }
        catch (Exception e) {
            ExceptionLogger.error(IdempotentRedisStorageImpl.class, "redis get idempotentKey. ", e);
        }
        return result;
    }

    @Override
    public void executeCompleted(DBRoute dbRoute, final String idempotentKey, final String result) {
        boolean inTX = TX.inTX();
        if (inTX) {
            TX.addCommitListener((CommitListener)new CommitListener(){

                public void onCommitted() {
                    IdempotentRedisStorageImpl.this.doComplete(idempotentKey, result);
                }

                public void onRollbacked() {
                    IdempotentRedisStorageImpl.this.deleteKeys(idempotentKey);
                }
            });
        } else {
            this.doComplete(idempotentKey, result);
        }
    }

    private void doComplete(String idempotentKey, String result) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String redisIdemKey = PREFIX + tenantId + ":" + accountId + ":" + idempotentKey;
        try (JedisClient jedisClient = IdempotentRedisStorageImpl.getJedisClient();){
            List hmGetList = jedisClient.hmget(redisIdemKey, new String[]{"renewalInstance", "aliveTime"});
            String renewalInstanceKey = PREFIX + tenantId + ":" + accountId + ":" + (String)hmGetList.get(0);
            String aliveTime = (String)hmGetList.get(1);
            String lua = " redis.call('hmset', KEYS[1], 'renewalTime', ARGV[1], 'executeStatus', '1', 'result', ARGV[2]); redis.call('pexpire', KEYS[1], ARGV[3]); ";
            jedisClient.eval(lua, 1, new String[]{redisIdemKey, String.valueOf(System.currentTimeMillis()), result, aliveTime});
            jedisClient.srem(renewalInstanceKey, new String[]{redisIdemKey});
        }
        catch (Exception e) {
            ExceptionLogger.error(IdempotentRedisStorageImpl.class, "redis executeCompleted error. " + idempotentKey, e);
        }
    }

    @Override
    public void executeException(DBRoute dbRoute, String idempotentKey) {
        try {
            this.deleteKeys(idempotentKey);
        }
        catch (Exception e) {
            ExceptionLogger.error(IdempotentRedisStorageImpl.class, "redis executeException error. " + idempotentKey, e);
        }
    }

    @Override
    public void cleanHistory(DBRoute dbRoute) {
    }

    @Override
    public void deleteIdem(DBRoute dbRoute, String idempotentKey) {
        try {
            this.deleteKeys(idempotentKey);
        }
        catch (Exception e) {
            ExceptionLogger.error(IdempotentRedisStorageImpl.class, "redis deleteIdem error. " + idempotentKey, e);
        }
    }

    private void deleteKeys(String idempotentKey) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String redisIdemKey = PREFIX + tenantId + ":" + accountId + ":" + idempotentKey;
        try (JedisClient jedisClient = IdempotentRedisStorageImpl.getJedisClient();){
            List hmGetList = jedisClient.hmget(redisIdemKey, new String[]{"renewalInstance", "aliveTime"});
            String renewalInstanceKey = PREFIX + tenantId + ":" + accountId + ":" + (String)hmGetList.get(0);
            jedisClient.del(redisIdemKey);
            jedisClient.srem(renewalInstanceKey, new String[]{redisIdemKey});
        }
    }

    private static JedisClient getJedisClient() {
        return RedisFactory.getJedisClient((String)IdempotentRedisStorageImpl.getRedisUrl());
    }

    private static String getRedisUrl() {
        String configKey = CacheConfigKeys.getSessionlessConfigKey((String)REDIS_REGION);
        String url = System.getProperty(configKey);
        if (url == null) {
            configKey = CacheConfigKeys.getSessionlessConfigKey(null);
            url = System.getProperty(configKey);
        }
        return url;
    }
}

