/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.common.idemponent.storage;

import java.util.Date;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.idemponent.pojo.RpcIdempotentProcess;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.properties.StorageStrategyEnum;
import kd.bos.kdtx.common.idemponent.storage.IdempotentDbStorageImpl;
import kd.bos.kdtx.common.idemponent.storage.IdempotentRedisStorageImpl;
import kd.bos.kdtx.common.idemponent.storage.IdempotentStorageService;
import kd.bos.kdtx.common.idemponent.utils.RenewalInstanceUtil;

public class IdempotentStorageHelper {
    private static IdempotentStorageService dbStorage = new IdempotentDbStorageImpl();
    private static IdempotentStorageService redisStorage = new IdempotentRedisStorageImpl();

    private static IdempotentStorageService getStorageImpl(StorageStrategyEnum storageStrategy) {
        if (StorageStrategyEnum.REDIS == storageStrategy) {
            return redisStorage;
        }
        return dbStorage;
    }

    public static String copySuccessResult(StorageStrategyEnum storageStrategy, DBRoute dbRoute, String renewalInstance) {
        return IdempotentStorageHelper.getStorageImpl(storageStrategy).copySuccessResult(dbRoute, renewalInstance);
    }

    public static void cleanHistory(DBRoute dbRoute) {
        dbStorage.cleanHistory(dbRoute);
    }

    public static void renewal(DBRoute dbRoute, String renewalInstance) {
        dbStorage.renewal(dbRoute, renewalInstance);
    }

    public static RpcIdempotentProcess get(StorageStrategyEnum storageStrategy, DBRoute dbRoute, String idempotentKey) {
        return IdempotentStorageHelper.getStorageImpl(storageStrategy).get(dbRoute, idempotentKey);
    }

    public static void save(StorageStrategyEnum storageStrategy, DBRoute dbRoute, IdempotentProperties idempotentProperties) {
        RpcIdempotentProcess rpcIdempotentProcess = new RpcIdempotentProcess(idempotentProperties.getIdempotentKey(), new Date(), RenewalInstanceUtil.getRenewalInstance(), System.currentTimeMillis(), idempotentProperties.getAlivedTime(), "0");
        IdempotentStorageHelper.getStorageImpl(storageStrategy).save(dbRoute, rpcIdempotentProcess);
    }

    public static void executeCompleted(StorageStrategyEnum storageStrategy, DBRoute dbRoute, String idempotentKey, String result) {
        IdempotentStorageHelper.getStorageImpl(storageStrategy).executeCompleted(dbRoute, idempotentKey, result);
    }

    public static void executeException(StorageStrategyEnum storageStrategy, DBRoute dbRoute, String idempotentKey) {
        IdempotentStorageHelper.getStorageImpl(storageStrategy).executeException(dbRoute, idempotentKey);
    }

    public static void deleteIdem(StorageStrategyEnum storageStrategy, DBRoute dbRoute, String idempotentKey) {
        IdempotentStorageHelper.getStorageImpl(storageStrategy).deleteIdem(dbRoute, idempotentKey);
    }
}

