/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.common.idemponent.watchdog;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.idemponent.pojo.IdempotentNamespace;
import kd.bos.kdtx.common.idemponent.storage.IdempotentRedisStorageImpl;
import kd.bos.kdtx.common.idemponent.storage.IdempotentStorageHelper;
import kd.bos.kdtx.common.idemponent.utils.IdempotentNamespacePool;
import kd.bos.kdtx.common.idemponent.utils.RenewalInstanceUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class IdempotentWatchDog
implements Runnable {
    private static final Log logger = LogFactory.getLog(IdempotentWatchDog.class);
    private volatile Map<String, DBRoute> dbRouteMap = new HashMap<String, DBRoute>();
    public static final Long INTERVAL_TIME = 90L;
    private static int RENEWAL_TIME = 60;
    private static final IdempotentRedisStorageImpl redisStorage = new IdempotentRedisStorageImpl();

    private IdempotentWatchDog() {
    }

    public static IdempotentWatchDog getInstance() {
        return IdempotentWatchDogSingle.INSTANCE;
    }

    @Override
    public void run() {
        while (true) {
            try {
                TimeUnit.SECONDS.sleep(RENEWAL_TIME);
            }
            catch (InterruptedException e) {
                logger.info("", (Object)e);
            }
            try {
                this.renewal();
                continue;
            }
            catch (Exception e) {
                logger.error("\u7eed\u7ea6\u51fa\u73b0\u5f02\u5e38, \u8bf7\u67e5\u8be2\u8be6\u7ec6\u65e5\u5fd7:", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void renewal() {
        redisStorage.renewal(null, RenewalInstanceUtil.getRenewalInstance());
        Map<String, IdempotentNamespace> namespaceMap = IdempotentNamespacePool.getAll();
        for (Map.Entry<String, IdempotentNamespace> namespaceEntry : namespaceMap.entrySet()) {
            String key = namespaceEntry.getKey();
            IdempotentNamespace namespace = namespaceEntry.getValue();
            String[] tenantIdAccountId = key.split("#");
            RequestContext rc = RequestContext.create();
            rc.setTenantId(tenantIdAccountId[0]);
            rc.setAccountId(tenantIdAccountId[1]);
            RequestContext.copyAndSet((RequestContext)rc);
            Set<String> dbRoutes = namespace.getDbRoutes();
            this.renewalByDBRoute(dbRoutes);
        }
    }

    private void renewalByDBRoute(Set<String> dbRoutes) {
        RequestContext rc = RequestContext.get();
        for (String dbRouteKey : dbRoutes) {
            DBRoute dbRoute = this.dbRouteMap.get(dbRouteKey);
            if (dbRoute == null) {
                dbRoute = DBRoute.of((String)dbRouteKey);
                this.dbRouteMap.put(dbRouteKey, dbRoute);
            }
            try {
                IdempotentStorageHelper.renewal(dbRoute, RenewalInstanceUtil.getRenewalInstance());
            }
            catch (Exception e) {
                logger.warn("\u7eed\u7ea6\u5f02\u5e38,\u79df\u6237:" + rc.getTenantId() + " \u6570\u636e\u4e2d\u5fc3:" + rc.getAccountId(), (Throwable)e);
            }
        }
    }

    private static class IdempotentWatchDogSingle {
        private static final IdempotentWatchDog INSTANCE = new IdempotentWatchDog();

        private IdempotentWatchDogSingle() {
        }
    }
}

