/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.common.log;

import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.kdtx.common.constant.ActionType;
import kd.bos.kdtx.common.constant.TriggerType;
import kd.bos.kdtx.common.constant.TxOperationResult;
import kd.bos.kdtx.common.exception.invoke.BranchBizException;
import kd.bos.kdtx.common.log.MultiDBWriteHandler;
import kd.bos.util.StringUtils;

public class DBLogger {
    public static void updateActionLog(String xid, String branchId, long logId, ActionType actionType, int result, String remark) {
        if (!StringUtils.isEmpty((String)remark) && remark.length() > 1000) {
            remark = remark.substring(0, 1000);
        }
        if (logId != 0L) {
            Object[] params;
            String sql;
            if (ActionType.TX_BEGIN == actionType) {
                sql = "UPDATE t_cbs_dtx_logs SET  fxid = ?,  fremark = ?,  fresult = ?,  fupdate_time = NOW() WHERE  fid = ?";
                params = new Object[]{xid, remark, result, logId};
            } else if (ActionType.BRANCH_REGISTER == actionType) {
                sql = "UPDATE t_cbs_dtx_logs SET  fbranch_id = ?,  fremark = ?,  fresult = ?,  fupdate_time = NOW() WHERE  fid = ?";
                params = new Object[]{branchId, remark, result, logId};
            } else {
                sql = "UPDATE t_cbs_dtx_logs SET  fremark = ?,  fresult = ?,  fupdate_time = NOW() WHERE  fid = ?";
                params = new Object[]{remark, result, logId};
            }
            MultiDBWriteHandler.execute(() -> DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params));
        }
    }

    public static long insertActionLog(String xid, ActionType actionType, String branchId, int triggerType) {
        return DBLogger.insertActionLog(xid, actionType, branchId, 0, "", triggerType);
    }

    public static long insertActionLog(String xid, ActionType actionType, String branchId, int result, String remark, int triggerType) {
        String sql = "INSERT INTO t_cbs_dtx_logs (fid, fxid, fbranch_id, faction_type, ftrigger_type, fresult, fremark, fcreate_time)VALUES (?,?,?,?,?,?,?,NOW())";
        long id = ID.genLongId();
        Object[] params = new Object[]{id, xid, branchId, actionType.getCode(), triggerType, result, remark};
        MultiDBWriteHandler.execute(() -> DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params));
        return id;
    }

    public static void insertActionLog(String xid, long branchId, ActionType actionType, int result, String remark, int triggerType) {
        if (!StringUtils.isEmpty((String)remark) && remark.length() > 1000) {
            remark = remark.substring(0, 1000);
        }
        String sql = "INSERT INTO t_cbs_dtx_logs (fid, fxid, fbranch_id, faction_type, ftrigger_type, fresult, fremark, ftraceid, fcreate_time)VALUES (?,?,?,?,?,?,?,?,NOW())";
        long id = ID.genLongId();
        Object[] params = new Object[]{id, xid, branchId + "", actionType.getCode(), triggerType, result, remark, RequestContext.get().getTraceId()};
        try (TXHandle txHandle = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params);
        }
    }

    public static void traceAction(TraceAction traceAction, String xid, String branchId, ActionType actionType) throws Exception {
        long fid = 0L;
        int result = TxOperationResult.SUCCESS.getCode();
        String remark = "";
        try {
            fid = DBLogger.insertActionLog(xid, actionType, branchId, TriggerType.NORMAL.getCode());
            traceAction.doAction();
        }
        catch (Exception e) {
            result = TxOperationResult.FAIL.getCode();
            remark = BranchBizException.extractBizExceptionStack(e);
            throw e;
        }
        finally {
            DBLogger.updateActionLog(xid, branchId, fid, actionType, result, remark);
        }
    }

    public static interface TraceAction {
        public void doAction() throws Exception;
    }
}

