/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.common.util;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.common.util.LimitedOutputStream;
import kd.bos.mservice.common.serialization.ObjectInput;
import kd.bos.mservice.common.serialization.ObjectOutput;
import kd.bos.mservice.common.serialization.Serialization;
import kd.bos.mservice.common.serialization.support.nativehessian.NativeHessianSerialization;

public class JsonUtils {
    private static final Serialization serialization = new NativeHessianSerialization();

    public static String getParasStr(Object object) {
        return JSON.toJSONString((Object)object);
    }

    public static <T> T parseJson(String json, Class<T> clazz) {
        return (T)JSON.parseObject((String)json, clazz);
    }

    public static byte[] serialization(Object object) {
        byte[] byteArray;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        LimitedOutputStream limitedOutputStream = new LimitedOutputStream(bos);
        try {
            ObjectOutput serialize = serialization.serialize((OutputStream)limitedOutputStream);
            serialize.writeObject(object);
            serialize.flushBuffer();
            byteArray = bos.toByteArray();
        }
        catch (IOException e) {
            throw new KdtxException("serialization error", e);
        }
        finally {
            try {
                limitedOutputStream.close();
            }
            catch (IOException e) {
                throw new KdtxException("serialization error", e);
            }
        }
        return byteArray;
    }

    public static Object deSerialization(byte[] byteArray) {
        ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
        try {
            ObjectInput deserialize = serialization.deserialize((InputStream)bis);
            Object object = deserialize.readObject();
            return object;
        }
        catch (Exception e) {
            throw new KdtxException("deserialization error", e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    throw new KdtxException("deserialization error", e);
                }
            }
        }
    }
}

