/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.common.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import kd.bos.context.KdtxRequestContext;
import kd.bos.kdtx.common.entity.KdtxSuspendInfo;

public class KdtxSuspendProxy {
    private static ThreadLocal<Map<Long, Stack<KdtxSuspendInfo>>> waitCommitStackMap = ThreadLocal.withInitial(HashMap::new);

    public static void addWaitCommit(Long dbTxId, KdtxSuspendInfo suspendInfo) {
        Stack waitCommitStack = waitCommitStackMap.get().computeIfAbsent(dbTxId, key -> new Stack());
        waitCommitStack.push(suspendInfo);
        KdtxRequestContext.get().incrWaitCommitSeze();
    }

    public static Stack<KdtxSuspendInfo> getWaitCommitInfo(Long dbTxId) {
        return waitCommitStackMap.get().get(dbTxId);
    }

    public static void cleanWaitCommit(Long dbTxId) {
        Stack<KdtxSuspendInfo> waitCommitStack = waitCommitStackMap.get().get(dbTxId);
        if (waitCommitStack != null) {
            for (int i = 0; i < waitCommitStack.size(); ++i) {
                KdtxRequestContext.get().decrWaitCommitSize();
            }
        }
        waitCommitStackMap.get().remove(dbTxId);
    }
}

