/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.common.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kd.bos.kdtx.common.config.DtxConfig;

public class LimitedOutputStream
extends FilterOutputStream {
    private long maxSize = DtxConfig.getMaxParamSize();

    public LimitedOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        --this.maxSize;
        if (this.maxSize < 0L) {
            throw new RuntimeException("The param's size is exceeds limit size.");
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.maxSize -= (long)len;
        if (this.maxSize < 0L) {
            throw new RuntimeException("The param's size is exceeds limit size.");
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

