/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kws;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import kd.bos.kws.KWSDomainUrlInterceptor;
import kd.bos.kws.config.MethodDef;
import kd.bos.kws.config.ServiceDef;
import kd.bos.kws.config.WSConfig;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;

public class KWSServlet
extends CXFNonSpringServlet {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(KWSServlet.class);

    protected void loadBus(ServletConfig sc) {
        super.loadBus(sc);
        Bus b = this.getBus();
        BusFactory.setDefaultBus((Bus)b);
        WSConfig wsConfig = WSConfig.get();
        if (wsConfig != null) {
            for (ServiceDef service : wsConfig.getServices()) {
                try {
                    Class<?> clz = Class.forName(service.getClassName());
                    Object serviceImpl = clz.newInstance();
                    JaxWsServerFactoryBean sfb = new JaxWsServerFactoryBean();
                    sfb.getInInterceptors().add(new KWSDomainUrlInterceptor());
                    sfb.setServiceClass(clz);
                    sfb.setAddress("/" + service.getName());
                    sfb.setServiceBean(serviceImpl);
                    List<MethodDef> methodDefs = service.getMethods();
                    if (methodDefs != null && !methodDefs.isEmpty()) {
                        Method[] methods = clz.getMethods();
                        ArrayList<Method> ignoredMethods = new ArrayList<Method>();
                        for (Method method : methods) {
                            boolean isIgnoreMethod = true;
                            for (MethodDef methodDef : service.getMethods()) {
                                if (!method.getName().equalsIgnoreCase(methodDef.getName())) continue;
                                isIgnoreMethod = false;
                                break;
                            }
                            if (!isIgnoreMethod) continue;
                            ignoredMethods.add(method);
                        }
                        sfb.getServiceFactory().setIgnoredMethods(ignoredMethods);
                    }
                    sfb.create();
                }
                catch (Exception e) {
                    log.error("WebService init service error:serviceName = " + service.getName() + " exception:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
        }
    }
}

