/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kws.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import kd.bos.kws.config.MethodDef;
import kd.bos.kws.config.ServiceDef;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;

@XmlRootElement(name="root")
public class WSConfig {
    private static Log log = LogFactory.getLog(WSConfig.class);
    private List<ServiceDef> services = new ArrayList<ServiceDef>();

    @XmlElements(value={@XmlElement(name="service", type=ServiceDef.class)})
    public List<ServiceDef> getServices() {
        return this.services;
    }

    public void setServices(List<ServiceDef> services) {
        this.services = services;
    }

    public static WSConfig get() {
        WSConfig fileWSC = WSConfig.loadWsConfigFile();
        WSConfig mcWSC = WSConfig.loadWsMCConfig();
        return WSConfig.mergeWSConfig(fileWSC, mcWSC);
    }

    private static WSConfig mergeWSConfig(WSConfig left, WSConfig right) {
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        List<ServiceDef> leftServices = left.getServices();
        List<ServiceDef> rightServices = right.getServices();
        for (ServiceDef leftService : leftServices) {
            String name = leftService.getName();
            String className = leftService.getClassName();
            List<MethodDef> leftMethods = leftService.getMethods();
            Iterator<ServiceDef> iterator = rightServices.iterator();
            while (iterator.hasNext()) {
                ServiceDef rightService = iterator.next();
                if (!name.equalsIgnoreCase(rightService.getName())) continue;
                if (className.equals(rightService.getClassName())) {
                    if (leftMethods.isEmpty() || rightService.getMethods().isEmpty()) {
                        leftService.setMethods(new ArrayList<MethodDef>());
                    } else {
                        leftMethods.addAll(rightService.getMethods());
                        leftService.setMethods(leftMethods);
                    }
                }
                iterator.remove();
            }
        }
        leftServices.addAll(rightServices);
        left.setServices(leftServices);
        return left;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WSConfig loadWsMCConfig() {
        String configFiles;
        WSConfig wsConfig = null;
        String xml = System.getProperty("kws.config");
        if (StringUtils.isNotEmpty((String)xml)) {
            wsConfig = WSConfig.parse(xml);
        }
        if ((configFiles = System.getProperty("kws.filepath.config")) != null && configFiles.trim().length() > 0) {
            for (String configFile : configFiles.split(",")) {
                InputStream in = null;
                try {
                    if (configFile.trim().endsWith(".xml")) {
                        if (!configFile.startsWith("/")) {
                            configFile = "/" + configFile;
                        }
                        if ((in = WSConfig.class.getResourceAsStream(configFile)) == null) continue;
                        xml = StringUtils.fromInputStream((InputStream)in, (String)"UTF-8");
                        wsConfig = WSConfig.mergeWSConfig(wsConfig, WSConfig.parse(xml));
                        continue;
                    }
                    log.error("kws config error ,which not end with .xml:\u3000" + configFile);
                }
                catch (IOException e) {
                    log.error("Can't load file :" + configFile, (Throwable)e);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            log.error((Throwable)e);
                        }
                    }
                }
            }
        }
        return wsConfig;
    }

    private static WSConfig loadWsConfigFile() {
        String xml = null;
        InputStream in = null;
        try {
            in = WSConfig.class.getResourceAsStream("/webservice/kwsconfig.xml");
            xml = StringUtils.fromInputStream((InputStream)in, (String)"UTF-8");
        }
        catch (Exception e) {
            log.error("Can't load /webservice/kwsconfig.xml \n" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
        }
        if (xml == null) {
            return null;
        }
        return WSConfig.parse(xml);
    }

    private static WSConfig parse(String xml) {
        return WSConfig.parse(new StringReader(xml));
    }

    private static WSConfig parse(StringReader reader) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{WSConfig.class});
            XMLInputFactory xif = XMLInputFactory.newInstance();
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xif.setProperty("javax.xml.stream.supportDTD", true);
            XMLStreamReader xsr = xif.createXMLStreamReader(reader);
            Unmarshaller un = jaxbContext.createUnmarshaller();
            WSConfig wsConfig = (WSConfig)un.unmarshal(xsr);
            return wsConfig;
        }
        catch (Exception t) {
            log.error("kws config parse error xml=" + reader.toString(), (Throwable)t);
            return null;
        }
    }
}

