/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.database;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.database.DbSessionableCacheException;
import kd.bos.cache.database.Executor;
import kd.bos.cache.database.TableName;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;

public class DBExecutor
implements Executor {
    public static final DBExecutor instance = new DBExecutor();

    private DBExecutor() {
    }

    @Override
    public void createTableOrIndex(String sql) {
        try {
            DB.execute((DBRoute)DBRoute.log, (String)sql);
        }
        catch (Exception e) {
            throw new DbSessionableCacheException(e, "create table error", new Object[0]);
        }
    }

    @Override
    public String query(String sessionId, String field) {
        String tableName = TableName.getTableName(sessionId);
        String sql = "select fvalue from " + tableName + " where fkey = ? and ffield = ?";
        try {
            return (String)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])new Object[]{Executor.getKey(sessionId), field}, resultSet -> {
                if (resultSet.next()) {
                    return resultSet.getString("fvalue");
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new DbSessionableCacheException(e, "query session error,sessionId: %s, field: %s", sessionId, field);
        }
    }

    @Override
    public List<String> getKeysWithPrefix(String sessionId, String prefix) {
        String tableName = TableName.getTableName(sessionId);
        String sql = "select ffield from " + tableName + " where fkey = ?";
        if (prefix == null) {
            sql = sql + " and ffield like " + prefix + "%";
        }
        try {
            return (List)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])new Object[]{Executor.getKey(sessionId)}, rs -> {
                ArrayList<String> results = new ArrayList<String>(16);
                while (rs.next()) {
                    results.add(rs.getString("ffield"));
                }
                return results;
            });
        }
        catch (Exception e) {
            throw new DbSessionableCacheException(e, "get keys error,tableName: %s,sessionId: %s, prefix: %s", tableName, sessionId, prefix);
        }
    }

    @Override
    public List<String> query(String sessionId, String[] fields) {
        ArrayList results = new ArrayList();
        String tableName = TableName.getTableName(sessionId);
        String sql = "select ffield,fvalue from " + tableName + " where fkey = ?";
        try {
            return (List)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])new Object[]{Executor.getKey(sessionId)}, rs -> {
                HashMap<String, String> map = new HashMap<String, String>(fields.length);
                while (rs.next()) {
                    map.put(rs.getString("ffield"), rs.getString("fvalue"));
                }
                for (String field : fields) {
                    results.add(map.get(field));
                }
                return results;
            });
        }
        catch (Exception e) {
            throw new DbSessionableCacheException(e, "query error, tableName: %s, sessionId: %s", tableName, sessionId);
        }
    }

    @Override
    public Map<String, String> queryAll(String sessionId) {
        String tableName = TableName.getTableName(sessionId);
        String sql = "select ffield,fvalue from " + tableName + " where fkey = ?";
        try {
            return (Map)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])new Object[]{Executor.getKey(sessionId)}, resultSet -> {
                HashMap<String, String> result = new HashMap<String, String>(8);
                while (resultSet.next()) {
                    String field = resultSet.getString("ffield");
                    result.put(field, resultSet.getString("fvalue"));
                }
                return result;
            });
        }
        catch (Exception e) {
            throw new DbSessionableCacheException(e, "query error, tableName: %s, sessionId: %s", tableName, sessionId);
        }
    }

    @Override
    public void put(String sessionId, String field, String value) {
        String tableName = TableName.getTableName(sessionId);
        String delete = "delete from " + tableName + " where fkey = ? and ffield = ?";
        String insert = "insert into " + tableName + "(fkey,ffield,fvalue,ftime,fexpire) values(?,?,?,now(),-1)";
        String key = Executor.getKey(sessionId);
        try (TXHandle handle = TX.requiresNew((String)"put");){
            DB.execute((DBRoute)DBRoute.log, (String)delete, (Object[])new Object[]{key, field});
            DB.execute((DBRoute)DBRoute.log, (String)insert, (Object[])new Object[]{key, field, value});
        }
    }

    @Override
    public void putAll(String sessionId, Map<String, String> keyValues) {
        String tableName = TableName.getTableName(sessionId);
        String key = Executor.getKey(sessionId);
        Set<Map.Entry<String, String>> entrySet = keyValues.entrySet();
        Iterator<Map.Entry<String, String>> iterator = entrySet.iterator();
        ArrayList<String> questionMark = new ArrayList<String>(16);
        String insert = "insert into " + tableName + "(fkey,ffield,fvalue,ftime,fexpire) values(?,?,?,now(),-1)";
        Object[] fields = new Object[keyValues.size() + 1];
        int i = 0;
        try {
            ArrayList<String[]> params = new ArrayList<String[]>(32);
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                String entryKey = entry.getKey();
                String entryValue = entry.getValue();
                fields[i] = entryKey;
                questionMark.add("?");
                String[] objects = new String[]{key, entryKey, entryValue};
                params.add(objects);
                ++i;
            }
            fields[i] = key;
            StringBuilder delete = new StringBuilder("delete from " + tableName + " where ffield in (");
            delete.append(String.join((CharSequence)",", questionMark)).append(") and fkey = ?");
            try (TXHandle handle = TX.requiresNew((String)"putAll");){
                DB.execute((DBRoute)DBRoute.log, (String)delete.toString(), (Object[])fields);
                DB.executeBatch((DBRoute)DBRoute.log, (String)insert, params);
            }
        }
        catch (Exception e) {
            throw new DbSessionableCacheException(e, "put error, tableName: %s,sessionId: %s", tableName, sessionId);
        }
    }

    @Override
    public void remove(String sessionId, String ... keys) {
        String tableName = TableName.getTableName(sessionId);
        String key = Executor.getKey(sessionId);
        Object[] params = new String[keys.length + 1];
        params[0] = key;
        StringBuilder sql = new StringBuilder("delete from ").append(tableName).append(" where fkey = ?");
        if (keys.length > 0) {
            ArrayList<String> questionMark = new ArrayList<String>(16);
            for (int i = 0; i < keys.length; ++i) {
                params[i + 1] = keys[i];
                questionMark.add("?");
            }
            sql.append("and ffield in (").append(String.join((CharSequence)",", questionMark)).append(")");
        }
        try (TXHandle handle = TX.requiresNew((String)"remove");){
            DB.execute((DBRoute)DBRoute.log, (String)sql.toString(), (Object[])params);
        }
        catch (Exception e) {
            throw new DbSessionableCacheException(e, "remove error, tableName: %s,sessionId: %s", tableName, sessionId);
        }
    }

    @Override
    public void expireAfter(String sessionId, int second) {
        String tableName = TableName.getTableName(sessionId);
        String key = Executor.getKey(sessionId);
        String sql = "update " + tableName + " set fexpire = ?,ftime = now() where fkey = ?";
        try (TXHandle handle = TX.requiresNew((String)"expireAfter");){
            DB.execute((DBRoute)DBRoute.log, (String)sql, (Object[])new Object[]{second, key});
        }
        catch (Exception e) {
            throw new DbSessionableCacheException(e, "expireAfter error, tableName: %s,sessionId: %s", tableName, sessionId);
        }
    }

    @Override
    public void deleteExpired() {
        Collection<String> tableNames = TableName.getAllTableName();
        for (String tableName : tableNames) {
            String sql = "delete from " + tableName + " where DATEDIFF(ftime,now()) > fexpire and fexpire != -1";
            try {
                DB.execute((DBRoute)DBRoute.log, (String)sql);
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void insert(String key, String field, String value) {
        String tableName = TableName.getTableName(key);
        String delete = "delete from " + tableName + " where fkey = ? and ffield = ?";
        String insert = "insert into " + tableName + "(fkey,ffield,fvalue,ftime,fexpire) values(?,?,?,now(),?)";
        try (TXHandle handle = TX.requiresNew((String)"insert");){
            DB.execute((DBRoute)DBRoute.log, (String)delete, (Object[])new Object[]{key, field});
            DB.execute((DBRoute)DBRoute.log, (String)insert, (Object[])new Object[]{key, field, value, -1});
        }
        catch (Exception e) {
            throw new DbSessionableCacheException(e, "expireAfter error, tableName: %s,sessionId: %s", tableName, key);
        }
    }

    @Override
    public void delete(String ... sessionIds) {
        for (String sessionId : sessionIds) {
            StringBuilder sb = new StringBuilder("delete from ").append(TableName.getTableName(sessionId)).append(" where fkey = ").append(sessionId);
            try {
                DB.execute((DBRoute)DBRoute.log, (String)sb.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean exists(String sessionId) {
        String tableName = TableName.getTableName(sessionId);
        String sql = "select fkey from " + tableName + " where fkey = ?";
        try {
            return (Boolean)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])new Object[]{Executor.getKey(sessionId)}, resultSet -> {
                if (resultSet.next()) {
                    String fkey = resultSet.getString("fkey");
                    return fkey != null;
                }
                return false;
            });
        }
        catch (Exception e) {
            throw new DbSessionableCacheException(e, "exists error, tableName: %s,sessionId: %s", tableName, sessionId);
        }
    }
}

