/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.database;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import kd.bos.cache.database.Asserts;
import kd.bos.db.datasource.DataSourceURLs;
import kd.bos.dc.utils.MCApiUtil;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.ksql.DbType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.SystemProperties;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.parameter.AbstractParameterFiller;
import kd.bos.xdb.parameter.ParameterFillerFactory;

class DbConnectionFactory {
    private static final Log log = LogFactory.getLog(DbConnectionFactory.class);
    private static final String databaseConfig = SystemProperties.getWithEnv((String)"db.serversForSession");
    protected static final boolean aloneDatasource = Boolean.getBoolean("ha.component.db.alone.enable");
    private static final Map<String, DataSource> DATASOURCE_MAP = new ConcurrentHashMap<String, DataSource>(8);
    protected static AbstractParameterFiller parameter;
    public static final String MC_API_GET_MC_DATA = "/kapi/app/mc/DataSaveGetService";
    public static final String MONITOR_DB_CONFIG_ZK_PATH = "/runtime/monitor/config/dbConfig";

    private DbConnectionFactory() {
    }

    static DbConnectionFactory getInstance() {
        return Hold.dbConnectionFactory;
    }

    private static DataSource initAloneDatasource() {
        Properties prop = new Properties();
        StringReader reader = new StringReader(databaseConfig);
        try {
            prop.load(reader);
            String dbTypeStr = prop.getProperty("dbType");
            String ip = prop.getProperty("ip");
            String schema = prop.getProperty("schema");
            String userName = prop.getProperty("userName");
            String passwd = prop.getProperty("password");
            return DbConnectionFactory.createDatasource(dbTypeStr, ip, prop.getProperty("port"), schema, userName, passwd);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.systemError, new Object[]{"datasouce init error"});
        }
    }

    private static DataSource initMonitorDatasource() {
        try {
            HashMap<String, String> map = new HashMap<String, String>(3);
            map.put("DCID", Instance.getClusterName());
            map.put("key", MONITOR_DB_CONFIG_ZK_PATH);
            String dbConfig = (String)MCApiUtil.getMCAPIInfo((String)MC_API_GET_MC_DATA, (boolean)true, null, map);
            if (dbConfig != null) {
                Map config = (Map)JSONUtils.cast((String)dbConfig, Map.class, (boolean)true);
                config.put("password", Encrypters.decode((String)config.get("password").toString()));
                int dbType = (Integer)config.get("dbType");
                String dbTypeStr = DbType.getName((int)dbType);
                return DbConnectionFactory.createDatasource(dbTypeStr, config.get("ip").toString(), config.get("port") + "", config.get("dbName").toString(), config.get("userName").toString(), config.get("password").toString());
            }
        }
        catch (Exception e) {
            if (e instanceof KDException) {
                if (!"626".equals(((KDException)((Object)e)).getErrorCode().getCode())) {
                    log.error("The MonitorDbManager.getDbConfig query db error,errorMessage:" + ((KDException)((Object)e)).getArgs(), (Throwable)e);
                }
            }
            log.error("The MCReporter.saveMonitorDbConfig query db error,errorMessage:" + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static DataSource createDatasource(String dbTypeStr, String ip, String portStr, String schema, String userName, String password) {
        DBType xdbDbType;
        kd.bos.db.DBType type;
        HikariConfig hikariConfig = new HikariConfig();
        int dbType = DbType.getValue((String)dbTypeStr);
        Asserts.notEmpty(dbTypeStr, "database dbType is null");
        switch (dbType) {
            case 2: {
                type = kd.bos.db.DBType.Oracle;
                xdbDbType = DBType.oracle;
                break;
            }
            case 5: {
                type = kd.bos.db.DBType.PostgreSQL;
                xdbDbType = DBType.postgresql;
                break;
            }
            case 6: {
                type = kd.bos.db.DBType.MySQL;
                xdbDbType = DBType.mysql;
                break;
            }
            case 11: {
                type = kd.bos.db.DBType.DM;
                xdbDbType = DBType.dm;
                break;
            }
            case 12: {
                type = kd.bos.db.DBType.GS;
                xdbDbType = DBType.gs;
                break;
            }
            case 13: {
                type = kd.bos.db.DBType.GS100;
                xdbDbType = DBType.gs100;
                break;
            }
            case 14: {
                type = kd.bos.db.DBType.GaussDB;
                xdbDbType = DBType.gaussdb;
                break;
            }
            case 15: {
                type = kd.bos.db.DBType.KingBase;
                xdbDbType = DBType.kingbase;
                break;
            }
            case 16: {
                type = kd.bos.db.DBType.Vastbase;
                xdbDbType = DBType.vastbase;
                break;
            }
            case 17: {
                type = kd.bos.db.DBType.TDSQL;
                xdbDbType = DBType.tdsql;
                break;
            }
            case 18: {
                type = kd.bos.db.DBType.Gbase;
                xdbDbType = DBType.gbase;
                break;
            }
            case 19: {
                type = kd.bos.db.DBType.TiDB;
                xdbDbType = DBType.tidb;
                break;
            }
            case 20: {
                type = kd.bos.db.DBType.YasDB;
                xdbDbType = DBType.yasdb;
                break;
            }
            case 103: {
                type = kd.bos.db.DBType.Gauss200;
                xdbDbType = DBType.gauss200;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported database type");
            }
        }
        parameter = ParameterFillerFactory.get((DBType)xdbDbType);
        Asserts.notEmpty(ip, "database ip is nul");
        Asserts.notEmpty(portStr, "database port is nul");
        int port = Integer.parseInt(portStr);
        Asserts.notEmpty(schema, "database schema is nul");
        String url = DataSourceURLs.genURL((kd.bos.db.DBType)type, (String)ip, (int)port, (String)schema);
        hikariConfig.setJdbcUrl(url);
        Asserts.notEmpty(userName, "database userName is null");
        hikariConfig.setUsername(userName);
        Asserts.notEmpty(password, "database password is null");
        String decode = Encrypters.decode((String)password);
        hikariConfig.setPassword(decode);
        hikariConfig.setDriverClassName("kd.bos.ksql.shell.Driver");
        hikariConfig.setConnectionTestQuery("select 1;");
        hikariConfig.setConnectionTimeout(60000L);
        hikariConfig.setMaximumPoolSize(20);
        hikariConfig.setIdleTimeout(5000L);
        hikariConfig.setMinimumIdle(5);
        hikariConfig.setAutoCommit(false);
        return new HikariDataSource(hikariConfig);
    }

    Connection getConnection() throws SQLException {
        DataSource dataSource = aloneDatasource ? DATASOURCE_MAP.computeIfAbsent("ha-component-datasource-alone", key -> DbConnectionFactory.initAloneDatasource()) : DATASOURCE_MAP.computeIfAbsent("ha-component-datasource-monitor", key -> DbConnectionFactory.initMonitorDatasource());
        return dataSource.getConnection();
    }

    private static class Hold {
        private static final DbConnectionFactory dbConnectionFactory = new DbConnectionFactory();

        private Hold() {
        }
    }
}

