/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.database;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.cache.DistributeSessionableCache;
import kd.bos.cache.SessionableCacheExt;
import kd.bos.cache.database.Executor;
import kd.bos.cache.redis.ConsistentHashingBucket;
import kd.bos.instance.Instance;
import kd.bos.util.StringUtils;

public class DbSessionableCache
implements DistributeSessionableCache,
SessionableCacheExt {
    private static final ConsistentHashingBucket hashBucket;
    private static final String SESSION_MANAGER_MAP_KEY;
    private static final DbSessionableCache dbSessionableCache;

    static DbSessionableCache getInstance() {
        return dbSessionableCache;
    }

    public void put(String sessionId, String key, String value) {
        Executor.getExecutor().put(sessionId, key, value);
    }

    public void put(String sessionId, Map<String, String> map) {
        Executor.getExecutor().putAll(sessionId, map);
    }

    public String get(String sessionId, String s) {
        return Executor.getExecutor().query(sessionId, s);
    }

    public List<String> get(String sessionId, String[] strings) {
        return Executor.getExecutor().query(sessionId, strings);
    }

    public Map<String, String> getAll(String sessionId) {
        return Executor.getExecutor().queryAll(sessionId);
    }

    public void remove(String sessionId, String s) {
        Executor.getExecutor().remove(sessionId, s);
    }

    public void remove(String sessionId, String[] strings) {
        Executor.getExecutor().remove(sessionId, strings);
    }

    public void remove(String sessionId) {
        Executor.getExecutor().remove(sessionId, new String[0]);
    }

    public boolean contains(String sessionId, String s) {
        String result = Executor.getExecutor().query(sessionId, s);
        return StringUtils.isNotEmpty((String)result);
    }

    public List<String> getKeys(String sessionId) {
        return Executor.getExecutor().getKeysWithPrefix(sessionId, null);
    }

    public List<String> getKeysWithPrefix(String sessionId, String prefix) {
        return Executor.getExecutor().getKeysWithPrefix(sessionId, prefix);
    }

    public void expireAfter(String sessionId, int second) {
        Executor.getExecutor().expireAfter(sessionId, second);
    }

    public int getSessionCount() {
        return 0;
    }

    public void addSessionId(String sessionId, String accountid) {
        String key = hashBucket.getBucket(sessionId);
        Executor.getExecutor().insert(key, sessionId, accountid);
    }

    public void removeSessionId(String ... sessionIds) {
        String[] params = new String[sessionIds.length];
        for (int i = 0; i < sessionIds.length; ++i) {
            params[i] = hashBucket.getBucket(sessionIds[i]);
        }
        Executor.getExecutor().delete(params);
    }

    public boolean existsSession(String sessionId) {
        return Executor.getExecutor().exists(sessionId);
    }

    public static String getRuntimeKey(String sessionId) {
        return "distributeSessionlableCache";
    }

    static {
        SESSION_MANAGER_MAP_KEY = "allsessionidswithtenant" + Instance.getClusterName();
        dbSessionableCache = new DbSessionableCache();
        int sessionSplits = Integer.parseInt(System.getProperty("db.sessionable.sessionids.split", "16"));
        ArrayList<String> ls = new ArrayList<String>(sessionSplits);
        for (int i = 0; i < sessionSplits; ++i) {
            ls.add(SESSION_MANAGER_MAP_KEY + i);
        }
        hashBucket = new ConsistentHashingBucket(ls);
    }
}

