/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.database;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.database.CacheWrapper;
import kd.bos.cache.database.SessionLessExecutor;

public class DistributeSessionlessCacheWrapper
extends CacheWrapper
implements DistributeSessionlessCache {
    private final DistributeSessionlessCache defaultCache;
    private static final SessionLessExecutor backupCache = SessionLessExecutor.instance;

    public DistributeSessionlessCacheWrapper() {
        this.defaultCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("redis_db");
    }

    public DistributeSessionlessCacheWrapper(String region) {
        this.defaultCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(region);
    }

    public int addList(String s, String[] strings) {
        return this.callBackWrite(() -> this.defaultCache.addList(s, strings), () -> backupCache.addList(s, strings));
    }

    public int addList(String s, String[] strings, int i, TimeUnit timeUnit) {
        return this.callBackWrite(() -> this.defaultCache.addList(s, strings, i, timeUnit), () -> backupCache.addList(s, strings, i, timeUnit));
    }

    public int resetList(String key, String[] values, int timeout, TimeUnit timeUnit) {
        this.remove(key);
        return this.addList(key, values, timeout, timeUnit);
    }

    public int insertList(String s, int i, String[] strings) {
        return this.callBackWrite(() -> this.defaultCache.insertList(s, i, strings), () -> backupCache.insertList(s, i, strings));
    }

    public void setListObject(String s, int i, String s1) {
        this.doInvoker(() -> this.defaultCache.setListObject(s, i, s1), () -> backupCache.setListObject(s, i, s1));
    }

    public String[] getList(String s) {
        return this.callBack(() -> this.defaultCache.getList(s), () -> backupCache.getList(s));
    }

    public String[] getList(String s, int i, int i1) {
        return this.callBack(() -> this.defaultCache.getList(s, i, i1), () -> backupCache.getList(s, i, i1));
    }

    public String getListObject(String s, int i) {
        return this.callBack(() -> this.defaultCache.getListObject(s, i), () -> backupCache.getListObject(s, i));
    }

    public void removeListObject(String s, int i) {
        this.doInvoker(() -> this.defaultCache.removeListObject(s, i), () -> backupCache.removeListObject(s, i));
    }

    public void removeListObjects(String s, int i, int i1) {
        this.doInvoker(() -> this.defaultCache.removeListObjects(s, i, i1), () -> backupCache.removeListObjects(s, i, i1));
    }

    public int getListLength(String s) {
        return this.callBack(() -> this.defaultCache.getListLength(s), () -> backupCache.getListLength(s));
    }

    public int addToSet(String s, String[] strings) {
        return this.callBackWrite(() -> this.defaultCache.addToSet(s, strings), () -> backupCache.addToSet(s, strings));
    }

    public int addToSet(String s, String[] strings, int i, TimeUnit timeUnit) {
        return this.callBackWrite(() -> this.defaultCache.addToSet(s, strings, i, timeUnit), () -> backupCache.addToSet(s, strings, i, timeUnit));
    }

    public void removeSetValues(String s, String[] strings) {
        this.doInvoker(() -> this.defaultCache.removeSetValues(s, strings), () -> backupCache.removeSetValues(s, strings));
    }

    public String[] getSetValues(String s) {
        return this.callBack(() -> this.defaultCache.getSetValues(s), () -> backupCache.getSetValues(s));
    }

    public int getSetLength(String s) {
        return this.callBack(() -> this.defaultCache.getSetLength(s), () -> backupCache.getSetLength(s));
    }

    public void put(String s, byte[] bytes) {
        this.doInvoker(() -> this.defaultCache.put(s, bytes), () -> backupCache.put(s, bytes));
    }

    public void put(String s, byte[] bytes, int i) {
        this.doInvoker(() -> this.defaultCache.put(s, bytes, i), () -> backupCache.put(s, bytes, i));
    }

    public byte[] getByteValue(String s) {
        return this.callBack(() -> this.defaultCache.getByteValue(s), () -> backupCache.getByteValue(s));
    }

    public void hset(String s, byte[] bytes, byte[] bytes1) {
        this.doInvoker(() -> this.defaultCache.hset(s, bytes, bytes1), () -> backupCache.hset(s, bytes, bytes1));
    }

    public void hset(String s, byte[] bytes, byte[] bytes1, int i) {
        this.doInvoker(() -> this.defaultCache.hset(s, bytes, bytes1, i), () -> backupCache.hset(s, bytes, bytes1, i));
    }

    public void hmset(String s, Map<byte[], byte[]> map) {
        this.doInvoker(() -> this.defaultCache.hmset(s, map), () -> backupCache.hmset(s, map));
    }

    public void hmset(String s, Map<byte[], byte[]> map, int i) {
        this.doInvoker(() -> this.defaultCache.hmset(s, map, i), () -> backupCache.hmset(s, map, i));
    }

    public byte[] hget(String s, byte[] bytes) {
        return this.callBack(() -> this.defaultCache.hget(s, bytes), () -> backupCache.hget(s, bytes));
    }

    public Map<byte[], byte[]> hgetAll(String s) {
        return this.callBack(() -> this.defaultCache.hgetAll(s), () -> backupCache.hgetAll(s));
    }

    public List<byte[]> hmget(String s, byte[] ... bytes) {
        return this.callBack(() -> this.defaultCache.hmget(s, bytes), () -> backupCache.hmget(s, bytes));
    }

    public Object eval(String s, String s1, List<String> list) {
        return this.callBack(() -> this.defaultCache.eval(s, s1, list), () -> backupCache.eval(s, s1, list));
    }

    public void put(String s, String s2) {
        this.doInvoker(() -> this.defaultCache.put(s, (Object)s2), () -> backupCache.put(s, s2));
    }

    public void put(String s, String s2, int i, TimeUnit timeUnit) {
        this.doInvoker(() -> this.defaultCache.put(s, (Object)s2, i, timeUnit), () -> backupCache.put(s, s2, i, timeUnit));
    }

    public long decr(String s, int i, TimeUnit timeUnit) {
        return this.callBackWrite(() -> this.defaultCache.decr(s, i, timeUnit), () -> backupCache.decr(s, i, timeUnit));
    }

    public long inc(String s, int i, TimeUnit timeUnit) {
        return this.callBackWrite(() -> this.defaultCache.inc(s, i, timeUnit), () -> backupCache.inc(s, i, timeUnit));
    }

    public long inc(String s) {
        return this.callBackWrite(() -> this.defaultCache.inc(s), () -> backupCache.inc(s));
    }

    public long incrBy(String s, int i) {
        return this.callBackWrite(() -> this.defaultCache.incrBy(s, i), () -> backupCache.incrBy(s, i));
    }

    public long decr(String s) {
        return this.callBackWrite(() -> this.defaultCache.decr(s), () -> backupCache.decr(s));
    }

    public void put(String s, Map<String, String> map) {
        this.doInvoker(() -> this.defaultCache.put(s, map), () -> backupCache.put(s, map));
    }

    public void put(String s, Map<String, String> map, int i, TimeUnit timeUnit) {
        this.doInvoker(() -> this.defaultCache.put(s, map, i, timeUnit), () -> backupCache.put(s, map, i, timeUnit));
    }

    public void put(String s, String s1, String s2) {
        this.doInvoker(() -> this.defaultCache.put(s, s1, (Object)s2), () -> backupCache.put(s, s1, s2));
    }

    public void put(String s, String s1, String s2, int i, TimeUnit timeUnit) {
        this.doInvoker(() -> this.defaultCache.put(s, s1, s2, i, timeUnit), () -> backupCache.put(s, s1, s2, i, timeUnit));
    }

    public String get(String s) {
        return this.callBack(() -> (String)this.defaultCache.get(s), () -> backupCache.get(s));
    }

    public String get(String s, String s1) {
        return this.callBack(() -> (String)this.defaultCache.get(s, s1), () -> backupCache.get(s, s1));
    }

    public List<String> get(String s, String[] strings) {
        return this.callBack(() -> this.defaultCache.get(s, strings), () -> backupCache.get(s, strings));
    }

    public Map<String, String> getAll(String s) {
        return this.callBack(() -> this.defaultCache.getAll(s), () -> backupCache.getAll(s));
    }

    public void remove(String s) {
        this.doInvoker(() -> this.defaultCache.remove(s), () -> backupCache.remove(s));
    }

    public void remove(String[] strings) {
        this.doInvoker(() -> this.defaultCache.remove(strings), () -> backupCache.remove(strings));
    }

    public void remove(String s, String s1) {
        this.doInvoker(() -> this.defaultCache.remove(s, s1), () -> backupCache.remove(s, s1));
    }

    public void remove(String s, String[] strings) {
        this.doInvoker(() -> this.defaultCache.remove(s, strings), () -> backupCache.remove(s, strings));
    }

    public void removeType(String s) {
        this.doInvoker(() -> this.defaultCache.removeType(s), () -> backupCache.removeType(s));
    }

    public boolean contains(String s) {
        return this.callBack(() -> this.defaultCache.contains(s), () -> backupCache.contains(s));
    }

    public boolean contains(String s, String s1) {
        return this.callBack(() -> this.defaultCache.contains(s, s1), () -> backupCache.contains(s, s1));
    }

    public List<String> getKeys(String key) {
        return this.callBack(() -> this.defaultCache.getKeys(key), () -> backupCache.getKeys(key));
    }

    public List<String> getKeysWithPrefix(String s, String s1) {
        return this.callBack(() -> this.defaultCache.getKeysWithPrefix(s, s1), () -> backupCache.getKeysWithPrefix(s, s1));
    }

    public List<String> getKeysWithPrefix(String s) {
        return this.callBack(() -> this.defaultCache.getKeysWithPrefix(s), () -> backupCache.getKeysWithPrefix(s));
    }

    public void expireAfter(String s, int i, TimeUnit timeUnit) {
        this.doInvoker(() -> this.defaultCache.expireAfter(s, i, timeUnit), () -> backupCache.expireAfter(s, i, timeUnit));
    }

    public void expireAfterImmediateEffect(String s, int i, TimeUnit timeUnit) {
        this.doInvoker(() -> this.defaultCache.expireAfterImmediateEffect(s, i, timeUnit), () -> backupCache.expireAfterImmediateEffect(s, i, timeUnit));
    }

    public void pipelinedMode() {
        this.defaultCache.pipelinedMode();
        this.doInvoker(() -> this.defaultCache.pipelinedMode(), () -> backupCache.pipelinedMode());
    }

    public void singleMode() {
        this.doInvoker(() -> this.defaultCache.singleMode(), () -> backupCache.singleMode());
    }

    public List<Object> syncAndReturn() {
        return this.callBack(() -> this.defaultCache.syncAndReturn(), () -> backupCache.syncAndReturn());
    }

    @Override
    public boolean isAvailable() {
        return this.defaultCache.isAvailable();
    }
}

