/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.database.DbConnectionFactory;
import kd.bos.cache.database.DbSessionableCacheException;
import kd.bos.cache.database.TableName;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HexUtils;
import kd.bos.util.StringUtils;

public class SessionLessExecutor
implements DistributeSessionlessCache {
    private static final Log log = LogFactory.getLog(SessionLessExecutor.class);
    private static final DbConnectionFactory connPool = DbConnectionFactory.getInstance();
    public static final SessionLessExecutor instance = new SessionLessExecutor();
    private static final String DEFAULT_TIMEOUT_KEY = "redis.defaulttimeout";
    private final int DEFAULT_TIMEOUT = 3600;

    private int getDefaultTimeout() {
        String s = System.getProperty(DEFAULT_TIMEOUT_KEY);
        if (s != null) {
            try {
                return Integer.parseInt(s.trim());
            }
            catch (Exception t) {
                log.error("redis.defaulttimeout is not legal integer: " + s);
            }
        }
        return 3600;
    }

    private int toExpireTime(int timeout, TimeUnit timeUnit) {
        int expire = (int)timeUnit.toSeconds(timeout);
        if (expire < 0) {
            expire = this.getDefaultTimeout();
        }
        return expire;
    }

    public int addList(String key, String[] values) {
        return this.addList(key, values, this.getDefaultTimeout());
    }

    /*
     * Exception decompiling
     */
    public int addList(String key, String[] values, int timeout, TimeUnit timeUnit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int resetList(String key, String[] values, int timeout, TimeUnit timeUnit) {
        this.remove(key);
        return this.addList(key, values, timeout, timeUnit);
    }

    public int insertList(String key, int index, String[] values) {
        String name = TableName.getName("list");
        String select = "select fvalue index findex from " + name + " where fkey = ? and findex = ?";
        String insert = "insert into " + name + "(fkey,findex,fvalue,ftime,fexpire) values(?,?,?,now(),?)";
        String update = "update " + name + " set findex = (findex + ?) where fkey = ? and findex >=  ?";
        int defaultTimeout = this.getDefaultTimeout();
        try (Connection connection = connPool.getConnection();
             PreparedStatement query = connection.prepareStatement(select);
             PreparedStatement save = connection.prepareStatement(insert);
             PreparedStatement motify = connection.prepareStatement(update);){
            DbConnectionFactory.parameter.set(query, (Object)key, 1, 12);
            DbConnectionFactory.parameter.set(query, (Object)index, 2, 4);
            String tempValue = null;
            try (ResultSet resultSet = query.executeQuery();){
                while (resultSet.next()) {
                    tempValue = resultSet.getString("fvalue");
                }
            }
            if (tempValue == null) {
                throw new IndexOutOfBoundsException("index:" + index);
            }
            var19_28 = null;
            try (DbLock lock = DbLock.create(key);){
                if (lock.lock()) {
                    DbConnectionFactory.parameter.set(motify, (Object)index, 1, 4);
                    DbConnectionFactory.parameter.set(motify, (Object)key, 2, 12);
                    DbConnectionFactory.parameter.set(motify, (Object)index, 3, 4);
                    motify.execute();
                    for (String value : values) {
                        DbConnectionFactory.parameter.set(save, (Object)key, 1, 12);
                        DbConnectionFactory.parameter.set(save, (Object)index, 2, 4);
                        DbConnectionFactory.parameter.set(save, (Object)value, 3, 12);
                        DbConnectionFactory.parameter.set(save, (Object)defaultTimeout, 4, 4);
                        save.addBatch();
                        --index;
                    }
                    save.executeBatch();
                    connection.commit();
                }
            }
            catch (Throwable throwable) {
                var19_28 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new DbSessionableCacheException(e, "addList error", new Object[0]);
        }
        return values.length;
    }

    public void setListObject(String key, int index, String value) {
        String name = TableName.getName("list");
        String update = "update " + name + " set fvalue = ? where fkey = ? and findex = ? and ftime = now()";
        String select = "select fvalue index findex from " + name + " where fkey = ? and findex = ?";
        try (Connection connection = connPool.getConnection();
             PreparedStatement query = connection.prepareStatement(select);
             PreparedStatement motify = connection.prepareStatement(update);){
            DbConnectionFactory.parameter.set(query, (Object)key, 1, 12);
            DbConnectionFactory.parameter.set(query, (Object)index, 2, 4);
            String tempValue = null;
            try (ResultSet resultSet = query.executeQuery();){
                while (resultSet.next()) {
                    tempValue = resultSet.getString("fvalue");
                }
            }
            if (tempValue == null) {
                throw new IndexOutOfBoundsException("index:" + index);
            }
            var15_22 = null;
            try (DbLock lock = DbLock.create(key);){
                if (lock.lock()) {
                    DbConnectionFactory.parameter.set(motify, (Object)value, 1, 12);
                    DbConnectionFactory.parameter.set(motify, (Object)key, 2, 12);
                    DbConnectionFactory.parameter.set(motify, (Object)index, 3, 4);
                    motify.execute();
                }
            }
            catch (Throwable throwable) {
                var15_22 = throwable;
                throw throwable;
            }
            connection.commit();
        }
        catch (Exception e) {
            throw new DbSessionableCacheException(e, "addList error", new Object[0]);
        }
    }

    public String[] getList(String key) {
        return this.getList(key, 0, Integer.MAX_VALUE);
    }

    public String[] getList(String key, int index, int length) {
        ArrayList<String> result = new ArrayList<String>(32);
        String name = TableName.getName("list");
        String sql = "select fvalue from " + name + " where fkey = ? and findex between ? and ?";
        try (Connection conn = connPool.getConnection();
             PreparedStatement statement = conn.prepareStatement(sql);){
            DbConnectionFactory.parameter.set(statement, (Object)key, 1, 12);
            DbConnectionFactory.parameter.set(statement, (Object)index, 2, 4);
            DbConnectionFactory.parameter.set(statement, (Object)length, 3, 4);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    result.add(resultSet.getString("fvalue"));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result.toArray(new String[0]);
    }

    public String getListObject(String key, int index) {
        String result = null;
        String name = TableName.getName("list");
        String sql = "select fvalue from " + name + " where fkey = ? and findex = ?";
        try (Connection conn = connPool.getConnection();
             PreparedStatement statement = conn.prepareStatement(sql);){
            DbConnectionFactory.parameter.set(statement, (Object)key, 1, 12);
            DbConnectionFactory.parameter.set(statement, (Object)index, 2, 4);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    result = resultSet.getString("fvalue");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void removeListObject(String key, int index) {
        this.removeListObjects(key, index, 1);
    }

    public void removeListObjects(String key, int index, int length) {
        block50: {
            String name = TableName.getName("list");
            String delete = "delete from " + name + " where fkey = ? and  findex between ? and ?";
            String update = "update " + name + " set findex = (findex - ?) where fkey = ? and findex >=  ?";
            int endIndex = index + length;
            try (DbLock lock = DbLock.create(key);){
                if (!lock.lock()) break block50;
                try (Connection connection = connPool.getConnection();
                     PreparedStatement del = connection.prepareStatement(delete);
                     PreparedStatement motify = connection.prepareStatement(update);){
                    DbConnectionFactory.parameter.set(del, (Object)key, 1, 12);
                    DbConnectionFactory.parameter.set(del, (Object)index, 2, 4);
                    DbConnectionFactory.parameter.set(del, (Object)endIndex, 3, 4);
                    del.execute();
                    DbConnectionFactory.parameter.set(motify, (Object)index, 1, 4);
                    DbConnectionFactory.parameter.set(motify, (Object)key, 2, 12);
                    DbConnectionFactory.parameter.set(motify, (Object)index, 3, 4);
                    motify.execute();
                    connection.commit();
                }
            }
            catch (Exception e) {
                throw new DbSessionableCacheException(e, "removeListObjects error", new Object[0]);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public int getListLength(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int addToSet(String key, String[] values) {
        return this.set(key, values, 3600, TimeUnit.SECONDS);
    }

    public int addToSet(String key, String[] values, int timeout, TimeUnit timeUnit) {
        return this.set(key, values, timeout, timeUnit);
    }

    public void removeSetValues(String key, String[] values) {
        if (values != null && values.length > 0) {
            String tableName = TableName.getName("set");
            StringBuilder sql = new StringBuilder("delete from ").append(tableName).append(" where fkey = ? and fvalue in (");
            ArrayList<String> mark = new ArrayList<String>(32);
            for (String ignored : values) {
                mark.add("?");
            }
            sql.append(String.join((CharSequence)",", mark)).append(")");
            try (Connection connection = connPool.getConnection();
                 PreparedStatement delStatement = connection.prepareStatement(sql.toString());){
                DbConnectionFactory.parameter.set(delStatement, (Object)key, 1, 12);
                int size = mark.size();
                for (int i = 0; i < size; ++i) {
                    String value = values[i];
                    DbConnectionFactory.parameter.set(delStatement, (Object)value, i + 2, 12);
                }
                delStatement.execute();
                connection.commit();
            }
            catch (Exception e) {
                throw new DbSessionableCacheException(e, "addList error", new Object[0]);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public String[] getSetValues(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public int getSetLength(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void put(String key, byte[] value) {
        this.put(key, value, this.getDefaultTimeout());
    }

    public void put(String key, byte[] value, int timeout) {
        int timeoutSeconds = this.toExpireTime(timeout, TimeUnit.SECONDS);
        try {
            String tableName = TableName.getName("string");
            String fvalue = HexUtils.toHex((byte[])value);
            String delSql = "delete from " + tableName + " where fkey = ?";
            String insert = "insert into " + tableName + "(fkey,fvalue,ftime,fexpire) values(?,?,now(),?)";
            try (Connection connection = connPool.getConnection();
                 PreparedStatement del = connection.prepareStatement(delSql);
                 PreparedStatement ins = connection.prepareStatement(insert);){
                DbConnectionFactory.parameter.set(del, (Object)key, 1, 12);
                DbConnectionFactory.parameter.set(ins, (Object)key, 1, 12);
                DbConnectionFactory.parameter.set(ins, (Object)fvalue, 2, 12);
                DbConnectionFactory.parameter.set(ins, (Object)timeoutSeconds, 3, 4);
                del.execute();
                ins.execute();
                connection.commit();
            }
        }
        catch (Exception e) {
            throw new DbSessionableCacheException(e, "addList error", new Object[0]);
        }
    }

    /*
     * Exception decompiling
     */
    public byte[] getByteValue(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void hset(String key, byte[] field, byte[] value) {
        this.hset(key, field, value, this.getDefaultTimeout());
    }

    public void hset(String key, byte[] field, byte[] value, int timeout) {
        String ffield = HexUtils.toHex((byte[])field);
        String fvalue = HexUtils.toHex((byte[])value);
        Connection connection = null;
        PreparedStatement delete = null;
        PreparedStatement insert = null;
        String tableName = TableName.getName("hash");
        try {
            connection = connPool.getConnection();
            delete = connection.prepareStatement("delete from  " + tableName + " where fkey = ? and ffield = ?");
            DbConnectionFactory.parameter.set(delete, (Object)key, 1, 12);
            DbConnectionFactory.parameter.set(delete, (Object)ffield, 2, 12);
            delete.execute();
            insert = connection.prepareStatement("insert into " + tableName + "(fkey,ffield,fvalue,ftime,fexpire) values(?,?,?,now(),?)");
            DbConnectionFactory.parameter.set(insert, (Object)key, 1, 12);
            DbConnectionFactory.parameter.set(insert, (Object)ffield, 2, 12);
            DbConnectionFactory.parameter.set(insert, (Object)fvalue, 3, 12);
            DbConnectionFactory.parameter.set(insert, (Object)timeout, 4, 4);
            insert.execute();
            connection.commit();
        }
        catch (Exception e) {
            try {
                throw new DbSessionableCacheException(e, "hset error, tableName: %s,sessionId: %s", tableName);
            }
            catch (Throwable throwable) {
                SessionLessExecutor.release(delete, insert, connection);
                throw throwable;
            }
        }
        SessionLessExecutor.release(delete, insert, connection);
    }

    public void hmset(String key, Map<byte[], byte[]> map) {
        this.hmset(key, map, this.getDefaultTimeout());
    }

    public void hmset(String key, Map<byte[], byte[]> map, int timeout) {
        String tableName = TableName.getName("hash");
        Set<Map.Entry<byte[], byte[]>> entrySet = map.entrySet();
        Iterator<Map.Entry<byte[], byte[]>> iterator = entrySet.iterator();
        ArrayList<String> values = new ArrayList<String>(16);
        ArrayList<String> questionMark = new ArrayList<String>(16);
        Connection connection = null;
        PreparedStatement insertStatement = null;
        PreparedStatement deleteStatement = null;
        try {
            connection = connPool.getConnection();
            String insert = "insert into " + tableName + "(fkey,ffield,fvalue,ftime,fexpire) values(?,?,?,now(),?)";
            insertStatement = connection.prepareStatement(insert);
            while (iterator.hasNext()) {
                Map.Entry<byte[], byte[]> entry = iterator.next();
                byte[] entryKey = entry.getKey();
                byte[] entryValue = entry.getValue();
                String ffield = HexUtils.toHex((byte[])entryKey);
                String fvalue = HexUtils.toHex((byte[])entryValue);
                values.add(ffield);
                questionMark.add("?");
                DbConnectionFactory.parameter.set(insertStatement, (Object)key, 1, 12);
                DbConnectionFactory.parameter.set(insertStatement, (Object)ffield, 2, 12);
                DbConnectionFactory.parameter.set(insertStatement, (Object)fvalue, 3, 12);
                DbConnectionFactory.parameter.set(insertStatement, (Object)timeout, 4, 4);
                insertStatement.addBatch();
            }
            int size = values.size();
            if (size > 0) {
                StringBuilder delete = new StringBuilder("delete from " + tableName + " where ffield in (");
                delete.append(String.join((CharSequence)",", questionMark)).append(") and fkey = ?");
                deleteStatement = connection.prepareStatement(delete.toString());
                for (int i = 0; i < size; ++i) {
                    DbConnectionFactory.parameter.set(deleteStatement, values.get(i), i + 1, 12);
                }
                DbConnectionFactory.parameter.set(deleteStatement, (Object)key, size + 1, 12);
                deleteStatement.execute();
            }
            insertStatement.executeBatch();
            connection.commit();
        }
        catch (Exception e) {
            try {
                throw new DbSessionableCacheException(e, "put error, tableName: %s,sessionId: %s", tableName);
            }
            catch (Throwable throwable) {
                SessionLessExecutor.release(deleteStatement, insertStatement, connection);
                throw throwable;
            }
        }
        SessionLessExecutor.release(deleteStatement, insertStatement, connection);
    }

    private static void release(AutoCloseable ... resources) {
        for (AutoCloseable resource : resources) {
            try {
                if (resource == null) continue;
                resource.close();
            }
            catch (Exception e) {
                log.error("close resource error", (Throwable)e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public byte[] hget(String key, byte[] field) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Map<byte[], byte[]> hgetAll(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<byte[]> hmget(String key, byte[] ... fields) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Object eval(String lua, String key, List<String> params) {
        return null;
    }

    public void put(String key, String value) {
        this.put(key, value, this.getDefaultTimeout(), TimeUnit.SECONDS);
    }

    public void put(String key, String value, int timeout, TimeUnit timeUnit) {
        this.put(key, HexUtils.fromHex((String)value), timeout);
    }

    public long decr(String key, int timeout, TimeUnit timeUnit) {
        return this.inc(key, -1, timeout, timeUnit);
    }

    public long inc(String key, int timeout, TimeUnit timeUnit) {
        return this.inc(key, 1, timeout, timeUnit);
    }

    public long inc(String key) {
        return this.inc(key, this.getDefaultTimeout(), TimeUnit.SECONDS);
    }

    public long incrBy(String key, int amount) {
        return this.inc(key, amount, this.getDefaultTimeout(), TimeUnit.SECONDS);
    }

    public long decr(String key) {
        return this.decr(key, this.getDefaultTimeout(), TimeUnit.SECONDS);
    }

    public void put(String key, Map<String, String> map) {
        this.put(key, map, this.getDefaultTimeout(), TimeUnit.SECONDS);
    }

    public void put(String key, Map<String, String> map, int timeout, TimeUnit timeUnit) {
        HashMap<byte[], byte[]> hashMap = new HashMap<byte[], byte[]>(map.size());
        for (Map.Entry<String, String> next : map.entrySet()) {
            String field = next.getKey();
            String value = next.getValue();
            hashMap.put(HexUtils.fromHex((String)field), HexUtils.fromHex((String)value));
        }
        this.hmset(key, hashMap, this.toExpireTime(timeout, timeUnit));
    }

    public void put(String key, String field, String value) {
        this.put(key, field, value, this.getDefaultTimeout(), TimeUnit.SECONDS);
    }

    public void put(String key, String field, String value, int timeout, TimeUnit timeUnit) {
        this.hset(key, HexUtils.fromHex((String)field), HexUtils.fromHex((String)value), this.toExpireTime(timeout, timeUnit));
    }

    public String get(String key) {
        String name = TableName.getName("string");
        String sql = "select fvalue from " + name + " where fkey = ?";
        String result = null;
        try (Connection conn = connPool.getConnection();
             PreparedStatement statement = conn.prepareStatement(sql);){
            DbConnectionFactory.parameter.set(statement, (Object)key, 1, 12);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    result = resultSet.getString("fvalue");
                }
            }
        }
        catch (Exception e) {
            throw new DbSessionableCacheException(e, "remove error", new Object[0]);
        }
        return result;
    }

    public String get(String key, String field) {
        byte[] bytes = this.hget(key, HexUtils.fromHex((String)field));
        return HexUtils.toHex((byte[])bytes);
    }

    public List<String> get(String key, String[] fields) {
        ArrayList<String> result = new ArrayList<String>(16);
        int length = fields.length;
        ArrayList<byte[]> params = new ArrayList<byte[]>(length);
        for (int i = 0; i < length; ++i) {
            params.add(HexUtils.fromHex((String)fields[i]));
        }
        List<byte[]> list = this.hmget(key, (byte[][])params.toArray((T[])new byte[0][]));
        for (byte[] bytes : list) {
            result.add(HexUtils.toHex((byte[])bytes));
        }
        return result;
    }

    public Map<String, String> getAll(String key) {
        Map<byte[], byte[]> map = this.hgetAll(key);
        HashMap<String, String> result = new HashMap<String, String>(16);
        for (Map.Entry<byte[], byte[]> next : map.entrySet()) {
            byte[] field = next.getKey();
            byte[] value = next.getValue();
            result.put(HexUtils.toHex((byte[])field), HexUtils.toHex((byte[])value));
        }
        return result;
    }

    public void remove(String key) {
        Collection<String> tables = TableName.getAllSessionlessTable();
        try (Connection conn = connPool.getConnection();
             Statement statement = conn.createStatement();){
            for (String table : tables) {
                StringBuilder sql = new StringBuilder("delete from ").append(table).append(" where fkey = '").append(key).append("'");
                statement.execute(sql.toString());
            }
            conn.commit();
        }
        catch (Exception e) {
            throw new DbSessionableCacheException(e, "remove error", new Object[0]);
        }
    }

    public void remove(String[] keys) {
        for (String key : keys) {
            this.remove(key);
        }
    }

    public void remove(String key, String field) {
        this.remove(key, new String[]{field});
    }

    public void remove(String key, String[] fields) {
        String tableName = TableName.getName("hash");
        String[] params = new String[fields.length + 1];
        params[0] = key;
        StringBuilder sql = new StringBuilder("delete from ").append(tableName).append(" where fkey = ?");
        if (fields.length > 0) {
            ArrayList<String> questionMark = new ArrayList<String>(16);
            for (int i = 0; i < fields.length; ++i) {
                params[i + 1] = fields[i];
                questionMark.add("?");
            }
            sql.append("and ffield in (").append(String.join((CharSequence)",", questionMark)).append(")");
        }
        try (Connection con = connPool.getConnection();
             PreparedStatement statement = con.prepareStatement(sql.toString());){
            for (int i = 0; i < params.length; ++i) {
                DbConnectionFactory.parameter.set(statement, (Object)params[i], i + 1, 12);
            }
            statement.execute();
            con.commit();
        }
        catch (Exception e) {
            throw new DbSessionableCacheException(e, "remove error, tableName: %s", tableName);
        }
    }

    public void removeType(String key) {
        this.remove(key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(String key) {
        Collection<String> tables = TableName.getAllSessionlessTable();
        Iterator<String> iterator = tables.iterator();
        while (iterator.hasNext()) {
            String table = iterator.next();
            String sql = "select fvalue from " + table + " where fkey = ?";
            try {
                Connection con = connPool.getConnection();
                Throwable throwable = null;
                try {
                    PreparedStatement statement = con.prepareStatement(sql);
                    Throwable throwable2 = null;
                    try {
                        DbConnectionFactory.parameter.set(statement, (Object)key, 1, 12);
                        ResultSet resultSet = statement.executeQuery();
                        Throwable throwable3 = null;
                        try {
                            if (!resultSet.next()) continue;
                            boolean bl = true;
                            return bl;
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (resultSet == null) continue;
                            if (throwable3 != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            resultSet.close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (statement == null) continue;
                        if (throwable2 != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        statement.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (con == null) continue;
                    if (throwable != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    con.close();
                }
            }
            catch (SQLException e) {
                log.error("contains error, key: " + key, (Throwable)e);
            }
        }
        return false;
    }

    public boolean contains(String key, String field) {
        return StringUtils.isNotEmpty((String)this.get(key, field));
    }

    public List<String> getKeys(String key) {
        return this.getKeysWithPrefix(key, null);
    }

    /*
     * Exception decompiling
     */
    public List<String> getKeysWithPrefix(String key, String preFix) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<String> getKeysWithPrefix(String key) {
        return this.getKeysWithPrefix(key, null);
    }

    public void expireAfter(String key, int timeout, TimeUnit timeUnit) {
        this.expireAfterImmediateEffect(key, timeout, timeUnit);
    }

    public void expireAfterImmediateEffect(String key, int timeout, TimeUnit timeUnit) {
        int timeoutSeconds = this.toExpireTime(timeout, timeUnit);
        Collection<String> tables = TableName.getAllSessionlessTable();
        try (Connection conn = connPool.getConnection();
             Statement statement = conn.createStatement();){
            for (String table : tables) {
                StringBuilder sql = new StringBuilder("update ").append(table).append("set fexpire = ").append(timeoutSeconds).append(" where fkey = '").append(key).append("'");
                statement.execute(sql.toString());
            }
            conn.commit();
        }
        catch (Exception e) {
            throw new DbSessionableCacheException(e, "expireAfterImmediateEffect error", new Object[0]);
        }
    }

    public void pipelinedMode() {
    }

    public void singleMode() {
    }

    public List<Object> syncAndReturn() {
        return Collections.EMPTY_LIST;
    }

    private int set(String key, String[] values, int timeout, TimeUnit timeUnit) {
        if (values != null && values.length > 0) {
            String tableName = TableName.getName("set");
            int expireTime = this.toExpireTime(timeout, timeUnit);
            String insert = "insert into " + tableName + "(fkey,fvalue,ftime,fexpire) values(?,?,now(),?)";
            List<String> list = Arrays.asList(values);
            StringBuilder delete = new StringBuilder("delete from ").append(tableName).append(" where fkey = ? and fvalue in (");
            ArrayList<String> mark = new ArrayList<String>(32);
            for (String ignored : list) {
                mark.add("?");
            }
            delete.append(String.join((CharSequence)",", mark)).append(")");
            try (Connection connection = connPool.getConnection();
                 PreparedStatement delStatement = connection.prepareStatement(delete.toString());
                 PreparedStatement statement = connection.prepareStatement(insert);){
                int size = list.size();
                DbConnectionFactory.parameter.set(delStatement, (Object)key, 1, 12);
                for (int i = 0; i < size; ++i) {
                    String value = list.get(i);
                    DbConnectionFactory.parameter.set(delStatement, (Object)value, i + 2, 12);
                    DbConnectionFactory.parameter.set(statement, (Object)key, 1, 12);
                    DbConnectionFactory.parameter.set(statement, (Object)value, 2, 12);
                    DbConnectionFactory.parameter.set(statement, (Object)expireTime, 3, 4);
                    statement.addBatch();
                }
                delStatement.execute();
                statement.executeBatch();
                connection.commit();
            }
            catch (Exception e) {
                throw new DbSessionableCacheException(e, "addToSet error", new Object[0]);
            }
            return values.length;
        }
        return 0;
    }

    /*
     * Exception decompiling
     */
    public long inc(String key, int amount, int timeout, TimeUnit timeUnit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void deleteExpired() {
        Collection<String> tableNames = TableName.getAllSessionlessTable();
        try (Connection con = connPool.getConnection();
             Statement statement = con.createStatement();){
            for (String tableName : tableNames) {
                String sql = "delete from " + tableName + " where DATEDIFF(ftime,now()) > fexpire and fexpire != -1";
                statement.addBatch(sql);
            }
            statement.executeBatch();
            con.commit();
        }
        catch (Exception e) {
            log.error("delete expire key error", (Throwable)e);
        }
    }

    static class DbLock
    implements AutoCloseable {
        private static final String tableName = TableName.getName("string");
        private final String key;

        private DbLock(String key) {
            this.key = "sessionLess_lock_key_" + key;
        }

        static DbLock create(String key) {
            return new DbLock(key);
        }

        /*
         * Loose catch block
         */
        boolean lock() {
            while (true) {
                boolean bl;
                Throwable throwable;
                PreparedStatement statement;
                Throwable throwable2;
                Connection connection;
                block29: {
                    block30: {
                        block27: {
                            block28: {
                                String sql = "insert into " + tableName + "(fkey,fvalue,ftime,fexpire) values(?,?,now(),600)";
                                connection = connPool.getConnection();
                                throwable2 = null;
                                statement = connection.prepareStatement(sql);
                                throwable = null;
                                DbConnectionFactory.parameter.set(statement, (Object)this.key, 1, 12);
                                DbConnectionFactory.parameter.set(statement, (Object)"lock", 2, 12);
                                statement.execute();
                                connection.commit();
                                bl = true;
                                if (statement == null) break block27;
                                if (throwable == null) break block28;
                                try {
                                    statement.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                break block27;
                            }
                            statement.close();
                        }
                        if (connection == null) break block29;
                        if (throwable2 == null) break block30;
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        break block29;
                    }
                    connection.close();
                }
                return bl;
                {
                    catch (Throwable throwable5) {
                        try {
                            try {
                                try {
                                    try {
                                        throwable = throwable5;
                                        throw throwable5;
                                    }
                                    catch (Throwable throwable6) {
                                        if (statement != null) {
                                            if (throwable != null) {
                                                try {
                                                    statement.close();
                                                }
                                                catch (Throwable throwable7) {
                                                    throwable.addSuppressed(throwable7);
                                                }
                                            } else {
                                                statement.close();
                                            }
                                        }
                                        throw throwable6;
                                    }
                                }
                                catch (Throwable throwable8) {
                                    throwable2 = throwable8;
                                    throw throwable8;
                                }
                            }
                            catch (Throwable throwable9) {
                                if (connection != null) {
                                    if (throwable2 != null) {
                                        try {
                                            connection.close();
                                        }
                                        catch (Throwable throwable10) {
                                            throwable2.addSuppressed(throwable10);
                                        }
                                    } else {
                                        connection.close();
                                    }
                                }
                                throw throwable9;
                            }
                        }
                        catch (Exception e) {
                            LockSupport.parkNanos(10000000000L);
                            continue;
                        }
                    }
                }
                break;
            }
        }

        void unlock() {
            String sql = "delete from " + tableName + " where fkey = ?";
            try (Connection connection = connPool.getConnection();
                 PreparedStatement statement = connection.prepareStatement(sql);){
                DbConnectionFactory.parameter.set(statement, (Object)this.key, 1, 12);
                statement.execute();
                connection.commit();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void close() throws Exception {
            this.unlock();
        }
    }
}

