/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.database.DbConnectionFactory;
import kd.bos.cache.database.DbSessionableCacheException;
import kd.bos.cache.database.Executor;
import kd.bos.cache.database.TableName;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class SqlExecutor
implements Executor {
    private static final Log log = LogFactory.getLog(SqlExecutor.class);
    private static final DbConnectionFactory connectionFactory = DbConnectionFactory.getInstance();
    public static final SqlExecutor instance = new SqlExecutor();

    private SqlExecutor() {
    }

    private static void release(AutoCloseable ... resources) {
        for (AutoCloseable resource : resources) {
            try {
                if (resource == null) continue;
                resource.close();
            }
            catch (Exception e) {
                log.error("close resource error", (Throwable)e);
            }
        }
    }

    private static void rollback(Connection con) {
        try {
            if (con != null) {
                con.rollback();
            }
        }
        catch (SQLException e) {
            throw new DbSessionableCacheException(e, "sql rollback error", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeBatch(List<String> ksqls) {
        Connection con = null;
        Statement statement = null;
        try {
            con = connectionFactory.getConnection();
            statement = con.createStatement();
            for (String ksql : ksqls) {
                statement.addBatch(ksql);
            }
            statement.executeBatch();
            this.commit(con);
        }
        catch (Exception e) {
            try {
                SqlExecutor.rollback(con);
                log.error("executeBatch error", (Throwable)e);
            }
            catch (Throwable throwable) {
                SqlExecutor.release(statement, con);
                throw throwable;
            }
            SqlExecutor.release(statement, con);
        }
        SqlExecutor.release(statement, con);
    }

    @Override
    public void createTableOrIndex(String sql) {
        Connection con = null;
        Statement statement = null;
        try {
            con = connectionFactory.getConnection();
            statement = con.createStatement();
            statement.execute(sql);
            this.commit(con);
        }
        catch (Exception e) {
            try {
                throw new DbSessionableCacheException(e, "create table error", new Object[0]);
            }
            catch (Throwable throwable) {
                SqlExecutor.release(statement, con);
                throw throwable;
            }
        }
        SqlExecutor.release(statement, con);
    }

    /*
     * Exception decompiling
     */
    @Override
    public String query(String sessionId, String field) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String> getKeysWithPrefix(String sessionId, String prefix) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String> query(String sessionId, String[] fields) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public Map<String, String> queryAll(String sessionId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void put(String sessionId, String field, String value) {
        Connection connection = null;
        PreparedStatement update = null;
        PreparedStatement insert = null;
        String tableName = TableName.getTableName(sessionId);
        try {
            String key = Executor.getKey(sessionId);
            connection = connectionFactory.getConnection();
            update = connection.prepareStatement("update " + tableName + " set fvalue = ? where fkey = ? and ffield = ?");
            DbConnectionFactory.parameter.set(update, (Object)value, 1, 12);
            DbConnectionFactory.parameter.set(update, (Object)key, 2, 12);
            DbConnectionFactory.parameter.set(update, (Object)field, 3, 12);
            int i = update.executeUpdate();
            if (i == 0) {
                insert = connection.prepareStatement("insert into " + tableName + "(fkey,ffield,fvalue,ftime,fexpire) values(?,?,?,now(),-1)");
                DbConnectionFactory.parameter.set(insert, (Object)key, 1, 12);
                DbConnectionFactory.parameter.set(insert, (Object)field, 2, 12);
                DbConnectionFactory.parameter.set(insert, (Object)value, 3, 12);
                insert.execute();
            }
            this.commit(connection);
        }
        catch (Exception e) {
            try {
                SqlExecutor.rollback(connection);
                throw new DbSessionableCacheException(e, "put error, tableName: %s,sessionId: %s", tableName, sessionId);
            }
            catch (Throwable throwable) {
                SqlExecutor.release(update, insert, connection);
                throw throwable;
            }
        }
        SqlExecutor.release(update, insert, connection);
    }

    @Override
    public void putAll(String sessionId, Map<String, String> keyValues) {
        String tableName = TableName.getTableName(sessionId);
        String key = Executor.getKey(sessionId);
        Set<Map.Entry<String, String>> entrySet = keyValues.entrySet();
        Iterator<Map.Entry<String, String>> iterator = entrySet.iterator();
        ArrayList<String> values = new ArrayList<String>(16);
        ArrayList<String> questionMark = new ArrayList<String>(16);
        Connection connection = null;
        PreparedStatement insertStatement = null;
        PreparedStatement deleteStatement = null;
        try {
            connection = connectionFactory.getConnection();
            String insert = "insert into " + tableName + "(fkey,ffield,fvalue,ftime,fexpire) values(?,?,?,now(),-1)";
            insertStatement = connection.prepareStatement(insert);
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                String entryKey = entry.getKey();
                String entryValue = entry.getValue();
                values.add(entryKey);
                questionMark.add("?");
                DbConnectionFactory.parameter.set(insertStatement, (Object)key, 1, 12);
                DbConnectionFactory.parameter.set(insertStatement, (Object)entryKey, 2, 12);
                DbConnectionFactory.parameter.set(insertStatement, (Object)entryValue, 3, 12);
                insertStatement.addBatch();
            }
            int size = values.size();
            if (size > 0) {
                StringBuilder delete = new StringBuilder("delete from " + tableName + " where ffield in (");
                delete.append(String.join((CharSequence)",", questionMark)).append(") and fkey = ?");
                deleteStatement = connection.prepareStatement(delete.toString());
                for (int i = 0; i < size; ++i) {
                    DbConnectionFactory.parameter.set(deleteStatement, values.get(i), i + 1, 12);
                }
                DbConnectionFactory.parameter.set(deleteStatement, (Object)key, size + 1, 12);
                deleteStatement.execute();
            }
            insertStatement.executeBatch();
            this.commit(connection);
        }
        catch (Exception e) {
            try {
                SqlExecutor.rollback(connection);
                throw new DbSessionableCacheException(e, "put error, tableName: %s,sessionId: %s", tableName, sessionId);
            }
            catch (Throwable throwable) {
                SqlExecutor.release(deleteStatement, insertStatement, connection);
                throw throwable;
            }
        }
        SqlExecutor.release(deleteStatement, insertStatement, connection);
    }

    @Override
    public void remove(String sessionId, String ... keys) {
        String tableName = TableName.getTableName(sessionId);
        String key = Executor.getKey(sessionId);
        String[] params = new String[keys.length + 1];
        params[0] = key;
        StringBuilder sql = new StringBuilder("delete from ").append(tableName).append(" where fkey = ?");
        if (keys.length > 0) {
            ArrayList<String> questionMark = new ArrayList<String>(16);
            for (int i = 0; i < keys.length; ++i) {
                params[i + 1] = keys[i];
                questionMark.add("?");
            }
            sql.append("and ffield in (").append(String.join((CharSequence)",", questionMark)).append(")");
        }
        try (Connection con = connectionFactory.getConnection();
             PreparedStatement statement = con.prepareStatement(sql.toString());){
            for (int i = 0; i < params.length; ++i) {
                DbConnectionFactory.parameter.set(statement, (Object)params[i], i + 1, 12);
            }
            statement.execute();
            this.commit(con);
        }
        catch (Exception e) {
            throw new DbSessionableCacheException(e, "remove error, tableName: %s,sessionId: %s", tableName, sessionId);
        }
    }

    @Override
    public void expireAfter(String sessionId, int second) {
        String tableName = TableName.getTableName(sessionId);
        String key = Executor.getKey(sessionId);
        String sql = "update " + tableName + " set fexpire = ?,ftime = now() where fkey = ?";
        try (Connection con = connectionFactory.getConnection();
             PreparedStatement statement = con.prepareStatement(sql);){
            DbConnectionFactory.parameter.set(statement, (Object)second, 1, 4);
            DbConnectionFactory.parameter.set(statement, (Object)key, 2, 12);
            statement.executeUpdate();
            this.commit(con);
        }
        catch (Exception e) {
            throw new DbSessionableCacheException(e, "expireAfter error, tableName: %s,sessionId: %s", tableName, sessionId);
        }
    }

    @Override
    public void deleteExpired() {
        Collection<String> tableNames = TableName.getAllTableName();
        ArrayList<String> sqls = new ArrayList<String>(tableNames.size());
        for (String tableName : tableNames) {
            String sql = "delete from " + tableName + " where DATEDIFF(ftime,now()) > fexpire and fexpire != -1";
            sqls.add(sql);
        }
        this.executeBatch(sqls);
    }

    @Override
    public void insert(String key, String field, String value) {
        String tableName = TableName.getTableName(key);
        String delete = "delete from " + tableName + " where fkey = ? and ffield = ?";
        String insert = "insert into " + tableName + "(fkey,ffield,fvalue,ftime,fexpire) values(?,?,?,now(),?)";
        Connection con = null;
        PreparedStatement deleteStatement = null;
        PreparedStatement statement = null;
        try {
            con = connectionFactory.getConnection();
            deleteStatement = con.prepareStatement(delete);
            DbConnectionFactory.parameter.set(deleteStatement, (Object)key, 1, 12);
            DbConnectionFactory.parameter.set(deleteStatement, (Object)field, 2, 12);
            deleteStatement.execute();
            statement = con.prepareStatement(insert);
            DbConnectionFactory.parameter.set(statement, (Object)key, 1, 12);
            DbConnectionFactory.parameter.set(statement, (Object)field, 2, 12);
            DbConnectionFactory.parameter.set(statement, (Object)value, 3, 12);
            DbConnectionFactory.parameter.set(statement, (Object)-1, 4, 4);
            statement.execute();
            this.commit(con);
        }
        catch (Exception e) {
            try {
                SqlExecutor.rollback(con);
                throw new DbSessionableCacheException(e, "expireAfter error, tableName: %s,sessionId: %s", tableName, key);
            }
            catch (Throwable throwable) {
                SqlExecutor.release(deleteStatement, statement, con);
                throw throwable;
            }
        }
        SqlExecutor.release(deleteStatement, statement, con);
    }

    private void commit(Connection conn) throws SQLException {
        conn.commit();
    }

    @Override
    public void delete(String ... sessionIds) {
        ArrayList<String> sqls = new ArrayList<String>(sessionIds.length);
        for (String sessionId : sessionIds) {
            StringBuilder sb = new StringBuilder("delete from ").append(TableName.getTableName(sessionId)).append(" where fkey = ").append(sessionId);
            sqls.add(sb.toString());
        }
        this.executeBatch(sqls);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exists(String sessionId) {
        String tableName = TableName.getTableName(sessionId);
        String sql = "select fkey from " + tableName + " where fkey = ?";
        try (Connection con = connectionFactory.getConnection();
             PreparedStatement preparedStatement = con.prepareStatement(sql);){
            DbConnectionFactory.parameter.set(preparedStatement, (Object)Executor.getKey(sessionId), 1, 12);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) return false;
                String fkey = resultSet.getString("fkey");
                boolean bl = fkey != null;
                return bl;
            }
        }
        catch (Exception e) {
            throw new DbSessionableCacheException(e, "exists error, tableName: %s,sessionId: %s", tableName, sessionId);
        }
    }
}

