/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.database;

import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.database.DbConnectionFactory;
import kd.bos.cache.database.DbSessionableCache;
import kd.bos.cache.database.Executor;
import kd.bos.cache.database.ExpireClearService;
import kd.bos.cache.redis.ConsistentHashingBucket;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class TableName {
    private static final Log log = LogFactory.getLog(TableName.class);
    private static final String tableNamePre = "t_sessionablecache_";
    private ConsistentHashingBucket tableNameBucket;
    private static final int initTableNum = Integer.getInteger("db.serversForSession.tableNum", 3);
    private static final Map<String, TableName> tableNameMap = new ConcurrentHashMap<String, TableName>(8);
    private static final String createTableSql = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 'tableVariable') CREATE TABLE tableVariable(FKEY VARCHAR(1000) NOT NULL,FTYPE VARCHAR(10),FFIELD VARCHAR(1000) NOT NULL,FVALUE CLOB NOT NULL,FTIME DATETIME NOT NULL,FEXPIRE INT DEFAULT -1)";
    private static final String createIndexSql = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'HA_SESSIONABLE_indexVariable') CREATE UNIQUE INDEX HA_SESSIONABLE_indexVariable ON tableVariable (FKEY,FFIELD)";
    private static final Map<String, String> tableNameMap_sessionLess;

    private TableName() {
        ArrayList<String> tableNames = new ArrayList<String>(initTableNum);
        for (int i = 1; i <= initTableNum; ++i) {
            String tableName = tableNamePre + i;
            try {
                Executor.getExecutor().createTableOrIndex(TableName.getCreateTableSql(tableName));
                tableNames.add(tableName);
                continue;
            }
            catch (Exception e) {
                log.error("init table error", (Throwable)e);
            }
        }
        this.tableNameBucket = new ConsistentHashingBucket(tableNames);
    }

    public static String getTableName(String sessionId) {
        String runtimeKey = DbSessionableCache.getRuntimeKey(sessionId);
        TableName tableName = tableNameMap.computeIfAbsent(runtimeKey, k -> new TableName());
        return tableName.get().getBucket(sessionId);
    }

    public ConsistentHashingBucket get() {
        return this.tableNameBucket;
    }

    private static String getCreateTableSql(String tableName) {
        return createTableSql.replaceAll("tableVariable", tableName);
    }

    private static String getCreateIndexSql(int index, String tableName) {
        return createIndexSql.replaceAll("indexVariable", index + "").replaceAll("tableVariable", tableName);
    }

    public static Collection<String> getAllTableName() {
        ArrayList allTables = new ArrayList(16);
        for (TableName value : tableNameMap.values()) {
            allTables.addAll(value.get().getBuckets());
        }
        return Collections.unmodifiableCollection(allTables);
    }

    public static String getName(String type) {
        return tableNameMap_sessionLess.computeIfAbsent(type, key -> {
            String tableName;
            String sql = "";
            switch (key) {
                case "string": {
                    tableName = "t_sessionlesscache_string";
                    sql = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 't_sessionlesscache_string') CREATE TABLE t_sessionlesscache_string( FKEY VARCHAR(2000) NOT NULL,FVALUE CLOB NOT NULL,FTIME DATETIME NOT NULL,FEXPIRE INT DEFAULT 3600);";
                    break;
                }
                case "set": {
                    tableName = "t_sessionlesscache_set";
                    sql = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 't_sessionlesscache_set') CREATE TABLE t_sessionlesscache_set( FKEY VARCHAR(2000) NOT NULL,FVALUE CLOB NOT NULL,FTIME DATETIME NOT NULL,FEXPIRE INT DEFAULT 3600);";
                    break;
                }
                case "list": {
                    tableName = "t_sessionlesscache_list";
                    sql = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 't_sessionlesscache_list') CREATE TABLE t_sessionlesscache_list(FKEY VARCHAR(2000) NOT NULL,FINDEX INT NOT NULL,FVALUE CLOB NOT NULL,FTIME DATETIME NOT NULL,FEXPIRE INT DEFAULT 3600);";
                    break;
                }
                case "hash": {
                    tableName = "t_sessionlesscache_hash";
                    sql = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 't_sessionlesscache_hash') CREATE TABLE t_sessionlesscache_hash(FKEY VARCHAR(2000) NOT NULL,FFIELD VARCHAR(2000) NOT NULL,FVALUE CLOB NOT NULL,FTIME DATETIME NOT NULL,FEXPIRE INT DEFAULT 3600);";
                    break;
                }
                default: {
                    throw new IllegalArgumentException((String)key);
                }
            }
            try (Connection connection = DbConnectionFactory.getInstance().getConnection();
                 Statement statement = connection.createStatement();){
                statement.execute(sql);
                connection.commit();
            }
            catch (Exception e) {
                log.error("create table error,tableName: " + tableName);
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
            return tableName;
        });
    }

    public static Collection<String> getAllSessionlessTable() {
        Collection<String> values = tableNameMap_sessionLess.values();
        return Collections.unmodifiableCollection(values);
    }

    static {
        ExpireClearService.start();
        tableNameMap_sessionLess = new ConcurrentHashMap<String, String>(8);
    }
}

