/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.tempfile;

import com.google.common.base.Charsets;
import com.google.common.io.ByteSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.TempFileCacheType;
import kd.bos.cache.TempFileOutput;
import kd.bos.cache.tempfile.BaseTempFileCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.cache.tempfile.TempFileInputStream;
import kd.bos.cache.tempfile.extesion.TempFileCacheExtHandlerFactory;
import kd.bos.context.RequestContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.impl.TempFileService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.FileUtils;
import kd.bos.util.SystemProperties;
import kd.bos.util.resource.Resources;
import org.apache.tools.zip.ZipOutputStream;

public class FileServerTempFileCache
extends BaseTempFileCache
implements TempFileCache,
TempFileCacheDownloadable {
    private static final String CONFIG_KEY = "tempfile.fileserver";
    private static final String TEMPFILE = "tempfile";
    private static final String ZIP_TEMP_DIR = SystemProperties.get((String)"java.io.tmpdir") + "/ierpupload";
    private static final String PREFIX_URL = "url: ";
    private static final String PATH_PATTERN = "/%s/%s/%s/%s/%s";
    private static final String PATH_PATTERN1 = "/%s/%s/%s/%s";
    private static final String DEFAULT_USER_AGENT = "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36";
    private static final Log LOGGER = LogFactory.getLog(FileServerTempFileCache.class);
    private static final String dataFileSuffix = ".tmpdata";
    private static final String metaFileSuffix = ".tmpmeta";
    private final FileService tempfileService = new TempFileService();
    private static boolean isSupportTempTrans = false;
    private static String TEMP_TRANSTO_PERSIST_ENABLE = "fileserver.support.temptrans";

    public FileServerTempFileCache() throws InterruptedException {
        try {
            this.tempfileService.getHttpUrlPrefix();
        }
        catch (Exception e) {
            throw new RuntimeException("Try the test, result:" + e.getMessage(), e);
        }
        if (!this.tempfileService.supportTempfile()) {
            throw new IllegalStateException("Current file server can not support temporary files. Please check the version and running status of the file server. Supported in version V5.0 and above.");
        }
        if (this.tempfileService.supportTempTransToPersist()) {
            LOGGER.info("Current file server  support temporary trans to persist.");
            isSupportTempTrans = true;
        }
    }

    public String saveAsUrl(String filename, InputStream in, int timeout) {
        timeout = this.checkTimeout(timeout);
        in = this.checkFile(in, filename);
        try {
            String dataFilePath = this.saveInFileServer(filename, in, timeout);
            return this.makeUrl(CONFIG_KEY, dataFilePath);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[]{"save tempfile by fileserver upload failed."});
        }
    }

    public String saveAsUrl(String filename, byte[] bytes, int timeout) {
        InputStream in;
        try {
            in = ByteSource.wrap((byte[])bytes).openBufferedStream();
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[]{"tempfile bytes to stream failed."});
        }
        return this.saveAsUrl(filename, in, timeout);
    }

    public String saveAsFullUrl(String filename, InputStream in, int timeout) {
        String url = this.saveAsUrl(filename, in, timeout);
        return this.getUrlPrefix() + url;
    }

    public String saveAsFullUrl(String filename, byte[] bytes, int timeout) {
        String url = this.saveAsUrl(filename, bytes, timeout);
        return this.getUrlPrefix() + url;
    }

    public Map<String, String> save(String filename, InputStream in, int timeout) {
        timeout = this.checkTimeout(timeout);
        in = this.checkFile(in, filename);
        try {
            String dataFilePath = this.saveInFileServer(filename, in, timeout);
            HashMap<String, String> items = new HashMap<String, String>();
            items.put("configKey", CONFIG_KEY);
            items.put("id", dataFilePath);
            return items;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[]{"save tempfile by fileserver upload failed."});
        }
    }

    public Map<String, String> save(String filename, byte[] bytes, int timeout) {
        InputStream in;
        try {
            in = ByteSource.wrap((byte[])bytes).openBufferedStream();
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[]{"tempfile bytes to stream failed."});
        }
        return this.save(filename, in, timeout);
    }

    public InputStream getInputStream(String url) {
        try {
            Map<String, String> m = this.parseUrl(url);
            String id = m.get("id");
            String configKey = m.get("configKey");
            configKey = this.decodeConfigKey(configKey);
            return this.get(configKey, id).getInputStream();
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.downloadFailed, PREFIX_URL + url, (Throwable)e);
        }
    }

    public boolean exists(String url) {
        try {
            Map<String, String> m = this.parseUrl(url);
            String id = m.get("id");
            return this.existInFileServer(id);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.fileIsExistFailed, PREFIX_URL + url, (Throwable)e);
        }
    }

    private boolean existInFileServer(String dataFilePath) {
        return this.tempfileService.exists(dataFilePath);
    }

    private String saveInFileServer(String fileName, InputStream inputStream, int timeout) {
        String id = this.createId();
        String dataFileName = id + dataFileSuffix;
        String customizedPath = this.extractCustomizedFilePath(fileName);
        String dataFilePath = this.createPath(dataFileName, timeout, customizedPath);
        String metaFilePath = this.getMetaFilePath(dataFilePath);
        FileItem dataFileItem = new FileItem(dataFileName, dataFilePath, inputStream);
        FileItem metaFileItem = new FileItem(id + metaFileSuffix, metaFilePath, (InputStream)new ByteArrayInputStream(fileName.getBytes(Charsets.UTF_8)));
        List uploadUrls = this.tempfileService.upload(new FileItem[]{dataFileItem, metaFileItem});
        if (uploadUrls != null && uploadUrls.size() > 1) {
            String fileserverId = (String)uploadUrls.get(0);
            TempFileCacheExtHandlerFactory.createHandler().beforeSave(fileName, fileserverId);
            return fileserverId;
        }
        throw new KDException(BosErrorCode.uploadFailed, new Object[]{"the tempFile save to FileServer error! fileName=" + fileName});
    }

    private void deleteInFileServer(String dataFilePath) {
        String metaFilePath = dataFilePath.substring(0, dataFilePath.lastIndexOf(dataFileSuffix)) + metaFileSuffix;
        this.tempfileService.delete(dataFilePath);
        this.tempfileService.delete(metaFilePath);
    }

    private InputStream getInFromFileServer(String filePath) {
        return this.tempfileService.getInputStream(filePath);
    }

    private Long getFileSizeFromFileServer(String filePath) {
        return this.tempfileService.getFileSize(filePath);
    }

    private String getMetaFilePath(String dataFilePath) {
        return dataFilePath.substring(0, dataFilePath.lastIndexOf(dataFileSuffix)) + metaFileSuffix;
    }

    public void remove(String url) {
        try {
            Map<String, String> m = this.parseUrl(url);
            String id = m.get("id");
            this.deleteByDataFilePath(id);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.deleteFailed, PREFIX_URL + url, (Throwable)e);
        }
    }

    private void deleteByDataFilePath(String dataFilePath) {
        this.deleteInFileServer(dataFilePath);
    }

    public TempFileOutput newOutput(String filename, int timeout) {
        return new FileServerTempFileOutput(filename, timeout);
    }

    public String compress(String zipName, String[] urls, int timeout) {
        String zipFilePath = this.getZipFilePath(null);
        zipFilePath = FileUtils.checkFileUrl((String)zipFilePath);
        this.filesZipToTempdir(urls, zipFilePath);
        return this.saveAndDelZipFile(zipName, timeout, zipFilePath);
    }

    private String getZipFilePath(String fileName) {
        Path tempDir = Paths.get(ZIP_TEMP_DIR, new String[0]);
        if (!tempDir.toFile().exists()) {
            try {
                Files.createDirectories(tempDir, new FileAttribute[0]);
            }
            catch (Exception ex) {
                throw new KDException((Throwable)ex, BosErrorCode.createDirectoryFailed, new Object[]{"can't create directory, path:'" + ZIP_TEMP_DIR + "'"});
            }
        }
        if (fileName != null) {
            return ZIP_TEMP_DIR + "/" + fileName;
        }
        String id = this.createId();
        return ZIP_TEMP_DIR + "/" + id + ".zip";
    }

    private void filesZipToTempdir(String[] urls, String zipFilePath) {
        File zipFile = new File(FileUtils.checkFileUrl((String)zipFilePath));
        try (OutputStream out = Files.newOutputStream(zipFile.toPath(), new OpenOption[0]);
             ZipOutputStream zos = new ZipOutputStream(out);){
            for (String url : urls) {
                Map<String, String> m = this.parseUrl(url);
                String urlId = m.get("id");
                String urlConfigKey = m.get("configKey");
                TempFileCacheDownloadable.Content content = this.get(urlConfigKey, urlId);
                try (InputStream in = content.getInputStream();){
                    this.doZip(in, zos, content.getFilename());
                }
            }
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[]{"filesZipToTempdir failed."});
        }
    }

    /*
     * Exception decompiling
     */
    private String saveAndDelZipFile(String zipName, int timeout, String zipFileUrl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    public String filesZip(String zipName, String[] urls, int timeout) {
        return this.compress(zipName, urls, timeout);
    }

    public TempFileCacheDownloadable.Content download(HttpServletRequest request) {
        String id = request.getParameter("id");
        String configKey = request.getParameter("configKey");
        configKey = this.decodeConfigKey(configKey);
        return this.get(configKey, id);
    }

    public TempFileCacheDownloadable.Content download(Map<String, String> params) {
        String id = params.get("id");
        String configKey = params.get("configKey");
        configKey = this.decodeConfigKey(configKey);
        return this.get(configKey, id);
    }

    public TempFileCacheDownloadable.Content get(String configKey, String id) {
        try {
            int fileSize;
            if (!this.existInFileServer(id)) {
                return null;
            }
            String metaFilePath = this.getMetaFilePath(id);
            String fileName = this.inputStreamToString(this.getInFromFileServer(metaFilePath));
            InputStream inputStream = this.getInFromFileServer(id);
            try {
                Long sizeFromFileServer = this.getFileSizeFromFileServer(id);
                fileSize = sizeFromFileServer > Integer.MAX_VALUE ? Integer.MAX_VALUE : sizeFromFileServer.intValue();
            }
            catch (Exception e) {
                LOGGER.error("get FileSize from fileServer failed", (Throwable)e);
                fileSize = inputStream.available();
            }
            return new TempFileCacheDownloadable.Content(fileSize, (InputStream)new TempFileInputStream(inputStream, fileSize), fileName);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.downloadFailed, PREFIX_URL + id, (Throwable)e);
        }
    }

    private String createPath(String filename, int timeout, String customizedPath) {
        RequestContext requestContext = RequestContext.get();
        String tenantId = requestContext == null ? "monitor" : requestContext.getTenantId();
        String accountId = requestContext == null ? "monitor" : requestContext.getAccountId();
        LocalDateTime now = LocalDateTime.now();
        int hour = timeout / 3600 + (timeout % 3600 == 0 ? 0 : 1);
        LocalDateTime expireDate = now.plusHours(hour);
        String date = DateTimeFormatter.ofPattern("yyyyMMddHH").format(expireDate);
        if (customizedPath == null || customizedPath.length() == 0) {
            return String.format(PATH_PATTERN, TEMPFILE, date, tenantId, accountId, filename);
        }
        String pathPrefix = String.format(PATH_PATTERN1, TEMPFILE, date, tenantId, accountId);
        return pathPrefix + customizedPath + filename;
    }

    private String inputStreamToString(InputStream in) {
        if (in == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byt = new byte[4096];
        try {
            int i;
            while ((i = in.read(byt)) != -1) {
                stringBuilder.append(new String(byt, 0, i));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(Resources.getString((String)"InputStream\u8f6c\u6362\u4e3aString\u9519\u8bef", (String)"DiskTempFileCache_0", (String)"bos-framework", (Object[])new Object[0]), e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
            }
        }
        return stringBuilder.toString();
    }

    private String getUrlPrefix() {
        RequestContext rc = RequestContext.get();
        if (rc == null || rc.getClientFullContextPath() == null) {
            throw new KDException(BosErrorCode.storageFileSaveFailed, new Object[]{"Can't saveAsFullUrl() in not web request, use saveAsUrl() instead."});
        }
        return rc.getClientFullContextPath();
    }

    private String extractCustomizedFilePath(String customizedFileName) {
        try {
            String[] paths;
            int index = customizedFileName.lastIndexOf("/");
            String path = "";
            if (index > 0) {
                path = customizedFileName.substring(0, index);
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                path = path + "/";
            }
            if ((paths = path.split("/")).length > 3) {
                LOGGER.info("Only three levels of directory customization will be allowed at most.");
                path = "";
            }
            return path;
        }
        catch (Throwable e) {
            LOGGER.error("get customized path error", e);
            return "";
        }
    }

    public String type() {
        return TempFileCacheType.FILE_SERVER.getName();
    }

    public boolean supportTempToData(String tempFileUrl) {
        boolean tempTransEnable = Boolean.parseBoolean(System.getProperty(TEMP_TRANSTO_PERSIST_ENABLE, "true"));
        if (!tempTransEnable) {
            LOGGER.info("supportTempToData, fileserver.support.temptrans is false");
            return false;
        }
        if (!isSupportTempTrans) {
            LOGGER.info("supportTempToData, fileserver is not SupportTempTrans");
            return false;
        }
        Map<String, String> params = this.parseUrl(tempFileUrl);
        try {
            if (FileServerTempFileCache.hasFileServiceExt()) {
                LOGGER.info("supportTempToData, hasFileServiceExt");
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error("supportTempToData error", (Throwable)e);
            return false;
        }
        if (!CONFIG_KEY.equals(params.get("configKey"))) {
            LOGGER.info("supportTempToData, configKey is not tempfile.fileserver");
            return false;
        }
        return true;
    }

    private static boolean hasFileServiceExt() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> extFactory = Class.forName("kd.bos.fileservice.extension.FileServiceExtFactory");
        Method hasAttachFileServiceExt = extFactory.getMethod("hasAttachFileServiceExt", new Class[0]);
        return (Boolean)hasAttachFileServiceExt.invoke(null, new Object[0]);
    }

    class FileServerTempFileOutput
    implements TempFileOutput {
        private ByteArrayOutputStream out = new ByteArrayOutputStream();
        private String filename;
        private int timeout;
        private int bytelen = 0;

        public FileServerTempFileOutput(String filename, int timeout) {
            timeout = FileServerTempFileCache.this.checkTimeout(timeout);
            this.filename = filename;
            this.timeout = timeout;
        }

        @Deprecated
        public String flush() {
            return this.saveAsUrl();
        }

        public void write(byte[] bytes) {
            try {
                this.bytelen += bytes.length;
                FileServerTempFileCache.this.checkMaxsize(this.filename, this.bytelen);
                this.out.write(bytes);
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[]{"save tempfile by fileserver upload failed."});
            }
            finally {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    LOGGER.error((Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public void write(byte[] bytes, int off, int len) {
            try {
                this.bytelen += bytes.length;
                FileServerTempFileCache.this.checkMaxsize(this.filename, this.bytelen);
                this.out.write(bytes, off, len);
            }
            finally {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    LOGGER.error((Throwable)e);
                }
            }
        }

        public String saveAsUrl() {
            try {
                InputStream in = ByteSource.wrap((byte[])this.out.toByteArray()).openBufferedStream();
                in = FileServerTempFileCache.this.checkFile(in, this.filename);
                String dataFilePath = FileServerTempFileCache.this.saveInFileServer(this.filename, in, this.timeout);
                return FileServerTempFileCache.this.makeUrl(FileServerTempFileCache.CONFIG_KEY, dataFilePath);
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[]{"save tempfile by fileserver upload failed."});
            }
        }
    }
}

