/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.tempfile;

import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.TempFileCacheType;
import kd.bos.cache.TempFileOutput;
import kd.bos.cache.redis.CacheLimiter;
import kd.bos.cache.redis.CacheValueLimiter;
import kd.bos.cache.tempfile.BaseTempFileCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.cache.tempfile.TempFileJedisUtil;
import kd.bos.cache.tempfile.extesion.TempFileCacheExtHandlerFactory;
import kd.bos.context.RequestContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.redis.JedisClient;
import kd.bos.util.FileUtils;
import kd.bos.util.SystemProperties;
import org.apache.tools.zip.ZipOutputStream;
import redis.clients.jedis.util.SafeEncoder;

public class RedisTempFileCache
extends BaseTempFileCache
implements TempFileCache,
TempFileCacheDownloadable {
    private static final String SUFFIX_FILENAME = ".filename";
    private static final String PREFIX_URL = "url: ";
    private static String zipTempDir = SystemProperties.get((String)"java.io.tmpdir") + "/ierpupload";
    private final Log logger = LogFactory.getLog(RedisTempFileCache.class);

    public String saveAsUrl(String filename, InputStream in, int timeout) {
        byte[] bytes;
        timeout = this.checkTimeout(timeout);
        in = this.checkFile(in, filename);
        try {
            bytes = ByteStreams.toByteArray((InputStream)in);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[0]);
        }
        TempFileJedisUtil.JedisInfo jedisInfo = TempFileJedisUtil.getJedis();
        String id = this.saveAsId(filename, bytes, jedisInfo, timeout);
        return this.makeUrl(jedisInfo.configKey, id);
    }

    public String saveAsUrl(String filename, byte[] bytes, int timeout) {
        InputStream in;
        try {
            in = ByteSource.wrap((byte[])bytes).openBufferedStream();
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[0]);
        }
        return this.saveAsUrl(filename, in, timeout);
    }

    public Map<String, String> save(String filename, InputStream in, int timeout) {
        try {
            return this.save(filename, ByteStreams.toByteArray((InputStream)in), timeout);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[0]);
        }
    }

    public Map<String, String> save(String filename, byte[] bytes, int timeout) {
        timeout = this.checkTimeout(timeout);
        TempFileJedisUtil.JedisInfo jedisInfo = TempFileJedisUtil.getJedis();
        String id = this.saveAsId(filename, bytes, jedisInfo, timeout);
        HashMap<String, String> items = new HashMap<String, String>();
        items.put("configKey", jedisInfo.configKey);
        items.put("id", id);
        return items;
    }

    private String saveAsId(String filename, byte[] bytes, TempFileJedisUtil.JedisInfo jedisInfo, int timeout) {
        timeout = this.toExpireTime(timeout);
        JedisClient jedis = jedisInfo.jedis;
        String id = null;
        boolean isBroken = false;
        CacheLimiter.checkCount();
        CacheLimiter.checkCountTotalSize((byte[])bytes);
        try {
            id = this.createId();
            TempFileCacheExtHandlerFactory.createHandler().beforeSave(filename, id);
            byte[] key = SafeEncoder.encode((String)id);
            new CacheValueLimiter(null).checkByteValue(key, bytes);
            jedis.setex(key, timeout, bytes);
            String fileNameKey = id + SUFFIX_FILENAME;
            jedis.setex(fileNameKey, timeout, filename);
        }
        catch (Exception e) {
            isBroken = true;
            throw new KDException(BosErrorCode.redisRead, "save key:" + id, (Throwable)e);
        }
        finally {
            TempFileJedisUtil.release(jedis, isBroken);
        }
        return id;
    }

    public TempFileCacheDownloadable.Content download(HttpServletRequest request) {
        String id = request.getParameter("id");
        String configKey = request.getParameter("configKey");
        configKey = this.decodeConfigKey(configKey);
        return this.get(configKey, id, true);
    }

    public TempFileCacheDownloadable.Content download(Map<String, String> params) {
        String id = params.get("id");
        String configKey = params.get("configKey");
        configKey = this.decodeConfigKey(configKey);
        return this.get(configKey, id, true);
    }

    public TempFileCacheDownloadable.Content get(String configKey, String id) {
        return this.get(configKey, id, false);
    }

    public TempFileCacheDownloadable.Content get(String configKey, String id, boolean isCheck) {
        id = this.getRealId(id, isCheck);
        TempFileJedisUtil.JedisInfo jedisInfo = TempFileJedisUtil.getJedis();
        JedisClient jedis = jedisInfo.jedis;
        boolean isBroken = false;
        CacheLimiter.checkCount();
        try {
            byte[] key = SafeEncoder.encode((String)id);
            byte[] values = jedis.get(key);
            if (values == null) {
                TempFileCacheDownloadable.Content content = null;
                return content;
            }
            String fileNameKey = id + SUFFIX_FILENAME;
            String filename = jedis.get(fileNameKey);
            TempFileCacheDownloadable.Content content = new TempFileCacheDownloadable.Content(values.length, ByteSource.wrap((byte[])values).openBufferedStream(), filename);
            return content;
        }
        catch (Exception e) {
            isBroken = true;
            throw new KDException(BosErrorCode.redisRead, "get key:" + id + ", configKey:" + configKey, (Throwable)e);
        }
        finally {
            TempFileJedisUtil.release(jedis, isBroken);
        }
    }

    private boolean exists(String configKey, String id) {
        TempFileJedisUtil.JedisInfo jedisInfo = TempFileJedisUtil.getJedis();
        JedisClient jedis = jedisInfo.jedis;
        boolean isBroken = false;
        CacheLimiter.checkCount();
        try {
            byte[] key = SafeEncoder.encode((String)id);
            boolean bl = jedis.exists(key);
            return bl;
        }
        catch (Exception e) {
            isBroken = true;
            throw new KDException(BosErrorCode.redisRead, "exists get key:" + id + ",configKey:" + configKey, (Throwable)e);
        }
        finally {
            TempFileJedisUtil.release(jedis, isBroken);
        }
    }

    public void delete(String configKey, String id) {
        TempFileJedisUtil.JedisInfo jedisInfo = TempFileJedisUtil.getJedis();
        JedisClient jedis = jedisInfo.jedis;
        boolean isBroken = false;
        CacheLimiter.checkCount();
        try {
            byte[] key = SafeEncoder.encode((String)id);
            jedis.del(key);
            String fileNameKey = id + SUFFIX_FILENAME;
            jedis.del(fileNameKey);
        }
        catch (Exception e) {
            isBroken = true;
            throw new KDException(BosErrorCode.redisRead, "delete get key:" + id + ",configKey:" + configKey, (Throwable)e);
        }
        finally {
            TempFileJedisUtil.release(jedis, isBroken);
        }
    }

    public InputStream getInputStream(String url) {
        try {
            Map<String, String> m = this.parseUrl(url);
            String id = m.get("id");
            String configKey = m.get("configKey");
            configKey = this.decodeConfigKey(configKey);
            return this.get(configKey, id).getInputStream();
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.downloadFailed, PREFIX_URL + url, (Throwable)e);
        }
    }

    public boolean exists(String url) {
        try {
            Map<String, String> m = this.parseUrl(url);
            String id = m.get("id");
            String configKey = m.get("configKey");
            configKey = this.decodeConfigKey(configKey);
            return this.exists(configKey, id);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.downloadFailed, PREFIX_URL + url, (Throwable)e);
        }
    }

    public String saveAsFullUrl(String filename, InputStream in, int timeout) {
        String url = this.saveAsUrl(filename, in, timeout);
        return this.getUrlPrefix() + url;
    }

    public String saveAsFullUrl(String filename, byte[] bytes, int timeout) {
        String url = this.saveAsUrl(filename, bytes, timeout);
        return this.getUrlPrefix() + url;
    }

    private String getUrlPrefix() {
        RequestContext rc = RequestContext.get();
        if (rc == null || rc.getClientFullContextPath() == null) {
            throw new KDException(BosErrorCode.storageFileSaveFailed, new Object[]{"Can't saveAsFullUrl() in not web request, use saveAsUrl() instead."});
        }
        return rc.getClientFullContextPath();
    }

    public void remove(String url) {
        try {
            Map<String, String> m = this.parseUrl(url);
            String id = m.get("id");
            String configKey = m.get("configKey");
            configKey = this.decodeConfigKey(configKey);
            this.delete(configKey, id);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.deleteFailed, PREFIX_URL + url, (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private String saveAndDelZipFile(String zipName, int timeout, String zipFileUrl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void filesZipToTempdir(String[] urls, String zipFileUrl) {
        File zipFile = new File(FileUtils.checkFileUrl((String)zipFileUrl));
        try (FileOutputStream out = new FileOutputStream(zipFile);
             ZipOutputStream zos = new ZipOutputStream((OutputStream)out);){
            zipFileUrl = FileUtils.checkFileUrl((String)zipFileUrl);
            for (String url : urls) {
                Map<String, String> m = this.parseUrl(url);
                String urlId = m.get("id");
                String urlConfigKey = m.get("configKey");
                TempFileCacheDownloadable.Content content = this.get(urlConfigKey, urlId);
                try (InputStream in = content.getInputStream();){
                    this.doZip(in, zos, content.getFilename());
                }
            }
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[0]);
        }
    }

    public String compress(String zipName, String[] urls, int timeout) {
        String zipFileUrl = this.getFileUrl(null);
        zipFileUrl = FileUtils.checkFileUrl((String)zipFileUrl);
        this.filesZipToTempdir(urls, zipFileUrl);
        return this.saveAndDelZipFile(zipName, timeout, zipFileUrl);
    }

    @Deprecated
    public String filesZip(String zipName, String[] urls, int timeout) {
        return this.compress(zipName, urls, timeout);
    }

    public TempFileOutput newOutput(String filename, int timeout) {
        timeout = this.checkTimeout(timeout);
        return new RedisTempFileOutput(filename, timeout);
    }

    private String getFileUrl(String fileName) {
        Path tempDir = Paths.get(zipTempDir, new String[0]);
        if (!tempDir.toFile().exists()) {
            try {
                Files.createDirectories(tempDir, new FileAttribute[0]);
            }
            catch (Exception ex) {
                throw new KDException((Throwable)ex, BosErrorCode.createDirectoryFailed, new Object[]{"can't create directory, path:'" + zipTempDir + "'"});
            }
        }
        if (fileName != null) {
            return zipTempDir + "/" + fileName;
        }
        String id = this.createId();
        return zipTempDir + "/" + id + ".zip";
    }

    public String type() {
        return TempFileCacheType.REDIS.getName();
    }

    class RedisTempFileOutput
    implements TempFileOutput {
        private ByteArrayOutputStream out = new ByteArrayOutputStream();
        private String filename;
        private int timeout;
        private int bytelen = 0;

        public RedisTempFileOutput(String filename, int timeout) {
            this.filename = filename;
            this.timeout = timeout;
        }

        @Deprecated
        public String flush() {
            return this.saveAsUrl();
        }

        public void write(byte[] bytes) {
            try {
                this.bytelen += bytes.length;
                RedisTempFileCache.this.checkMaxsize(this.filename, this.bytelen);
                this.out.write(bytes);
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[0]);
            }
            finally {
                try {
                    this.out.close();
                }
                catch (IOException e1) {
                    RedisTempFileCache.this.logger.error((Throwable)e1);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public void write(byte[] bytes, int off, int len) {
            try {
                this.bytelen += len;
                RedisTempFileCache.this.checkMaxsize(this.filename, this.bytelen);
                this.out.write(bytes, off, len);
            }
            finally {
                try {
                    this.out.close();
                }
                catch (IOException e1) {
                    RedisTempFileCache.this.logger.error((Throwable)e1);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String saveAsUrl() {
            try {
                TempFileJedisUtil.JedisInfo jedisInfo = TempFileJedisUtil.getJedis();
                JedisClient jedis = jedisInfo.jedis;
                String id = null;
                boolean isBroken = false;
                try {
                    byte[] key;
                    long l;
                    do {
                        id = RedisTempFileCache.this.createId();
                        TempFileCacheExtHandlerFactory.createHandler().beforeSave(this.filename, id);
                        key = SafeEncoder.encode((String)id);
                        l = jedisInfo.jedis.setnx(key, this.out.toByteArray());
                    } while (l == 0L);
                    jedisInfo.jedis.expire(key, this.timeout);
                    String fileNameKey = id + RedisTempFileCache.SUFFIX_FILENAME;
                    jedisInfo.jedis.setex(fileNameKey, this.timeout, this.filename);
                }
                catch (Exception e) {
                    isBroken = true;
                    throw new KDException(BosErrorCode.redisRead, "saveAsUrl key:" + id, (Throwable)e);
                }
                finally {
                    TempFileJedisUtil.release(jedis, isBroken);
                }
                String string = RedisTempFileCache.this.makeUrl(jedisInfo.configKey, id);
                return string;
            }
            finally {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    RedisTempFileCache.this.logger.error((Throwable)e);
                }
            }
        }
    }
}

