/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.tempfile;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.TempFileCacheType;
import kd.bos.cache.TempFileOutput;
import kd.bos.cache.tempfile.BaseTempFileCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.FileUtils;
import kd.bos.util.SystemProperties;
import org.apache.tools.zip.ZipOutputStream;

public class TempFileCacheWrapper
extends BaseTempFileCache
implements TempFileCache,
TempFileCacheDownloadable {
    private static final Log LOGGER = LogFactory.getLog(TempFileCacheWrapper.class);
    private static String zipTempDir = SystemProperties.get((String)"java.io.tmpdir") + "/ierpupload";
    private TempFileCache tempFileCache;
    private final Map<TempFileCacheType, TempFileCache> tempFileCacheMap = new ConcurrentHashMap<TempFileCacheType, TempFileCache>();

    private TempFileCacheWrapper() {
    }

    public TempFileCacheWrapper(TempFileCache tempFileCache) {
        this.tempFileCache = tempFileCache;
    }

    private TempFileCache createTempFileCache(TempFileCacheType type) {
        if (TempFileCacheType.DISK.getName().equals(type.getName())) {
            try {
                return (TempFileCache)Class.forName(TempFileCacheType.DISK.getClazz()).newInstance();
            }
            catch (Exception e) {
                LOGGER.warn("create disk tempFile failed", (Throwable)e);
            }
        }
        if (TempFileCacheType.REDIS.getName().equals(type.getName())) {
            try {
                return (TempFileCache)Class.forName(TempFileCacheType.REDIS.getClazz()).newInstance();
            }
            catch (Exception e) {
                LOGGER.warn("create redis tempFile failed", (Throwable)e);
            }
        }
        if (TempFileCacheType.FILE_SERVER.getName().equals(type.getName())) {
            try {
                return (TempFileCache)Class.forName(TempFileCacheType.FILE_SERVER.getClazz()).newInstance();
            }
            catch (Exception e) {
                LOGGER.warn("create fileserver tempFile failed", (Throwable)e);
            }
        }
        return null;
    }

    TempFileCache getTempFileCache(String configKey) {
        TempFileCacheType type = "tempfile.fileserver".equals(configKey) ? TempFileCacheType.FILE_SERVER : ("tempfile.disk".equals(configKey) ? TempFileCacheType.DISK : TempFileCacheType.REDIS);
        TempFileCache tempFileCache = this.tempFileCacheMap.get(type);
        if (tempFileCache == null && (tempFileCache = this.createTempFileCache(type)) != null) {
            this.tempFileCacheMap.put(type, tempFileCache);
        }
        return tempFileCache;
    }

    public String saveAsUrl(String filename, InputStream in, int timeout) {
        return this.tempFileCache.saveAsUrl(filename, in, timeout);
    }

    public String saveAsUrl(String filename, byte[] bytes, int timeout) {
        return this.tempFileCache.saveAsUrl(filename, bytes, timeout);
    }

    public String saveAsFullUrl(String filename, InputStream in, int timeout) {
        return this.tempFileCache.saveAsFullUrl(filename, in, timeout);
    }

    public String saveAsFullUrl(String filename, byte[] bytes, int timeout) {
        return this.tempFileCache.saveAsFullUrl(filename, bytes, timeout);
    }

    public Map<String, String> save(String filename, InputStream in, int timeout) {
        return this.tempFileCache.save(filename, in, timeout);
    }

    public Map<String, String> save(String filename, byte[] bytes, int timeout) {
        return this.tempFileCache.save(filename, bytes, timeout);
    }

    public InputStream getInputStream(String url) {
        Map<String, String> m = this.parseUrl(url);
        String configKey = this.decodeConfigKey(m.get("configKey"));
        TempFileCache cache = this.getTempFileCache(configKey);
        return cache == null ? this.tempFileCache.getInputStream(url) : cache.getInputStream(url);
    }

    public boolean exists(String url) {
        Map<String, String> m = this.parseUrl(url);
        String configKey = this.decodeConfigKey(m.get("configKey"));
        TempFileCache cache = this.getTempFileCache(configKey);
        return cache == null ? this.tempFileCache.exists(url) : cache.exists(url);
    }

    public void remove(String url) {
        Map<String, String> m = this.parseUrl(url);
        String configKey = this.decodeConfigKey(m.get("configKey"));
        TempFileCache cache = this.getTempFileCache(configKey);
        if (cache == null) {
            this.tempFileCache.remove(url);
        } else {
            cache.remove(url);
        }
    }

    public TempFileOutput newOutput(String filename, int timeout) {
        return this.tempFileCache.newOutput(filename, timeout);
    }

    public String filesZip(String zipName, String[] urls, int timeout) {
        return this.compress(zipName, urls, timeout);
    }

    public String compress(String zipName, String[] urls, int timeout) {
        String zipFilePath = FileUtils.checkFileUrl((String)this.getZipFilePath(null));
        this.filesZipToTempdir(urls, zipFilePath);
        return this.saveAndDelZipFile(zipName, timeout, zipFilePath);
    }

    private String getZipFilePath(String fileName) {
        Path tempDir = Paths.get(zipTempDir, new String[0]);
        if (!tempDir.toFile().exists()) {
            try {
                Files.createDirectories(tempDir, new FileAttribute[0]);
            }
            catch (Exception ex) {
                throw new KDException((Throwable)ex, BosErrorCode.createDirectoryFailed, new Object[]{"can't create directory, path:'" + zipTempDir + "'"});
            }
        }
        if (fileName != null) {
            return zipTempDir + "/" + fileName;
        }
        String id = this.createId();
        return zipTempDir + "/" + id + ".zip";
    }

    private void filesZipToTempdir(String[] urls, String zipFileUrl) {
        File zipFile = new File(FileUtils.checkFileUrl((String)zipFileUrl));
        try (FileOutputStream out = new FileOutputStream(zipFile);
             ZipOutputStream zos = new ZipOutputStream((OutputStream)out);){
            for (String url : urls) {
                Map<String, String> m = this.parseUrl(url);
                String urlId = m.get("id");
                String urlConfigKey = m.get("configKey");
                TempFileCacheDownloadable.Content content = this.get(urlConfigKey, urlId);
                try (InputStream in = content.getInputStream();){
                    this.doZip(in, zos, content.getFilename());
                }
            }
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[0]);
        }
    }

    /*
     * Exception decompiling
     */
    private String saveAndDelZipFile(String zipName, int timeout, String zipFileUrl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public TempFileCacheDownloadable.Content download(HttpServletRequest request) {
        String configKey = this.decodeConfigKey(request.getParameter("configKey"));
        TempFileCacheDownloadable downloadable = (TempFileCacheDownloadable)this.getTempFileCache(configKey);
        if (downloadable == null) {
            return ((TempFileCacheDownloadable)this.tempFileCache).download(request);
        }
        return downloadable.download(request);
    }

    public TempFileCacheDownloadable.Content download(Map<String, String> params) {
        String configKey = this.decodeConfigKey(params.get("configKey"));
        TempFileCacheDownloadable downloadable = (TempFileCacheDownloadable)this.getTempFileCache(configKey);
        if (downloadable == null) {
            return ((TempFileCacheDownloadable)this.tempFileCache).download(params);
        }
        return downloadable.download(params);
    }

    public TempFileCacheDownloadable.Content get(String configKey, String id) {
        TempFileCacheDownloadable downloadable = (TempFileCacheDownloadable)this.getTempFileCache(configKey);
        if (downloadable == null) {
            return ((TempFileCacheDownloadable)this.tempFileCache).get(configKey, id);
        }
        return downloadable.get(configKey, id);
    }

    public String type() {
        return this.tempFileCache.type();
    }

    public boolean supportTempToData(String tempFileUrl) {
        return this.tempFileCache.supportTempToData(tempFileUrl);
    }
}

