/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.context;

import java.io.Serializable;
import java.util.Stack;
import kd.bos.exception.KDException;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public final class KdtxRequestContext
implements Serializable {
    private static final long serialVersionUID = 4623644258596122930L;
    private String xid;
    private int dtxType;
    private String branchId;
    private Stack<String> xidStack;
    private boolean isFirst = true;
    private boolean isCommitted = true;
    private boolean isBindLocalTx = false;
    private long localTxId = 0L;
    private int waitCommitStackSize;
    private static ThreadLocal<KdtxRequestContext> current = new ThreadLocal();

    @SdkInternal
    public static void set(KdtxRequestContext krc) {
        current.set(krc);
    }

    public String getXid() {
        return this.xid;
    }

    @SdkInternal
    public void setXid(String xid) {
        this.xid = xid;
    }

    @SdkInternal
    public int getDtxType() {
        return this.dtxType;
    }

    @SdkInternal
    public void setDtxType(int dtxType) {
        this.dtxType = dtxType;
    }

    @SdkInternal
    public String getBranchId() {
        return this.branchId;
    }

    @SdkInternal
    public void setBranchId(String branchId) {
        this.branchId = branchId;
    }

    @SdkInternal
    public long getLocalTxId() {
        return this.localTxId;
    }

    @SdkInternal
    public void bindLocalTx(long localTxId) {
        if (localTxId == 0L) {
            throw new KDException("local tx id is 0");
        }
        this.isBindLocalTx = true;
        this.localTxId = localTxId;
    }

    @SdkInternal
    public static KdtxRequestContext copy(KdtxRequestContext rc) {
        KdtxRequestContext copy = KdtxRequestContext.create(false);
        if (rc != null) {
            copy.xid = rc.xid;
            copy.branchId = rc.branchId;
            copy.xidStack = KdtxRequestContext.deepCopyStack(rc.xidStack);
        }
        return copy;
    }

    private static Stack<String> deepCopyStack(Stack<String> stack) {
        Stack<String> stackNew = new Stack<String>();
        if (stack != null) {
            for (String xid : stack) {
                stackNew.push(xid);
            }
        }
        return stackNew;
    }

    @SdkInternal
    public static void copyAndSet(KdtxRequestContext rc) {
        KdtxRequestContext copy = KdtxRequestContext.copy(rc);
        KdtxRequestContext.set(copy);
    }

    @SdkInternal
    public static KdtxRequestContext create() {
        return KdtxRequestContext.create(true);
    }

    @SdkInternal
    public static KdtxRequestContext create(boolean setCurrent) {
        KdtxRequestContext rc = new KdtxRequestContext();
        if (setCurrent) {
            KdtxRequestContext.set(rc);
        }
        return rc;
    }

    public static KdtxRequestContext get() {
        KdtxRequestContext rc = current.get();
        if (rc == null) {
            rc = KdtxRequestContext.create();
        }
        return rc;
    }

    private KdtxRequestContext() {
    }

    @SdkInternal
    public Stack<String> getXidStack() {
        return this.xidStack;
    }

    @SdkInternal
    public void setXidStack(Stack<String> xidStack) {
        this.xidStack = xidStack;
    }

    @SdkInternal
    public void popXidStack() {
        if (this.xidStack == null || this.xidStack.isEmpty()) {
            return;
        }
        this.xidStack.pop();
        if (this.xidStack.empty()) {
            this.xidStack = null;
        }
    }

    @SdkInternal
    public String peekXidStack() {
        if (this.xidStack == null || this.xidStack.isEmpty()) {
            return null;
        }
        return this.xidStack.peek();
    }

    @SdkInternal
    public void pushXidStack(String xid) {
        if (this.xidStack == null) {
            this.xidStack = new Stack();
        }
        this.xidStack.push(xid);
    }

    @SdkInternal
    public int getXidStackSize() {
        if (this.xidStack == null) {
            return 0;
        }
        return this.xidStack.size();
    }

    @SdkInternal
    public void remove() {
        this.branchId = null;
        this.xid = null;
        this.xidStack.clear();
    }

    @SdkInternal
    public boolean isFirst() {
        return this.isFirst;
    }

    @SdkInternal
    public void setFirst(boolean first) {
        this.isFirst = first;
    }

    @SdkInternal
    public boolean isCommitted() {
        return this.isCommitted;
    }

    @SdkInternal
    public void setCommitted(boolean committed) {
        this.isCommitted = committed;
    }

    @SdkInternal
    public void incrWaitCommitSeze() {
        ++this.waitCommitStackSize;
    }

    @SdkInternal
    public void decrWaitCommitSize() {
        --this.waitCommitStackSize;
    }

    @SdkInternal
    public int getWaitCommitStackSize() {
        return this.waitCommitStackSize;
    }

    private static void popTx() {
        KdtxRequestContext.get().popXidStack();
        String runXid = KdtxRequestContext.get().peekXidStack();
        KdtxRequestContext.get().setXid(runXid);
    }

    @SdkInternal
    public static void popDealedTx(String doActionXid) {
        String nextDealXid = KdtxRequestContext.get().getXid();
        if (doActionXid.equals(nextDealXid)) {
            KdtxRequestContext.popTx();
        }
    }
}

