/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.context;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import kd.bos.audit.Audit;
import kd.bos.context.RequestContextCreator;
import kd.bos.context.RequestContextThreadBinder;
import kd.bos.context.RequestTimeoutContext;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.debug.DebugInfo;
import kd.bos.lang.Lang;
import kd.bos.lang.LangHolder;
import kd.bos.security.KDCallerInfo;
import kd.bos.security.KDReflection;
import kd.bos.tenant.TenantInfo;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.resource.Resources;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SdkPublic
public final class RequestContext
implements Serializable {
    private static Logger log = LoggerFactory.getLogger(RequestContext.class);
    public static final String key_tenantId = "tenantId";
    public static final String key_userId = "userId";
    public static final String key_userName = "userName";
    public static final String key_userOpenId = "userOpenId";
    public static final String key_userType = "userType";
    public static final String key_orgId = "orgId";
    public static final String key_loginTime = "loginTime";
    public static final String key_loginIP = "loginIP";
    public static final String key_sandboxId = "sandboxId";
    public static final String key_uId = "uid";
    public static final String key_requestId = "requestId";
    public static final String key_client = "client";
    public static final String key_userAgent = "userAgent";
    public static final String key_clientUrl = "clientUrl";
    public static final String MANUAL_STRING = "MA";
    private static final long serialVersionUID = 6680111403720606502L;
    private static final String keyword_tenantCode = "{tenantCode}";
    private static final ThreadLocal<RequestContext> current = new ThreadLocal();
    private static final ThreadLocal<Exception[]> currentSetStack = new ThreadLocal();
    private static final String traceIdLogEnable = "gov.trace.traceid.log.enable";
    private static boolean logSetStack = false;
    private String requestId;
    private String traceId;
    private String sandboxId;
    private String client;
    private String userAgent;
    private String globalSessionId;
    private String localSessionId;
    private String tenantId;
    private String tenantCode;
    private String userId;
    private long orgId;
    private String userName;
    private String userOpenId;
    private String userType;
    private String clientFullContextPath;
    private String clientContextPath;
    private String clientUrl;
    private String queryString;
    private Lang lang;
    private TenantInfo tenantInfo;
    private String loginIP;
    private String loginTime;
    private DebugInfo debugInfo;
    private Audit audit;
    private String yzjAppId;
    private String yzjAppTicket;
    private String xid;
    private int xidStep;
    private String accountId;
    private String uid;
    private String loginOrg;
    private String tccTransactionId;
    private String tccBranchId;
    private String accCompanyId;
    private String api3rdAppId;
    private Long bizPartnerId;
    private String clientImageServer;
    private String operationType;
    private String authType;
    private RequestTimeoutContext requestTimeoutContext;

    private RequestContext() {
        KDCallerInfo caller;
        if (KDReflection.isEnableSecurity() && KDReflection.isCustomerClass((Class)(caller = KDReflection.getCallerClassUntilNot((Class[])new Class[]{RequestContext.class, RequestContextCreator.class})).getCallerClass())) {
            String msg = Resources.getString((String)"\u7981\u6b62\u521b\u5efaRequestContext: ", (String)"RequestContext_0", (String)"bos-framework", (Object[])new Object[0]) + caller.getCallerClass().getName() + "#" + KDReflection.getCallerMethodName((int)caller.getCallStackDepth());
            throw KDReflection.securityException((String)msg);
        }
    }

    public static RequestContext copy(RequestContext rc) {
        RequestContext copy = RequestContext.create(false);
        if (rc != null) {
            copy.requestId = rc.requestId;
            copy.traceId = rc.traceId;
            copy.sandboxId = rc.sandboxId;
            copy.client = rc.client;
            copy.userAgent = rc.userAgent;
            copy.globalSessionId = rc.globalSessionId;
            copy.localSessionId = rc.localSessionId;
            copy.tenantId = rc.tenantId;
            copy.tenantCode = rc.tenantCode;
            copy.userId = rc.userId;
            copy.orgId = rc.orgId;
            copy.userName = rc.userName;
            copy.userOpenId = rc.userOpenId;
            copy.userType = rc.userType;
            copy.clientFullContextPath = rc.clientFullContextPath;
            copy.clientContextPath = rc.clientContextPath;
            copy.clientUrl = rc.clientUrl;
            copy.queryString = rc.queryString;
            copy.lang = rc.lang;
            copy.tenantInfo = rc.tenantInfo;
            copy.loginIP = rc.loginIP;
            copy.loginTime = rc.loginTime;
            copy.debugInfo = rc.debugInfo;
            copy.yzjAppId = rc.yzjAppId;
            copy.yzjAppTicket = rc.yzjAppTicket;
            copy.accountId = rc.accountId;
            copy.uid = rc.uid;
            copy.tccTransactionId = rc.tccTransactionId;
            copy.tccBranchId = rc.tccBranchId;
            copy.accCompanyId = rc.accCompanyId;
            copy.api3rdAppId = rc.api3rdAppId;
            copy.operationType = rc.operationType;
            copy.bizPartnerId = rc.bizPartnerId;
            copy.operationType = rc.operationType;
            copy.authType = rc.authType;
        }
        return copy;
    }

    public static RequestContext copyAndSet(RequestContext rc) {
        RequestContext copy = RequestContext.copy(rc);
        copy.traceId = TraceIdUtil.createTraceIdString();
        RequestContext.set(copy);
        RequestContextThreadBinder.bind(copy);
        return copy;
    }

    public static RequestContext create() {
        return RequestContext.create(true);
    }

    public static RequestContext create(boolean setCurrent) {
        RequestContext rc = new RequestContext();
        if (setCurrent) {
            RequestContext.set(rc);
        }
        return rc;
    }

    public static RequestContext get() {
        return current.get();
    }

    public static RequestContext getOrCreate() {
        RequestContext rc = RequestContext.get();
        if (rc == null) {
            rc = RequestContext.create();
        }
        return rc;
    }

    public static void set(RequestContext rc) {
        RequestContext.bindCurrentTraceId(rc);
        current.set(rc);
        if (logSetStack && rc != null) {
            currentSetStack.set(new Exception[]{new Exception("RequestContext.set: tenantId=" + rc.getTenantId() + ", accountId=" + rc.getAccountId()), null, null});
        }
    }

    private static void bindCurrentTraceId(RequestContext rc) {
        if (rc == null) {
            return;
        }
        if (current.get() == null) {
            return;
        }
        String currentTraceId = current.get().getTraceId();
        if (currentTraceId == null || rc.getTraceId() == null) {
            return;
        }
        String currentThreadName = Thread.currentThread().getName();
        if ((currentThreadName.startsWith("http") || currentThreadName.contains("RpcRequest")) && !currentTraceId.equals(rc.getTraceId())) {
            if (Boolean.parseBoolean(System.getProperty(traceIdLogEnable, "false"))) {
                log.warn("\u5f53\u524dbindCurrentTraceId\u65b9\u6cd5\u4e2dTraceId\u4e3a {},\u5f53\u524dHttp\u6216Rpc\u8bf7\u6c42\u5df2\u7ecf\u5b58\u5728\u4e0a\u4e0b\u6587,traceId\u590d\u7528\u5f53\u524d\u7684\uff0c\u8c03\u7528\u5806\u6808\u4e3a\uff1a", (Object)currentTraceId, (Object)new Exception());
            }
            rc.setTraceId(currentTraceId);
        }
    }

    public static String getSetStack() {
        Exception[] es = currentSetStack.get();
        if (es != null) {
            StringBuilder sb = new StringBuilder(8192);
            sb.append("\n#set\n").append(RequestContext.getStack(es[0]));
            if (es[1] != null) {
                sb.append("\n#setTentantId\n").append(RequestContext.getStack(es[1]));
            }
            if (es[2] != null) {
                sb.append("\n#setAccountId\n").append(RequestContext.getStack(es[2]));
            }
            return sb.toString();
        }
        return null;
    }

    private static String getStack(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String s = sw.toString();
        if (s.length() > 2048) {
            s = s.substring(0, 2048);
        }
        return s;
    }

    @SdkInternal
    public int getXidStep() {
        return this.xidStep;
    }

    @SdkInternal
    public void setXidStep(int xidStep) {
        this.xidStep = xidStep;
    }

    @SdkInternal
    public String getXid() {
        return this.xid;
    }

    @SdkInternal
    public void setXid(String xid) {
        this.xid = xid;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        String currentThreadName = Thread.currentThread().getName();
        String currentThreadTraceId = TraceIdUtil.getCurrentTraceIdString();
        if (this.traceId != null && (currentThreadName.startsWith("http") || currentThreadName.contains("RpcRequest")) && !this.traceId.equals(traceId) && !currentThreadTraceId.equals(traceId)) {
            if (Boolean.parseBoolean(System.getProperty(traceIdLogEnable, "false"))) {
                log.warn("\u5f53\u524dSetTraceId\u65b9\u6cd5,currentTraceId\u4e3a {},paramTraceId\u4e3a {},\u5f53\u524dHttp\u6216Rpc\u8bf7\u6c42\u4e0a\u4e0b\u6587\u5df2\u5b58\u5728TraceId,\u8c03\u7528setTraceId\u65b9\u6cd5\u65e0\u6548,\u8c03\u7528\u5806\u6808\u4e3a\uff1a", new Object[]{this.traceId, traceId, new Exception()});
            }
        } else {
            this.traceId = traceId;
        }
    }

    public String getUserOpenId() {
        return this.userOpenId;
    }

    public void setUserOpenId(String userOpenId) {
        this.userOpenId = userOpenId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    @SdkInternal
    public boolean isSandbox() {
        return false;
    }

    @Deprecated
    @SdkInternal
    public String getSandboxId() {
        return this.getAccountId();
    }

    @Deprecated
    @SdkInternal
    public void setSandboxId(String sandboxId) {
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getGlobalSessionId() {
        return this.globalSessionId;
    }

    public void setGlobalSessionId(String globalSessionId) {
        this.globalSessionId = globalSessionId;
    }

    @SdkInternal
    public String getLocalSessionId() {
        return this.localSessionId;
    }

    @SdkInternal
    public void setLocalSessionId(String localSessionId) {
        this.localSessionId = localSessionId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        if (this.tenantId != null) {
            throw new RuntimeException("Can't reset the tenantId.");
        }
        this.tenantId = tenantId;
        if (logSetStack) {
            RequestContext.currentSetStack.get()[1] = new Exception("setTenantId=" + tenantId);
        }
    }

    @Deprecated
    @SdkInternal
    public String getUserId() {
        return this.userId;
    }

    @SdkInternal
    public void setUserId(String userId) {
        if (this.userId != null) {
            throw new RuntimeException("Can't reset the userId.");
        }
        this.userId = userId;
    }

    public long getCurrUserId() {
        if (this.userId == null) {
            return -101101L;
        }
        return Long.parseLong(this.userId);
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getClientUrl() {
        return this.clientUrl;
    }

    public void setClientUrl(String clientUrl) {
        this.clientUrl = clientUrl;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getClientFullContextPath() {
        return this.clientFullContextPath;
    }

    public void setClientFullContextPath(String clientFullContextPath) {
        this.clientFullContextPath = clientFullContextPath;
    }

    @SdkInternal
    @Deprecated
    public String getClientContextPath() {
        return this.clientContextPath;
    }

    @SdkInternal
    @Deprecated
    public void setClientContextPath(String clientContextPath) {
        this.clientContextPath = clientContextPath;
    }

    public String getAccCompanyId() {
        return this.accCompanyId;
    }

    public void setAccCompanyId(String accCompanyId) {
        this.accCompanyId = accCompanyId;
    }

    @SdkInternal
    @Deprecated
    public String getId() {
        return this.tenantInfo.getId();
    }

    @SdkInternal
    @Deprecated
    public void setId(String id) {
        this.tenantInfo.setId(id);
    }

    @SdkInternal
    @Deprecated
    public String getName() {
        return this.tenantInfo.getName();
    }

    @SdkInternal
    @Deprecated
    public void setName(String name) {
        this.tenantInfo.setName(name);
    }

    @Deprecated
    @SdkInternal
    public String getTenantOrgid() {
        Account account = AccountUtils.getCorrectAccount((String)this.accountId, (String)this.tenantInfo.getId());
        return account.getYzjOrgNo();
    }

    public long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(long orgid) {
        this.orgId = orgid;
    }

    @SdkInternal
    public int hashCode() {
        return this.tenantInfo.hashCode();
    }

    public Lang getLang() {
        if (this.lang == null) {
            this.lang = Lang.defaultLang();
        }
        return this.lang;
    }

    public void setLang(Lang lang) {
        this.lang = lang;
    }

    public TenantInfo getTenantInfo() {
        if (this.tenantInfo == null) {
            this.tenantInfo = new TenantInfo(this.tenantId, this.tenantId);
        }
        return this.tenantInfo;
    }

    public void setTenantInfo(TenantInfo tenantInfo) {
        if (this.tenantInfo != null) {
            throw new RuntimeException("Can't reset the tenantInfo.");
        }
        this.tenantInfo = tenantInfo;
    }

    public String getLoginIP() {
        return this.loginIP;
    }

    public void setLoginIP(String loginIP) {
        this.loginIP = loginIP;
    }

    public String getLoginTime() {
        return this.loginTime;
    }

    public void setLoginTime(String loginTime) {
        this.loginTime = loginTime;
    }

    @SdkInternal
    public boolean equals(Object obj) {
        return this.tenantInfo.equals(obj);
    }

    public String toString() {
        return this.getTenantInfo().toString();
    }

    @SdkInternal
    public DebugInfo getDebugInfo() {
        return this.debugInfo;
    }

    @SdkInternal
    public void setDebugInfo(DebugInfo debugInfo) {
        this.debugInfo = debugInfo;
    }

    @SdkInternal
    public Audit getAudit() {
        if (this.audit == null) {
            this.audit = new Audit(this.traceId);
        }
        return this.audit;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getYzjAppId() {
        return this.yzjAppId;
    }

    public void setYzjAppId(String yzjAppId) {
        this.yzjAppId = yzjAppId;
    }

    public String getYzjAppTicket() {
        return this.yzjAppTicket;
    }

    public void setYzjAppTicket(String yzjAppTicket) {
        this.yzjAppTicket = yzjAppTicket;
    }

    public String getTenantCode() {
        return this.tenantCode;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public String convertTenantURL(String url) {
        if (this.tenantCode != null && url.contains(keyword_tenantCode)) {
            return url.replace(keyword_tenantCode, this.tenantCode);
        }
        return url;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        if (this.accountId != null) {
            throw new RuntimeException("Can't reset the accountId.");
        }
        this.accountId = accountId;
        if (logSetStack) {
            RequestContext.currentSetStack.get()[2] = new Exception("setAccountId=" + accountId);
        }
    }

    @SdkInternal
    public String getUid() {
        return this.uid;
    }

    @SdkInternal
    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getLoginOrg() {
        return this.loginOrg;
    }

    public void setLoginOrg(String loginOrg) {
        if (this.loginOrg != null) {
            throw new RuntimeException("Can't reset the loginOrg.");
        }
        this.loginOrg = loginOrg;
    }

    @SdkInternal
    public String getTccBranchId() {
        return this.tccBranchId;
    }

    @SdkInternal
    public void setTccBranchId(String tccBranchId) {
        this.tccBranchId = tccBranchId;
    }

    public String getApi3rdAppId() {
        return this.api3rdAppId;
    }

    public void setApi3rdAppId(String api3rdAppId) {
        this.api3rdAppId = api3rdAppId;
    }

    public Long getBizPartnerId() {
        return this.bizPartnerId;
    }

    public void setBizPartnerId(Long bizPartnerId) {
        this.bizPartnerId = bizPartnerId;
    }

    @SdkInternal
    public String getClientImageServer() {
        return this.clientImageServer;
    }

    @SdkInternal
    public void setClientImageServer(String clientImageServer) {
        this.clientImageServer = clientImageServer;
    }

    @SdkInternal
    public String getTccTransactionId() {
        return this.tccTransactionId;
    }

    @SdkInternal
    public void setTccTransactionId(String tccTransactionId) {
        this.tccTransactionId = tccTransactionId;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    @SdkInternal
    public String getAuthType() {
        return this.authType;
    }

    @SdkInternal
    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public RequestTimeoutContext getRequestTimeoutContext() {
        return this.requestTimeoutContext;
    }

    public void setRequestTimeoutContext(RequestTimeoutContext requestTimeoutContext) {
        RequestTimeoutContext currentContext = RequestTimeoutContext.get();
        this.requestTimeoutContext = currentContext == null ? requestTimeoutContext : currentContext;
    }

    static {
        Lang.setHolder((LangHolder)new LangHolder(){

            public Lang get() {
                RequestContext ctx = RequestContext.get();
                return ctx == null ? Lang.defaultLang() : ctx.getLang();
            }
        });
        ConfigurationUtil.observeBoolean((String)"requestContext.logSetStack", (boolean)logSetStack, v -> {
            logSetStack = v;
        });
    }
}

