/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.context;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logging.LogRequestContext;
import kd.bos.thread.ThreadTruck;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.StringUtils;

public class RequestContextThreadBinder {
    private static final Log log = LogFactory.getLog(RequestContextThreadBinder.class);
    private static final boolean logAnonymityEnable = Boolean.getBoolean("log.anonymity.enable");
    private static LogRequestContext logRequestContext = null;

    public static void bind(RequestContext rc) {
        String currentTraceId = (String)ThreadTruck.get((Object)"apm.traceid.string");
        if (StringUtils.isEmpty((String)currentTraceId)) {
            currentTraceId = TraceIdUtil.createTraceIdString();
        }
        if (StringUtils.isEmpty((String)rc.getTraceId())) {
            rc.setTraceId(currentTraceId);
        } else if (Thread.currentThread().getName().contains("RpcRequest") && !rc.getTraceId().equals(currentTraceId)) {
            if (Boolean.getBoolean("gov.trace.traceid.log.enable")) {
                log.warn("\u5f53\u524dRpc\u8bf7\u6c42\u5df2\u7ecf\u5b58\u5728TraceId\u4e3a{}\uff0c\u4e0d\u5141\u8bb8\u518dbind\u65b0traceId{},\u5806\u6808\u4e3a\uff1a", new Object[]{ThreadTruck.get((Object)"apm.traceid.string"), rc.getTraceId(), new Exception()});
            }
            rc.setTraceId(currentTraceId);
        }
        Map map = RequestContextThreadBinder.createThreadRequestTagMap(rc);
        if (logRequestContext != null) {
            map = logRequestContext.createRequestContextMap(map, (Object)rc);
        }
        ThreadTruck.put((Object)"rcinfo", map);
    }

    private static Map<String, String> createThreadRequestTagMap(RequestContext rc) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantId", rc.getTenantId());
        map.put("orgId", String.valueOf(rc.getOrgId()));
        map.put("userId", rc.getUserId());
        if (!logAnonymityEnable) {
            map.put("userName", rc.getUserName());
        }
        map.put("traceId", rc.getTraceId());
        map.put("accountId", rc.getAccountId());
        map.put("userOpenId", rc.getUserOpenId());
        return map;
    }

    static {
        ServiceLoader<LogRequestContext> serviceLoader = ServiceLoader.load(LogRequestContext.class);
        Iterator<LogRequestContext> itr = serviceLoader.iterator();
        while (itr.hasNext()) {
            try {
                LogRequestContext logReqCont = itr.next();
                if (!(logReqCont instanceof LogRequestContext)) continue;
                logRequestContext = logReqCont;
                log.info("MsgAdvancedCreator serviceLoader successfully loaded class: " + logReqCont.getClass().getName());
            }
            catch (Error | Exception e) {
                log.warn("Load LogRequestContext failed,errorMessage:" + e.getMessage(), e);
            }
        }
    }
}

