/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.debug;

import java.io.Serializable;
import java.lang.reflect.Method;
import kd.bos.context.RequestContext;
import kd.bos.framework.lifecycle.SysServiceLayerManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DebugInfo
implements Serializable {
    public static final String debugAppId = "debug";
    private static final Log log = LogFactory.getLog(DebugInfo.class);
    private static final long serialVersionUID = 85269830181302488L;
    private static final Method mSetupThreadDebug;
    private static final Method mClearThreadDebug;
    private static final Class<? extends Enum> enumType;
    private final String debugId;
    private final String debugThreadType;

    public DebugInfo(String debugId, boolean cmd) {
        this.debugId = debugId;
        this.debugThreadType = cmd ? "cmd" : "main";
    }

    public static void setupThreadDebug(DebugInfo di) {
        if (di != null) {
            try {
                Enum type = Enum.valueOf(enumType, di.getDebugThreadType());
                mSetupThreadDebug.invoke(null, di.getDebugId(), type);
            }
            catch (Exception e) {
                throw new RuntimeException("SetupThreadDebug failed!", e);
            }
        }
    }

    public static void clearThreadDebug() {
        DebugInfo di = RequestContext.get().getDebugInfo();
        if (di != null) {
            try {
                mClearThreadDebug.invoke(null, di.getDebugId());
            }
            catch (Exception e) {
                throw new RuntimeException("ClearThreadDebug failed!", e);
            }
            finally {
                RequestContext.get().setDebugInfo(null);
            }
        }
    }

    public String getDebugId() {
        return this.debugId;
    }

    public String getDebugThreadType() {
        return this.debugThreadType;
    }

    public boolean isCmd() {
        return "cmd".equals(this.debugThreadType);
    }

    static {
        String classNameScriptExecutorFactory = "kd.bos.script.ScriptExecutorFactory";
        String classNameDebugThreadType = "kd.bos.script.debug.DebugThreadType";
        if (!SysServiceLayerManager.isNeedDebugModel()) {
            classNameScriptExecutorFactory = "kd.bos.mservice.debug.ScriptExecutorFactory";
            classNameDebugThreadType = "kd.bos.mservice.debug.DebugThreadType";
        }
        try {
            Class<?> clsScriptExecutorFactory = Class.forName(classNameScriptExecutorFactory);
            mClearThreadDebug = clsScriptExecutorFactory.getMethod("clearThreadDebug", String.class);
            enumType = Class.forName(classNameDebugThreadType);
            mSetupThreadDebug = clsScriptExecutorFactory.getMethod("setupThreadDebug", String.class, enumType);
        }
        catch (Exception e) {
            log.error("DebugInfo init error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

