/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import kd.bos.cache.redis.CacheLimiter;
import kd.bos.db.DBLimiter;
import kd.bos.instance.Instance;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.thread.ThreadTruck;
import org.eclipse.jetty.server.Response;

public class ThreadLifeCycleFilter
implements Filter {
    public static final String REQUEST_ENTER_TIME = "web.request_enter_time";

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            ThreadLifeCycleManager.start();
            ThreadTruck.put((Object)REQUEST_ENTER_TIME, (Object)System.currentTimeMillis());
            if (Instance.isPausedServiceByMonitor() && response instanceof Response) {
                ((Response)response).sendError(406, "service is paused by monitor");
                return;
            }
            CacheLimiter.init();
            DBLimiter.init();
            ThreadTruck.put((Object)"limiter.is_web_rpc", (Object)true);
            chain.doFilter(request, response);
        }
        finally {
            CacheLimiter.end();
            DBLimiter.end();
            ThreadLifeCycleManager.end();
        }
    }

    public void init(FilterConfig arg0) {
    }
}

