/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.gray;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.framework.gray.LongIdSet;
import kd.bos.framework.gray.LongIdSetFactory;
import kd.bos.instance.AppGroup;
import kd.bos.instance.Cluster;
import kd.bos.instance.GrayUpdateExtension;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.JSONUtils;

public class GrayStrategy {
    private static final String GRAPSTRATEGY_KEY = "upgrade.graystrategy";
    public static final String USERBITSET_PRE = "userbitset:";
    private static final Log log = LogFactory.getLog(GrayStrategy.class);
    public static final String ALL = "*";
    private static Map<String, Map<String, Set<String>>> userStrategyMaps = new ConcurrentHashMap<String, Map<String, Set<String>>>(2);
    private static Map<String, String> appGrayGroups = new ConcurrentHashMap<String, String>(2);
    private static Map<String, Map<String, String>> allAppGroupCache;

    public static String getAppGroup(String appid) {
        Set<String> userSet;
        boolean isAllApp;
        if (!AppGroup.isGrayUpgrade()) {
            return "defaultGroup";
        }
        RequestContext rc = RequestContext.get();
        if (rc == null || rc.getAccountId() == null || rc.getUserId() == null) {
            return AppGroup.getMainAppGroup((String)appid);
        }
        String userid = rc.getUserId();
        String accountid = rc.getAccountId();
        log.info("GrayStrategy.getAppGroup: accountid=" + accountid + " , uid=" + userid + ",appid=" + appid);
        String allKey = GrayStrategy.getKey(ALL, accountid);
        String appKey = GrayStrategy.getKey(appid, accountid);
        Map<String, Set<String>> accountSetStrategy = userStrategyMaps.get(allKey);
        boolean bl = isAllApp = accountSetStrategy != null;
        if (accountSetStrategy == null) {
            accountSetStrategy = userStrategyMaps.get(appKey);
        }
        if (accountSetStrategy != null && (userSet = accountSetStrategy.get(accountid)) != null && (userSet.contains(userid) || userSet.contains(ALL))) {
            String groupid = isAllApp ? appGrayGroups.get(allKey) : appGrayGroups.get(appKey);
            log.info("GrayStrategy.getAppGroup" + groupid);
            return groupid;
        }
        return AppGroup.getMainAppGroup((String)appid);
    }

    public static Map<String, String> getUserAppGroup(String userId, String accountId) {
        HashMap<String, String> appGroup = new HashMap<String, String>(2);
        String allKey = GrayStrategy.getKey(ALL, accountId);
        if (userStrategyMaps.containsKey(allKey)) {
            Set<String> userSet = userStrategyMaps.get(allKey).get(accountId);
            if (userSet != null && (userSet.contains(userId) || userSet.contains(ALL))) {
                return GrayStrategy.getAllAPPGourp(appGrayGroups.get(allKey));
            }
        } else {
            userStrategyMaps.forEach((appkey, accountSetStrategy) -> {
                Set userSet = (Set)accountSetStrategy.get(accountId);
                if (userSet != null && (userSet.contains(userId) || userSet.contains(ALL))) {
                    String group = appGrayGroups.get(appkey);
                    String appid = appkey.substring(0, appkey.length() - accountId.length() - 1);
                    appGroup.put(appid, group);
                }
            });
        }
        return appGroup;
    }

    public static Map<String, String> getUserAppGroup(String accountId) {
        HashMap<String, String> appGroup = new HashMap<String, String>(2);
        String allKey = GrayStrategy.getKey(ALL, accountId);
        if (userStrategyMaps.containsKey(allKey)) {
            Set<String> userSet = userStrategyMaps.get(allKey).get(accountId);
            if (userSet != null && userSet.size() > 0) {
                return GrayStrategy.getAllAPPGourp(appGrayGroups.get(allKey));
            }
        } else {
            userStrategyMaps.forEach((appkey, accountSetStrategy) -> {
                Set userSet = (Set)accountSetStrategy.get(accountId);
                if (userSet != null && userSet.size() > 0) {
                    String group = appGrayGroups.get(appkey);
                    String appid = appkey.substring(0, appkey.length() - accountId.length() - 1);
                    appGroup.put(appid, group);
                }
            });
        }
        return appGroup;
    }

    private static Map<String, String> getAllAPPGourp(String group) {
        Cluster.RegiestAppids rappids = Cluster.getClusterRegiestAppIds();
        if (!rappids.isFromcache()) {
            allAppGroupCache.clear();
        }
        return allAppGroupCache.computeIfAbsent(group, k -> {
            HashMap m = new HashMap(2);
            rappids.getAppids().forEach(appid -> m.put(appid, group));
            return m;
        });
    }

    public static void initStrategy() {
        String strategyStr = System.getProperty(GRAPSTRATEGY_KEY);
        if (strategyStr != null) {
            try {
                strategyStr = GrayUpdateExtension.getExtension().preHandleGrayStrategy(strategyStr);
                Map _userStrategyMaps = (Map)JSONUtils.cast((String)strategyStr, ConcurrentHashMap.class, (Class[])new Class[]{String.class, ConcurrentHashMap.class});
                userStrategyMaps.clear();
                appGrayGroups.clear();
                _userStrategyMaps.forEach((appids_str, accountidsMap) -> {
                    String[] appids = appids_str.split(",|;");
                    ConcurrentHashMap<String, Set> accountMapSet = new ConcurrentHashMap<String, Set>(2);
                    accountidsMap.forEach((k, v) -> {
                        String[] accountids;
                        HashSet<String> userSet = new HashSet<String>();
                        if (v.size() == 1 && ((String)v.get(0)).startsWith(USERBITSET_PRE)) {
                            try {
                                v = GrayStrategy.getUserSet((String)v.get(0));
                            }
                            catch (Exception e) {
                                log.error("GrayStrategy parse strategy error," + v, (Throwable)e);
                            }
                        }
                        userSet.addAll((Collection<String>)v);
                        for (String accountid : accountids = k.split(",|;")) {
                            accountMapSet.put(accountid, userSet);
                        }
                    });
                    for (String appidPair : appids) {
                        String[] appPair = appidPair.split(":");
                        String appid = appPair[0];
                        String appGroup = appPair[1];
                        accountMapSet.forEach((accountid, userSet) -> {
                            String key = GrayStrategy.getKey(appid, accountid);
                            appGrayGroups.put(key, appGroup);
                            userStrategyMaps.put(key, accountMapSet);
                        });
                    }
                });
            }
            catch (Exception e) {
                log.error("GrayStrategy parse strategy error,", (Throwable)e);
            }
        }
    }

    private static List<String> getUserSet(String string) throws IOException {
        ArrayList<String> userlist = new ArrayList<String>(2);
        string = string.substring(USERBITSET_PRE.length());
        LongIdSet result = LongIdSetFactory.deSeriablize(string);
        Set<Long> lset = result.getAll();
        lset.forEach(lv -> userlist.add(String.valueOf(lv)));
        return userlist;
    }

    private static String getKey(String appid, String accountid) {
        return appid + "_" + accountid;
    }

    static {
        GrayStrategy.initStrategy();
        ConfigurationUtil.observeChange((String)GRAPSTRATEGY_KEY, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                GrayStrategy.initStrategy();
            }
        });
        allAppGroupCache = new ConcurrentHashMap<String, Map<String, String>>(2);
    }
}

