/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.lifecycle;

import ch.qos.logback.core.spi.AyncAppenderImpl;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.OperationContextCreator;
import kd.bos.framework.lifecycle.Service;
import kd.bos.framework.lifecycle.ServiceItem;
import kd.bos.framework.lifecycle.SysServiceLayerManager;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metric.MetricSystem;
import kd.bos.util.LimiterUtil;

public class LifecycleManager {
    private static final Log log = LogFactory.getLog(LifecycleManager.class);
    private static ArrayList<ServiceItem> startedList = new ArrayList();
    private static List<ServiceItem> startingList = Collections.synchronizedList(new LinkedList());
    private static AtomicInteger startThreadIndex = new AtomicInteger();
    private static Service[] sysServices;
    private static AtomicBoolean hasInit;

    public static void start() {
        if (!hasInit.compareAndSet(false, true)) {
            return;
        }
        OperationContextCreator.getOrCreateForBos();
        for (Service service : sysServices = SysServiceLayerManager.loadService()) {
            long beginTime = System.currentTimeMillis();
            try {
                service.start();
                log.info("Service[" + service.getName() + "] start cost time in millis: " + (System.currentTimeMillis() - beginTime));
            }
            catch (Throwable t) {
                log.error("Service " + service.getName() + " start error. cost time in millis: " + (System.currentTimeMillis() - beginTime), t);
            }
        }
        final long begin = System.currentTimeMillis();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                ServiceItem[] items = SysServiceLayerManager.loadServiceItem();
                if (items != null) {
                    for (ServiceItem item : items) {
                        LifecycleManager.startService(item);
                    }
                }
                LifecycleManager.startServiceMonitor(begin);
            }
        }, "Lifecycle-start-service");
        t.setDaemon(true);
        t.start();
        Thread tLimiter = new Thread(() -> {
            Class<?> clz;
            try {
                clz = Class.forName("kd.bos.limiter.scene.SceneManager");
                Method m = clz.getMethod("load", new Class[0]);
                m.invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
                log.error(throwable);
                return;
            }
            if (AyncAppenderImpl.isLogLimit()) {
                try {
                    clz = Class.forName("kd.bos.limiter.Limiter");
                    AyncAppenderImpl.limiterMethod = clz.getMethod("checkAndRecord", String.class);
                    AyncAppenderImpl.logAppenderMeter = MetricSystem.meter((String)"kd.metrics.log.limit.logappender");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            LimiterUtil.setSystemBootFinish();
        });
        tLimiter.setDaemon(true);
        tLimiter.start();
        log.info("\u670d\u52a1\u542f\u52a8\u5b8c\u6210:{}", (Object)Instance.getInstanceId());
    }

    private static void startServiceMonitor(long begin) {
        try {
            int N = 600;
            while (N-- > 0 && !startingList.isEmpty()) {
                Thread.sleep(1000L);
                int n = startingList.size();
                for (int i = 0; i < n; ++i) {
                    ServiceItem item = startingList.get(i);
                    if (!item.getInstance().isStarted()) continue;
                    item.setStarted(true);
                    for (ServiceItem child : item.getChildren()) {
                        LifecycleManager.startService(child);
                    }
                    startedList.add(item);
                    startingList.remove(i);
                    --i;
                    --n;
                }
            }
            long end = System.currentTimeMillis();
            log.info("lifecycle staring service finished, cost " + (end - begin) + "ms");
            if (!startingList.isEmpty()) {
                log.warn("service not start in " + (end - begin) + "ms: " + startingList);
            }
        }
        catch (InterruptedException e) {
            log.warn("Error when start service,", (Throwable)e);
        }
    }

    private static void startService(final ServiceItem item) {
        if (!item.isDisable() && item.isAllInputFinished()) {
            startingList.add(item);
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    long beginTime = System.currentTimeMillis();
                    try {
                        item.getInstance().start();
                        log.info("Starting server " + item.getName() + " by class " + item.getClassName() + ",cost time in millis: " + (System.currentTimeMillis() - beginTime));
                    }
                    catch (Throwable t) {
                        log.error("Error when starting server " + item.getName() + " by class " + item.getClassName() + ",cost time in millis: " + (System.currentTimeMillis() - beginTime), t);
                        startingList.remove(item);
                    }
                }
            }, "Lifecycle-start-service-" + startThreadIndex.getAndIncrement());
            thread.setDaemon(true);
            thread.start();
        }
    }

    public static void stop() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = startedList.size() - 1; i >= 0; --i) {
                    ServiceItem item = (ServiceItem)startedList.get(i);
                    try {
                        log.info("Stopping server " + item.getName() + " ,by class " + item.getClassName());
                        item.getInstance().stop();
                        log.info("Stopped server " + item.getName() + " ,by class " + item.getClassName());
                        continue;
                    }
                    catch (Exception e) {
                        log.error("Error when Stopped server " + item.getName(), (Throwable)e);
                    }
                }
                if (sysServices != null) {
                    for (Service service : sysServices) {
                        try {
                            if (!service.isStarted()) continue;
                            log.info("Stopping service " + service.getName());
                            service.stop();
                            log.info("Stopped service " + service.getName());
                        }
                        catch (Exception t) {
                            log.error("Stop service: " + service.getName() + " occur error.", (Throwable)t);
                        }
                    }
                }
            }
        }, "Lifecycle-stop-service").start();
    }

    static {
        hasInit = new AtomicBoolean(false);
    }
}

