/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.lifecycle;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import kd.bos.config.client.ConfigurationFactory;
import kd.bos.context.OperationContextCreator;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.framework.lifecycle.Service;
import kd.bos.framework.lifecycle.ServiceItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ServiceConfig {
    private static Log log = LogFactory.getLog(ServiceConfig.class);
    private static String configKey = "bos.lifecycle.servicelist";
    private static ServiceItem[] serviceItems = ServiceConfig.parse();

    public static ServiceItem[] getServerItems() {
        return serviceItems;
    }

    private static ServiceItem[] parse() {
        String content = ConfigurationFactory.getGlobalConfiguration().getProperty(configKey);
        if (content == null) {
            return null;
        }
        log.info("bos.lifecycle.servicelist\u914d\u7f6e\u503c\u4e3a\uff1a " + content);
        return ServiceConfig.parseIni(content);
    }

    private static ServiceItem[] parseIni(String content) {
        OperationContextCreator.getOrCreateForBos();
        Properties props = new Properties();
        try {
            props.load(new StringReader(content));
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.configParseException, new Object[]{configKey});
        }
        LinkedHashMap<String, ServiceItem> map = new LinkedHashMap<String, ServiceItem>(props.size());
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (name == null || name.trim().length() == 0 || value == null || value.trim().length() == 0) continue;
            name = name.trim();
            value = value.trim();
            ServiceItem item2 = new ServiceItem(name, value);
            map.put(name, item2);
        }
        ArrayList<ServiceItem> list = new ArrayList<ServiceItem>();
        for (Map.Entry entry : map.entrySet()) {
            ServiceItem item3 = (ServiceItem)entry.getValue();
            if (item3.getDepends() == null) {
                list.add(item3);
                continue;
            }
            boolean found = false;
            for (String depend : item3.getDepends()) {
                ServiceItem parent = (ServiceItem)map.get(depend);
                if (parent == null) continue;
                found = true;
                parent.getChildren().add(item3);
                item3.getParents().add(parent);
            }
            if (found) continue;
            list.add(item3);
        }
        for (Map.Entry entry : map.entrySet()) {
            ServiceItem item = (ServiceItem)entry.getValue();
            for (ServiceItem parent : item.getParents()) {
                ServiceConfig.checkDeadLoop(parent, item);
            }
        }
        ArrayList<ServiceItem> arrayList = new ArrayList<ServiceItem>();
        for (ServiceItem item : list) {
            if (!ServiceConfig.check(item)) continue;
            arrayList.add(item);
        }
        return arrayList.toArray(new ServiceItem[arrayList.size()]);
    }

    private static void checkDeadLoop(ServiceItem parent, ServiceItem item) {
        if (parent.getName().equals(item.getName())) {
            log.error("servicelist dead loop on service " + item.getName() + " ,Execute System.exit(0) starting to exit the service ", (Throwable)new Exception());
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            System.exit(0);
        }
        for (ServiceItem pparent : parent.getParents()) {
            ServiceConfig.checkDeadLoop(pparent, item);
        }
    }

    private static boolean check(ServiceItem item) {
        try {
            Class<?> clazz = Class.forName(item.getClassName());
            Object instance = clazz.newInstance();
            if (instance instanceof Service) {
                for (ServiceItem child : item.getChildren()) {
                    ServiceConfig.check(child);
                }
                item.setInstance((Service)instance);
                return true;
            }
            log.error(item.getClassName() + " doesn't implement Service interface.");
        }
        catch (Exception t) {
            log.error(item.getClassName() + " can't be instanced.", (Throwable)t);
        }
        log.error("Service " + item.getName() + " can't start, all descendants can't start also.");
        for (ServiceItem child : item.getChildren()) {
            ServiceConfig.setDisableCascade(child, item.getName());
        }
        item.setDisable(true);
        return false;
    }

    private static void setDisableCascade(ServiceItem item, String name) {
        item.setDisable(true);
        log.error("Service " + item.getName() + " can't start because it depends on " + name + ", which can't start.");
        for (ServiceItem child : item.getChildren()) {
            ServiceConfig.setDisableCascade(child, name);
        }
    }
}

