/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.preheat;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kd.bos.framework.lifecycle.Service;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationUtil;

public class FullTextPreheatService
implements Service {
    private static Log log = LogFactory.getLog(FullTextPreheatService.class);

    @Override
    public String getName() {
        return FullTextPreheatService.class.getSimpleName();
    }

    @Override
    public void start() {
        try {
            if (Boolean.parseBoolean(System.getProperty("fulltext.enable")) || Boolean.parseBoolean(System.getProperty("fulltext-custsync.enable"))) {
                Class<?> clazz = Class.forName("kd.bos.fulltext.common.ConstantKeys");
                Field field = clazz.getField("FT_SERVER_LIST");
                String regionsKey = (String)field.get(clazz);
                String[] regions = ConfigurationUtil.getString((String)regionsKey, (String)"base").split(",");
                Class<?> clazzSF = Class.forName("kd.bos.fulltext.storage.StorageFactory");
                Method method = clazzSF.getMethod("getStorage", String.class);
                for (String region : regions) {
                    method.invoke(null, region);
                }
                log.info("FullText preheat success.");
            }
        }
        catch (Exception e) {
            log.warn("FullText preheat error:" + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isStarted() {
        return true;
    }
}

