/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.zoowhisper;

import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.framework.zoowhisper.ZooEventifyCenter;
import kd.bos.framework.zoowhisper.superzoo.SuperZooEventifyCenter;
import kd.bos.framework.zoowhisper.zookeeper.ZKZooEventityCenter;

public class ZooEventifyCenterFactory {
    private static ConcurrentHashMap<String, ZooEventifyCenter> outputMap = new ConcurrentHashMap(2);

    public static ZooEventifyCenter getMessageCenter() {
        String mestype = System.getProperty("bos.zoowhisper.type", "zookeeper");
        return ZooEventifyCenterFactory.getMessageCenter(mestype);
    }

    public static ZooEventifyCenter getMessageCenter(String type) {
        return outputMap.computeIfAbsent(type, x -> {
            if ("zookeeper".equals(type)) {
                return new ZKZooEventityCenter();
            }
            if ("redis".equals(type)) {
                return new SuperZooEventifyCenter();
            }
            throw new KDException(BosErrorCode.actionNotFound, new Object[]{"not support type " + type});
        });
    }
}

