/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.zoowhisper.superzoo.m;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.framework.zoowhisper.superzoo.store.StoreManager;

public class LocalWatchListManager {
    private static Map<String, Set<String>> nodeWatchList = new ConcurrentHashMap<String, Set<String>>(2);

    public static synchronized void updateWatchList(String instanceId, String path) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        Set watchList = nodeWatchList.computeIfAbsent(path, k -> new HashSet(2));
        watchList.add(instanceId);
    }

    public static synchronized void removeInstanceWatch(String instanceId, Set<String> paths) {
        paths.forEach(path -> {
            Set<String> watchList;
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            if ((watchList = nodeWatchList.get(path)) != null) {
                watchList.remove(instanceId);
            }
        });
    }

    public static Set<String> getWatchSet(String nodePath) {
        String parent;
        Set<String> s;
        HashSet<String> list = new HashSet<String>(2);
        if (!nodePath.endsWith("/")) {
            nodePath = nodePath + "/";
        }
        if ((s = nodeWatchList.get(parent = StoreManager.getParent(nodePath))) != null && !s.isEmpty()) {
            list.addAll(s);
        }
        return list;
    }

    public static synchronized void reloadWatchList() {
        nodeWatchList = StoreManager.getInstance("").getPathWatchList();
    }
}

