/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.zoowhisper.superzoo.rpc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.LockSupport;
import kd.bos.context.RequestContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.framework.zoowhisper.superzoo.m.ElectorManager;
import kd.bos.framework.zoowhisper.superzoo.rpc.MessageCenterMasterService;
import kd.bos.framework.zoowhisper.superzoo.rpc.MessageCenterWorkService;
import kd.bos.instance.Instance;
import kd.bos.instance.LivingLookout;
import kd.bos.instance.ServiceStatus;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.SafeLogUtils;

public class EndPointInvokeUtil {
    private static Method invokeMethod = null;
    private static Class<?> invokeClazz = null;
    private static LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue(65535);

    public static void notifyMasterNodeChange(String eventInstanceId, String path) {
        EndPointInvokeUtil.notifyMaster(MessageCenterMasterService.class.getName(), "notifyNodeChange", eventInstanceId, path);
    }

    public static void notifyMasterUpdateWatchList(String instanceId, String path) {
        EndPointInvokeUtil.notifyMaster(MessageCenterMasterService.class.getName(), "notifyUpdateWatchList", instanceId, path);
    }

    private static void notifyMaster(final String classname, final String methodname, final String instanceId, final String path) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 3; ++i) {
                    try {
                        EndPointInvokeUtil._notifyMaster(classname, methodname, instanceId, path);
                        break;
                    }
                    catch (Error | Exception e) {
                        SafeLogUtils.error(EndPointInvokeUtil.class, (String)("[superzoo]" + methodname + " notifyMasterChangeEvent error " + i), (Throwable)e);
                        LockSupport.parkNanos(1000000000L);
                        if (i != 2) continue;
                        queue.add(this);
                        continue;
                    }
                }
            }
        };
        if (ServiceStatus.isRpcServiceStarted()) {
            try {
                EndPointInvokeUtil._notifyMaster(classname, methodname, instanceId, path);
            }
            catch (Error | Exception e) {
                queue.add(runner);
            }
        } else {
            queue.add(runner);
        }
    }

    private static void _notifyMaster(String classname, String methodname, String instanceId, String path) throws InvocationTargetException, IllegalAccessException {
        String masterId = ElectorManager.getMasterInstanceId();
        while (masterId == null) {
            LockSupport.parkNanos(100000000L);
            masterId = ElectorManager.getMasterInstanceId();
        }
        if (Instance.getInstanceId().equals(masterId)) {
            if ("notifyNodeChange".equals(methodname)) {
                MessageCenterMasterService.notifyNodeChange(instanceId, path);
            } else if ("notifyUpdateWatchList".equals(methodname)) {
                MessageCenterMasterService.notifyUpdateWatchList(instanceId, path);
            }
        } else {
            EndPointInvokeUtil.remoteInvoke(true, classname, methodname, masterId, instanceId, path);
        }
    }

    public static void notifySlaveNodeChangeEvent(final Set<String> instanceIds, final String nodePath) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                EndPointInvokeUtil._notifySlaveNodeChangeEvent(instanceIds, nodePath);
            }
        };
        if (ServiceStatus.isRpcServiceStarted()) {
            EndPointInvokeUtil._notifySlaveNodeChangeEvent(instanceIds, nodePath);
        } else {
            queue.add(runner);
        }
    }

    private static void _notifySlaveNodeChangeEvent(Set<String> instanceIds, String nodePath) {
        instanceIds.forEach(instanceId -> {
            if (Instance.getInstanceId().equals(instanceId)) {
                MessageCenterWorkService.reciveNodeChangeEvent(nodePath);
            } else {
                try {
                    EndPointInvokeUtil.remoteInvoke(false, MessageCenterWorkService.class.getName(), "reciveNodeChangeEvent", instanceId, nodePath);
                }
                catch (Error | Exception e) {
                    SafeLogUtils.error(EndPointInvokeUtil.class, (String)("[supperzooo]notifySlaveNodeChangeEvent error for " + instanceId), (Throwable)e);
                }
            }
        });
    }

    private static void remoteInvoke(boolean isRequestMaster, final String classname, final String methodName, String removeInstanceId, final Object ... paras) throws InvocationTargetException, IllegalAccessException {
        if (invokeMethod != null) {
            Object ipPort;
            RequestContext rc = RequestContext.getOrCreate();
            if (rc.getTraceId() == null) {
                rc.setTraceId(TraceIdUtil.createTraceIdString());
            }
            if ((ipPort = EndPointInvokeUtil.getRpcIpPort(removeInstanceId)) == null || !LivingLookout.isInstanceAlive((String)removeInstanceId)) {
                if (isRequestMaster) {
                    throw new KDException(BosErrorCode.bOS, new Object[]{removeInstanceId + " instance has`t got ip and port"});
                }
                SafeLogUtils.info(EndPointInvokeUtil.class, (String)("[supperzoo]" + removeInstanceId + " maybe not exits,and not " + methodName));
            } else {
                String ipPortStr = (String)ipPort;
                int lastColonIndex = ipPortStr.lastIndexOf(58);
                final String ip = ipPortStr.substring(0, lastColonIndex);
                final String port = ipPortStr.substring(lastColonIndex + 1);
                Runnable runner = new Runnable(){
                    private int retryCount = 0;

                    @Override
                    public void run() {
                        for (int i = 0; i < 3; ++i) {
                            try {
                                invokeMethod.invoke((Object)invokeClazz, ip, port, classname, methodName, paras);
                                break;
                            }
                            catch (Throwable e) {
                                if (e instanceof InvocationTargetException) {
                                    e = ((InvocationTargetException)e).getTargetException();
                                }
                                SafeLogUtils.error(EndPointInvokeUtil.class, (String)("[superzoo]" + methodName + " remoteInvoke error,retryCount: " + this.retryCount + ", i: " + i), (Throwable)e);
                                LockSupport.parkNanos(1000000000L + 2L * (long)i * 1000000000L);
                                if (i != 2) continue;
                                ++this.retryCount;
                                if (this.retryCount > 7) continue;
                                queue.add(this);
                                continue;
                            }
                        }
                    }
                };
                try {
                    invokeMethod.invoke(invokeClazz, ip, port, classname, methodName, paras);
                }
                catch (Error | Exception e) {
                    queue.add(runner);
                }
            }
        } else {
            SafeLogUtils.info(EndPointInvokeUtil.class, (String)"[superzoo]cant invoke because of invokeMethod is nulll");
        }
    }

    private static Object getRpcIpPort(String removeInstanceid) throws InvocationTargetException, IllegalAccessException {
        return LivingLookout.getRpcIpPort((String)removeInstanceid);
    }

    static {
        try {
            invokeClazz = Class.forName("kd.bos.service.invoke.endpoint.EndPointInvokeServiceHelper");
            for (Method m : invokeClazz.getMethods()) {
                if (!m.getName().equalsIgnoreCase("invoke") || m.getParameterTypes().length != 5) continue;
                invokeMethod = m;
                break;
            }
            ThreadPools.executeOnce("ZooEventifyNotifyAsync", () -> {
                while (!ServiceStatus.isRpcServiceStarted()) {
                    LockSupport.parkNanos(1000000000L);
                }
                while (queue != null) {
                    Runnable runner = queue.poll();
                    if (runner != null) {
                        runner.run();
                        continue;
                    }
                    LockSupport.parkNanos(1000000000L);
                }
                SafeLogUtils.info(MessageCenterMasterService.class, (String)"[superzoo]ZooEventifyNotifyAsync finish");
            });
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            SafeLogUtils.error(MessageCenterMasterService.class, (String)"[superzoo]cinit EndPointInvokeUtil error", (Throwable)e);
        }
    }
}

