/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.zoowhisper.superzoo.store;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.framework.zoowhisper.superzoo.store.StoreManager;
import kd.bos.instance.Instance;
import kd.bos.util.SafeLogUtils;

public class RedisStoreManager
implements StoreManager {
    private static final String region = System.getProperty("zoowhisper.debug.store.Region", System.getProperty("mq.debug.queue.tag", ""));
    private static final String NULLSTR = "#nullstring#";
    public static final String REDISMESSAGEKEY = region + "zooeventify_" + Instance.getClusterName() + "_data_map";
    public static final String REDISMESSAGEKEY_Ephemeral = RedisStoreManager.getEphemeralPathsKey(Instance.getInstanceId());
    private static final String WATHLISTKEY = region + "zooeventify_" + Instance.getClusterName() + "_WatchInstances";
    private static final String CLUSTERINSTANCESKEY = region + "zooeventify_" + Instance.getClusterName() + "_clusterInstances";
    private static final int DEFAULTKEYTIMEOUT = Integer.getInteger("bos.zoowhisper.redis.timeout", 6912000);
    private static final String STOREREGION = "supperzoo";
    final DistributeSessionlessCache distributeSessionlessCache;
    private static Map<String, StoreManager> instances = new ConcurrentHashMap<String, StoreManager>(2);

    public RedisStoreManager(String region) {
        String storekey = CacheConfigKeys.getSessionlessConfigKey((String)STOREREGION);
        if (System.getProperty(storekey) == null) {
            System.setProperty(storekey, System.getProperty(CacheConfigKeys.getSessionableConfigKey()));
        }
        this.distributeSessionlessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(STOREREGION);
    }

    public static StoreManager get(String region) {
        return instances.computeIfAbsent(region, k -> new RedisStoreManager(region));
    }

    @Override
    public Map<String, String> getChildren(String path) {
        return this.getChildrenForStoreKey(REDISMESSAGEKEY, path);
    }

    @Override
    public Map<String, String> getChildren(String clusterName, String path) {
        String storeKey = region + "zooeventify_" + clusterName + "_data_map";
        return this.getChildrenForStoreKey(storeKey, path);
    }

    private Map<String, String> getChildrenForStoreKey(String storekey, String path) {
        HashMap<String, String> rmap = new HashMap<String, String>(2);
        List keys = this.distributeSessionlessCache.getKeys(storekey);
        List<String> suitKeys = keys.stream().filter(k -> k.startsWith(path) && k.substring(path.length()).indexOf("/") < 0).collect(Collectors.toList());
        if (suitKeys.isEmpty()) {
            return rmap;
        }
        List values = this.distributeSessionlessCache.get(storekey, suitKeys.toArray(new String[0]));
        for (int i = 0; i < suitKeys.size(); ++i) {
            String value = values.get(i) == null ? NULLSTR : (String)values.get(i);
            rmap.put(((String)suitKeys.get(i)).substring(path.length()), value);
        }
        return rmap;
    }

    @Override
    public boolean existsNode(String fullPath) {
        String path = (String)this.distributeSessionlessCache.get(REDISMESSAGEKEY, fullPath);
        return path != null;
    }

    @Override
    public List<String> getChildrenNames(String path) {
        List keys = this.distributeSessionlessCache.getKeys(REDISMESSAGEKEY);
        List<String> suitKeys = keys.stream().filter(k -> k.startsWith(path) && k.substring(path.length()).indexOf("/") < 0).map(k -> k.substring(path.length())).collect(Collectors.toList());
        return suitKeys;
    }

    @Override
    public void saveNode(String path, String nodeName, String nodeValue, boolean isEphemeral) {
        path = path + nodeName;
        if (isEphemeral) {
            this.distributeSessionlessCache.addToSet(REDISMESSAGEKEY_Ephemeral, new String[]{path}, DEFAULTKEYTIMEOUT, TimeUnit.SECONDS);
        }
        this.distributeSessionlessCache.put(REDISMESSAGEKEY, path, nodeValue == null ? NULLSTR : nodeValue, DEFAULTKEYTIMEOUT, TimeUnit.SECONDS);
    }

    @Override
    public Set<String> getEphemeralPaths(String instanceId) {
        HashSet<String> s = new HashSet<String>(2);
        String[] paths = this.distributeSessionlessCache.getSetValues(RedisStoreManager.getEphemeralPathsKey(instanceId));
        if (paths != null) {
            for (String path : paths) {
                s.add(path);
            }
        }
        return s;
    }

    @Override
    public void removeEphemeralPaths(String instanceId) {
        this.distributeSessionlessCache.remove(RedisStoreManager.getEphemeralPathsKey(instanceId));
    }

    private static String getEphemeralPathsKey(String instanceId) {
        return region + "zooeventify_" + Instance.getClusterName() + "_data_map_Ephemeral" + instanceId;
    }

    @Override
    public void deleteNode(String path, String nodeName) {
        path = path + nodeName;
        this.distributeSessionlessCache.remove(REDISMESSAGEKEY, path);
    }

    @Override
    public void deleteNodeByInstanceId(String instanceId) {
        List keys = this.distributeSessionlessCache.getKeys(REDISMESSAGEKEY);
        List<String> suitKeys = keys.stream().filter(k -> k.indexOf(instanceId) > 0).collect(Collectors.toList());
        if (!suitKeys.isEmpty()) {
            this.distributeSessionlessCache.remove(REDISMESSAGEKEY, suitKeys.toArray(new String[0]));
            SafeLogUtils.info(RedisStoreManager.class, (String)("[superzoo]watchException remove instance data:" + instanceId));
        }
    }

    @Override
    public void deleteDirectory(String path) {
        List keys = this.distributeSessionlessCache.getKeys(REDISMESSAGEKEY);
        List<String> suitKeys = keys.stream().filter(k -> k.startsWith(path)).collect(Collectors.toList());
        if (!suitKeys.isEmpty()) {
            this.distributeSessionlessCache.remove(REDISMESSAGEKEY, suitKeys.toArray(new String[0]));
        }
    }

    @Override
    public String getAddress() {
        return "redis@" + System.getProperty(STOREREGION);
    }

    @Override
    public void deleteNode(String fullPath) {
        this.distributeSessionlessCache.remove(REDISMESSAGEKEY, fullPath);
    }

    @Override
    public String getNodeValue(String nodeFullPathForQuery) {
        String retValue = (String)this.distributeSessionlessCache.get(REDISMESSAGEKEY, nodeFullPathForQuery);
        if (retValue == null) {
            retValue = NULLSTR;
        }
        return retValue;
    }

    @Override
    public void saveNodeWatchPath(String eventInstanceid, String path) {
        this.distributeSessionlessCache.addToSet(WATHLISTKEY, new String[]{eventInstanceid + "#@#" + path}, DEFAULTKEYTIMEOUT, TimeUnit.SECONDS);
    }

    @Override
    public void removeNodeWathPath(String eventInstanceid, String[] paths) {
        String[] realPaths;
        if (paths == null) {
            return;
        }
        String[] setValues = this.distributeSessionlessCache.getSetValues(WATHLISTKEY);
        if (setValues != null && (realPaths = Arrays.stream(setValues).filter(key -> key.startsWith(eventInstanceid + "#@#")).collect(Collectors.toList()).toArray(new String[0])).length > 0) {
            this.distributeSessionlessCache.removeSetValues(WATHLISTKEY, realPaths);
        }
    }

    @Override
    public Map<String, Set<String>> getPathWatchList() {
        ConcurrentHashMap<String, Set<String>> map = new ConcurrentHashMap<String, Set<String>>(2);
        String[] setValues = this.distributeSessionlessCache.getSetValues(WATHLISTKEY);
        if (setValues != null) {
            for (String item : setValues) {
                int idx = item.indexOf("#@#");
                if (idx <= 0) continue;
                String instanceId = item.substring(0, idx);
                String path = item.substring(idx + "#@#".length());
                Set pathSet = map.computeIfAbsent(path, k -> new HashSet(2));
                pathSet.add(instanceId);
            }
        }
        return map;
    }

    @Override
    public void saddInstance(String instanceid) {
        this.distributeSessionlessCache.addToSet(CLUSTERINSTANCESKEY, new String[]{instanceid}, DEFAULTKEYTIMEOUT);
    }

    @Override
    public void sremoveInstance(String instanceid) {
        this.distributeSessionlessCache.removeSetValues(CLUSTERINSTANCESKEY, new String[]{instanceid});
    }

    @Override
    public String[] reloadInstances() {
        return this.distributeSessionlessCache.getSetValues(CLUSTERINSTANCESKEY);
    }
}

