/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.zoowhisper.zookeeper;

import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;

public class Runner
implements Runnable {
    private String parentPath;
    private String path;
    private String zookeeper;
    private String info;
    private static Log logger = LogFactory.getLog(Runner.class);
    private final Charset charset = Charset.forName("UTF-8");

    public Runner(String parentPath, String path, String zookeeper, String info) {
        this.parentPath = parentPath;
        this.path = path;
        this.zookeeper = zookeeper;
        this.info = info;
    }

    @Override
    public void run() {
        try {
            CuratorFramework client = ZKFactory.getZKClient((String)this.zookeeper);
            this.createPath(client, new File(this.parentPath));
            Stat exists = (Stat)client.checkExists().forPath(this.path);
            if (exists == null) {
                client.getZookeeperClient().getZooKeeper().create(this.path, this.info.getBytes(this.charset), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            }
        }
        catch (Exception e) {
            logger.error("Error when register Node:" + this.info, (Throwable)e);
        }
    }

    private void createPath(CuratorFramework client, File file) {
        if (file == null) {
            return;
        }
        try {
            String path = file.getPath().replaceAll("\\\\", "/");
            Stat exists = (Stat)client.checkExists().forPath(path);
            if (exists == null) {
                this.createPath(client, file.getParentFile());
                client.getZookeeperClient().getZooKeeper().create(path, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        catch (Exception e) {
            logger.error("create zookeeper path exception", (Throwable)e);
        }
    }
}

