/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login;

import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class CacheLoginData {
    private static final String CACHE_REGION = "LOGIN_DATA";
    public static final String FORMAT = "%s_%s_%s_%s";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("LOGIN_DATA", new DistributeCacheHAPolicy(true, true));
    private static String YZJ_QR_TOKEN = "Yzj_QR";
    private static String YZJPCD_QR_TOKEN = "YzjP_QR";
    private static String YZJ_USER_TENANTS = "Yzj_UserTenantList";
    private static String YZJ_EKEY = "Yzj_EKey";
    private static String YZJ_IMSDK_KEYDATA = "Yzj_User_Imsdk_KeyData";
    private static String YZJ_IMSDK_TICKET = "Yzj_User_Imsdk_Ticket";
    private static String YZJ_IMSDK_GROUP = "Yzj_Imsdk_Group";
    private static String AI_LOGIN_TOKEN = "AI_LOGIN_TOKEN";
    public static final String CAS_CACHE = "cas_cache_";
    private static String AI_LOGIN_SESSION = "AI_LOGIN_SESSION";
    private static String VOICE_SAYING_FLAG = "VOICE_SAYING_FLAG";
    private static String VERIFY_CODE = "VERIFY_CODE";
    private static Log logger = LogFactory.getLog(CacheLoginData.class);

    public static String getType4VerifyCode() {
        return VERIFY_CODE;
    }

    public static String getType4YzjQR(String token) {
        return YZJ_QR_TOKEN + "_" + token;
    }

    public static String getType4YzjpcdQR() {
        return YZJPCD_QR_TOKEN + "_";
    }

    public static String getCASCachePreFix() {
        return "cas_cache__";
    }

    public static String getType4AILogin(String token) {
        return AI_LOGIN_TOKEN + "_" + token;
    }

    public static String getType4AILoginSession(String token) {
        return AI_LOGIN_SESSION + "_" + token;
    }

    public static String getType4VoiceSayingFlag() {
        return VOICE_SAYING_FLAG + "_";
    }

    public static String getType4YzjEKey(String tenantId) {
        return tenantId + "_" + YZJ_EKEY;
    }

    public static String getType4YzjUserTenantList(String userId) {
        return YZJ_USER_TENANTS + "_" + userId;
    }

    public static String getType4UserImsdkKeyData(String tenantId, String userId) {
        return tenantId + "_" + YZJ_IMSDK_KEYDATA + "_" + userId;
    }

    public static String getType4UserImsdkTicket(String tenantId, String userId) {
        return tenantId + "_" + YZJ_IMSDK_TICKET + "_" + userId;
    }

    public static String getType4ImsdkGroup(String tenantId, String userId, String openIds, String businessKey, Boolean assignGroupOwner) {
        if (assignGroupOwner.booleanValue() && StringUtils.isNotEmpty((String)businessKey)) {
            return String.format(FORMAT, tenantId, YZJ_IMSDK_GROUP, openIds, businessKey);
        }
        if (!assignGroupOwner.booleanValue() && StringUtils.isNotEmpty((String)businessKey)) {
            return String.format("%s_%s_%s", tenantId, YZJ_IMSDK_GROUP, businessKey);
        }
        if (!assignGroupOwner.booleanValue() && StringUtils.isEmpty((String)businessKey)) {
            return String.format(FORMAT, tenantId, YZJ_IMSDK_GROUP, userId, openIds);
        }
        if (assignGroupOwner.booleanValue() && StringUtils.isEmpty((String)businessKey)) {
            return String.format(FORMAT, tenantId, YZJ_IMSDK_GROUP, userId, openIds);
        }
        return String.format("%s_%s_%s", tenantId, YZJ_IMSDK_GROUP, openIds);
    }

    private static String getKeyPrefix(String type) {
        return type + "-";
    }

    private static String conbineKey(String type, String key) {
        return CacheLoginData.getKeyPrefix(type) + key;
    }

    private static String[] conbineKeys(String type, String[] keys) {
        String[] ret = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            ret[i] = CacheLoginData.conbineKey(type, keys[i]);
        }
        return ret;
    }

    private static Map<String, String> conbineKeys(String type, Map<String, String> map) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static Map<String, String> getCache(String type) {
        Map mpEkey = cache.getAll(type);
        return mpEkey;
    }

    public static String getAttribute(String type, String key) {
        String value = (String)cache.get(CacheLoginData.conbineKey(type, key));
        return value;
    }

    public static void setAttribute(String type, String key, String value) {
        cache.put(CacheLoginData.conbineKey(type, key), (Object)value);
    }

    public static void setAttribute(String type, String key, String value, int timeout) {
        cache.put(CacheLoginData.conbineKey(type, key), (Object)value, timeout);
    }

    public static void setAttributes(String type, Map<String, String> map) {
        cache.put(type, map);
    }

    public static void expire(String type, String key, int timeout) {
        cache.expireAfter(CacheLoginData.conbineKey(type, key), timeout);
    }

    public static void remove(String type) {
        cache.remove(type);
    }

    private static String getType4VoiceToken(String token) {
        return AI_LOGIN_TOKEN + "_voice_" + token;
    }

    public static void addVoiceToken(String token) {
        String key = "login.voice.token.timeout";
        String value = System.getProperty(key);
        if (value == null || value.isEmpty()) {
            value = "120";
            logger.info("Voice login's " + String.format("%s is not configured at zookeeper.", key));
        }
        int timeout = Integer.parseInt(value);
        cache.put(CacheLoginData.getType4VoiceToken(token), (Object)token, timeout);
    }

    public static boolean isEffectiveToken(String token) {
        return cache.contains(CacheLoginData.getType4VoiceToken(token));
    }

    public static void remove(String type, String key) {
        cache.remove(CacheLoginData.conbineKey(type, key));
    }

    public static void setAttributes(String type, String key, Map<String, String> map, int timeOut) {
        cache.put(CacheLoginData.conbineKey(type, key), map, timeOut);
    }

    public static Map<String, String> getAttributes(String type, String key) {
        Map map = cache.getAll(CacheLoginData.conbineKey(type, key));
        return map;
    }
}

