/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.msgjet.channel.jms;

import java.lang.reflect.Method;
import java.nio.charset.Charset;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.msgjet.channel.Channel;
import kd.bos.msgjet.channel.SubPubHeartbeat;
import kd.bos.util.StringUtils;

public class JMSChannel
implements Channel {
    private static final Log log = LogFactory.getLog(JMSChannel.class);
    public static final String MSG_JET_TOPIC_SUFFIX = "_msg_jet_topic";
    private static Channel instance = new JMSChannel();
    private static Session consumerSession;

    public static Channel getInstance() {
        return instance;
    }

    @Override
    public void send(String msg) {
        if (StringUtils.isEmpty((String)msg)) {
            return;
        }
        Session session = null;
        try {
            session = this.getSession();
            MessageProducer producer = session.createProducer((Destination)this.getTopic(session));
            BytesMessage bytesMessage = session.createBytesMessage();
            bytesMessage.writeBytes(msg.getBytes(Charset.forName("UTF-8")));
            producer.send((Message)bytesMessage);
        }
        catch (JMSException e) {
            log.error("jms send msg error. msg: " + msg, (Throwable)e);
            throw new KDException(BosErrorCode.jmsmqException, "JMS: producer send msg error", (Throwable)e);
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (JMSException e) {
                log.error((Throwable)e);
            }
        }
    }

    @Override
    public void registerCustomer() {
        consumerSession = this.getSession();
        try {
            MessageConsumer consumer = consumerSession.createConsumer((Destination)this.getTopic(consumerSession));
            consumer.setMessageListener(message -> {
                if (message instanceof BytesMessage) {
                    try {
                        String revMsg = new String(this.toBytes((BytesMessage)message), Charset.forName("UTF-8"));
                        if (SubPubHeartbeat.isHeartbeat(revMsg)) {
                            return;
                        }
                        reciver.recive(revMsg);
                    }
                    catch (JMSException e) {
                        throw new KDException(BosErrorCode.jmsmqException, "JMS: cover bytes error", (Throwable)e);
                    }
                }
            });
        }
        catch (JMSException e) {
            throw new KDException(BosErrorCode.jmsmqException, "JMS: create topic error", (Throwable)e);
        }
    }

    private Topic getTopic(Session session) throws JMSException {
        return session.createTopic(Instance.getClusterName() + MSG_JET_TOPIC_SUFFIX);
    }

    private byte[] toBytes(BytesMessage message) throws JMSException {
        byte[] bytes = new byte[(int)message.getBodyLength()];
        message.readBytes(bytes);
        return bytes;
    }

    private Session getSession() {
        try {
            Class<?> clz = Class.forName("kd.bos.mq.WebsocketUtils");
            Method m = clz.getMethod("getJMSSession", new Class[0]);
            return (Session)m.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.jmsmqException, "JMS: get session error", (Throwable)e);
        }
    }
}

