/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.msgjet.channel.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.nio.charset.Charset;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.msgjet.MsgReceiveListener;
import kd.bos.msgjet.channel.SubPubHeartbeat;

public class MsgJetConsumer
extends DefaultConsumer {
    private static final Log log = LogFactory.getLog(MsgJetConsumer.class);
    private MsgReceiveListener listener;

    public MsgJetConsumer(Channel channel) {
        super(channel);
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        String revMsg = new String(body, Charset.forName("UTF-8"));
        if (SubPubHeartbeat.isHeartbeat(revMsg)) {
            return;
        }
        try {
            this.listener.recive(revMsg);
        }
        catch (Exception e) {
            log.error("MsgJetConsumer consum message error: ", (Throwable)e);
        }
        super.handleDelivery(consumerTag, envelope, properties, body);
    }

    public void setReciver(MsgReceiveListener reciver) {
        this.listener = reciver;
    }
}

