/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.msgjet.websocket.jetty;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kd.bos.context.OperationContextCreator;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.msgjet.websocket.TokenUtils;
import kd.bos.msgjet.websocket.WebSocketListener;
import kd.bos.msgjet.websocket.WebSocketObject;
import kd.bos.msgjet.websocket.jetty.JettyParamManager;
import org.eclipse.jetty.websocket.api.CloseStatus;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

@WebSocket
public class JettyMsgWebSocket {
    private static Map<String, Set<Session>> map = new ConcurrentHashMap<String, Set<Session>>();
    private static Map<Session, String> sessionIdentifyMap = new ConcurrentHashMap<Session, String>();
    private static ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static ReentrantReadWriteLock.ReadLock rlock = lock.readLock();
    private static ReentrantReadWriteLock.WriteLock wlock = lock.writeLock();
    private static Log log = LogFactory.getLog(JettyMsgWebSocket.class);
    private Map<String, WebSocketListener> listeners = new ConcurrentHashMap<String, WebSocketListener>();

    private static Set<Session> getIdentifySet(String id) {
        Set _set = map.computeIfAbsent(id, k -> new HashSet());
        return _set;
    }

    private static void removeSession(Session session) {
        String ident = sessionIdentifyMap.remove(session);
        if (ident != null) {
            Set<Session> sessions = JettyMsgWebSocket.getIdentifySet(ident);
            sessions.remove(session);
            if (sessions.isEmpty()) {
                map.remove(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMessage(String identifyId, String msg) {
        OperationContextCreator.getOrCreateForBos();
        boolean isOutputWebsocketLog = Boolean.getBoolean("websocket.log.enable");
        if (isOutputWebsocketLog) {
            log.info("sendBrowerMsg from websocket:" + identifyId + ",message:" + msg);
        }
        Set<Session> s = identifyId == null ? sessionIdentifyMap.keySet() : JettyMsgWebSocket.getIdentifySet(identifyId);
        HashSet removeSet = new HashSet();
        HashSet sendSet = new HashSet();
        String logmsg = "sendBrowerMsg to brower:" + identifyId + ",message:" + msg;
        try {
            rlock.lock();
            if (s.isEmpty() && isOutputWebsocketLog) {
                log.warn("hasn`t session:" + logmsg);
            }
            s.forEach(session -> {
                if (session.isOpen()) {
                    sendSet.add(session);
                } else {
                    removeSet.add(session);
                    if (isOutputWebsocketLog) {
                        log.warn("session closed:" + logmsg);
                    }
                }
            });
        }
        finally {
            rlock.unlock();
        }
        try {
            sendSet.forEach(session -> {
                session.getRemote().sendStringByFuture(msg);
                if (isOutputWebsocketLog) {
                    log.info(logmsg);
                }
            });
        }
        catch (Exception e) {
            log.error("session closed:" + logmsg, (Throwable)e);
        }
        if (!removeSet.isEmpty()) {
            try {
                wlock.lock();
                removeSet.forEach(session -> JettyMsgWebSocket.removeSession(session));
            }
            finally {
                wlock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnWebSocketConnect
    public void onConnect(Session session) {
        if (session.isOpen()) {
            String token = JettyParamManager.getToken(session);
            if (!this.check(session, token)) {
                return;
            }
            final String ident = JettyParamManager.getParamterFromQueryStr(session.getUpgradeRequest(), "identifytype");
            String paramListener = JettyParamManager.getParamterFromQueryStr(session.getUpgradeRequest(), "listenerType");
            if (Boolean.getBoolean("websocket.log.enable")) {
                log.info("OnConnected! identifytype:" + ident);
            }
            try {
                wlock.lock();
                if (ident != null) {
                    JettyMsgWebSocket.getIdentifySet(ident).add(session);
                    sessionIdentifyMap.put(session, ident);
                }
            }
            finally {
                wlock.unlock();
            }
            if (ident != null) {
                final String _t = token;
                this.listeners.forEach((k, v) -> {
                    try {
                        if (this.isContain(v.getType(), paramListener)) {
                            v.onConnect(new WebSocketObject(){

                                @Override
                                public String getSessionId() {
                                    return _t;
                                }

                                @Override
                                public String getIdentifyType() {
                                    return ident;
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                    }
                });
            }
        }
    }

    @OnWebSocketMessage
    public void onMessage(Session session, String msg) {
        final String token = JettyParamManager.getToken(session);
        if (!this.check(session, token)) {
            return;
        }
        final String ident = JettyParamManager.getParamterFromQueryStr(session.getUpgradeRequest(), "identifytype");
        String paramListener = JettyParamManager.getParamterFromQueryStr(session.getUpgradeRequest(), "listenerType");
        if (Boolean.getBoolean("websocket.log.enable")) {
            log.info("receive msg\uff1a" + msg + ", identifytype: " + ident);
        }
        this.listeners.forEach((k, v) -> {
            try {
                if (this.isContain(v.getType(), paramListener)) {
                    v.onMessage(new WebSocketObject(){

                        @Override
                        public String getSessionId() {
                            return token;
                        }

                        @Override
                        public String getIdentifyType() {
                            return ident;
                        }
                    }, msg);
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnWebSocketClose
    public void onWebSocketBinary(Session session, int a, String s) {
        if (!Boolean.getBoolean("msgjet.connection.close.nolock")) {
            try {
                wlock.lock();
                JettyMsgWebSocket.removeSession(session);
            }
            finally {
                wlock.unlock();
            }
        }
        UpgradeRequest request = session.getUpgradeRequest();
        String tenantKey = JettyParamManager.getParamterFromQueryStr(request, "tenantsessionkey");
        String wstk = JettyParamManager.getFromCookie(session.getUpgradeRequest(), tenantKey);
        if (wstk == null) {
            wstk = JettyParamManager.getParamterFromQueryStr(request, "token");
        }
        final String ident = JettyParamManager.getParamterFromQueryStr(request, "identifytype");
        String paramListener = JettyParamManager.getParamterFromQueryStr(session.getUpgradeRequest(), "listenerType");
        if (Boolean.getBoolean("websocket.log.enable")) {
            log.info("websocket close, identifytype: " + ident + ",statusCode: " + a + ",reason: " + s);
        }
        if (wstk != null && ident != null) {
            final String token = wstk;
            this.listeners.forEach((k, v) -> {
                try {
                    if (this.isContain(v.getType(), paramListener)) {
                        v.onClose(new WebSocketObject(){

                            @Override
                            public String getSessionId() {
                                return token;
                            }

                            @Override
                            public String getIdentifyType() {
                                return ident;
                            }
                        });
                    }
                }
                catch (Exception e) {
                    OperationContextCreator.getOrCreateForBos();
                    log.error((Throwable)e);
                }
            });
        }
    }

    @OnWebSocketError
    public void onWebSocketError(Session session, Throwable e) {
        if (session.isOpen()) {
            String token = JettyParamManager.getToken(session);
            if (!this.check(session, token)) {
                return;
            }
            String ident = JettyParamManager.getParamterFromQueryStr(session.getUpgradeRequest(), "identifytype");
            if (Boolean.getBoolean("websocket.log.enable")) {
                log.warn("onWebSocketError! identifytype:" + ident, e);
            }
        }
    }

    private boolean isContain(String type, String paramListener) {
        return paramListener == null && type == null || paramListener != null && paramListener.equals(type);
    }

    private boolean check(Session session, String token) {
        boolean isValite = TokenUtils.checkToken(token);
        OperationContextCreator.getOrCreateForBos();
        if (!isValite) {
            if (Boolean.getBoolean("websocket.log.enable")) {
                log.error("Unauthed session " + token + " in cluster " + Instance.getClusterName());
            }
            session.close(new CloseStatus(4001, "not Authed session "));
        }
        return isValite;
    }

    public void registerListener(WebSocketListener listener) {
        this.listeners.put(listener.getClass().getName(), listener);
    }
}

