/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.msgjet.websocket.jetty;

import java.net.HttpCookie;
import java.util.List;
import org.eclipse.jetty.websocket.api.CloseStatus;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeRequest;

public class JettyParamManager {
    public static final String TENANTSESSIONKEY = "tenantsessionkey";

    protected static String getToken(Session session) {
        UpgradeRequest request = session.getUpgradeRequest();
        String tenantKey = JettyParamManager.getParamterFromQueryStr(request, TENANTSESSIONKEY);
        String token = null;
        if (tenantKey != null) {
            String wstk = JettyParamManager.getFromCookie(request, tenantKey);
            if (wstk != null) {
                token = wstk;
            } else {
                token = JettyParamManager.getParamterFromQueryStr(request, "token");
                if (token == null) {
                    session.close(new CloseStatus(4001, "Not Authed cannt got tenant session "));
                    return null;
                }
            }
        } else {
            token = JettyParamManager.getParamterFromQueryStr(request, "token");
        }
        return token;
    }

    static String getParamterFromQueryStr(UpgradeRequest upgradeRequest, String key) {
        List tokenLs = (List)upgradeRequest.getParameterMap().get(key);
        if (tokenLs != null) {
            return (String)tokenLs.get(0);
        }
        return null;
    }

    static String getFromCookie(UpgradeRequest req, String wstkid) {
        if (wstkid == null) {
            return null;
        }
        List cookies = req.getCookies();
        if (cookies != null && cookies.size() > 0) {
            for (HttpCookie cookie : cookies) {
                if (!cookie.getName().equals(wstkid)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }
}

