/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.resource.balancer;

import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

public class Configs {
    public static final String MULTI_TENANT_RESOURCE_BALANCE_ENABLE = "bos.multiTenant.resource.balance.enable";
    private static boolean allEnable = Boolean.parseBoolean(System.getProperty("bos.multiTenant.resource.balance.enable", "false"));
    public static final String KDTX_RESOURCE_BALANCE_ENABLE = "kdtx.resource.balance.enable";
    public static final String WEB_RESOURCE_BALANCE_ENABLE = "web.resource.balance.enable";
    public static final String RPC_RESOURCE_BALANCE_ENABLE = "rpc.resource.balance.enable";
    public static final String SCHEDULE_RESOURCE_BALANCE_ENABLE = "schedule.resource.balance.enable";
    public static final String PIGEON_RESOURCE_BALANCE_ENABLE = "pigeon.resource.balance.enable";
    public static final String OPENAPI_RESOURCE_BALANCE_ENABLE = "openapi.resource.balance.enable";
    public static final String WORKFLOW_RESOURCE_BALANCE_ENABLE = "workflow.resource.balance.enable";
    public static final String SUFFIX_RESOURCE_BALANCE_ENABLE = ".resource.balance.enable";
    public static final String LOAD_BALANCE_STRATEGY_KEY = "bos.resource.balance.strategy";
    public static final String RESOURCE_OVER_BORROW_THRESHOLD = "bos.resource.overborrowthreshold.percent";
    public static final String OVERFLOW_POOL_MAX_THREAD_KEY = "bos.resource.overflowpool.maxthread";
    public static final String RESOURCE_OVERFLOW_THRESHOLD = "bos.resource.overflowpool.threshold.percent";
    public static final String RESOURCE_MAX_QUEUE_SIZE = "bos.resource.threadpool.queuesize";
    public static final String TENANT_MIN_PROPORTION = "bos.resource.tenant.minproportion";
    public static final String RESOURCE_THREAD_TIMEOUT = "bos.resource.threadpool.timeout";
    public static final String RESOURCE_THREAD_TIMEOUT_RECYCLE_PERCENT = "bos.resource.threadpool.recycle.percent";
    public static final String TENANT_CONFIG_DAO = "bos.resource.tenantconfig.datasource";
    public static final String THREAD_POOL_CONFIG = "bos.resource.threadpool.config";
    public static final String METRICS_REPORTER_ENABLE = "bos.resource.metrics.reporter.enable";
    public static final String METRICS_REPORTER_INTERVAL = "bos.resource.metrics.reporter.interval";
    public static final String FIXED_VIRTUAL_TENANT_ACCOUNT = "Fixed_Virtual_Tenant_101010";
    public static final String FIXED_VIRTUAL_TENANT_PROPORTION = "bos.resource.fixedvirtualtenant.proportion";
    public static final String EVENT_REPORT_INTERVAL = "bos.resource.eventdata.reporter.interval";
    public static final String OVERBORROW_EVENT_REPORT_THREAD_THRESHOLD = "overborrow.eventdata.threadthreshold";

    private static boolean isMultiTenantResourceBalanceEnable() {
        return allEnable;
    }

    public static boolean isKdtxResourceBalanceEnable() {
        return Configs.isMultiTenantResourceBalanceEnable() && Boolean.parseBoolean(System.getProperty(KDTX_RESOURCE_BALANCE_ENABLE, "true"));
    }

    public static boolean isWebResourceBalanceEnable() {
        return Configs.isMultiTenantResourceBalanceEnable() && Boolean.parseBoolean(System.getProperty(WEB_RESOURCE_BALANCE_ENABLE, "true"));
    }

    public static boolean isRpcResourceBalanceEnable() {
        return Configs.isMultiTenantResourceBalanceEnable() && Boolean.parseBoolean(System.getProperty(RPC_RESOURCE_BALANCE_ENABLE, "true"));
    }

    public static boolean isScheduleResourceBalanceEnable() {
        return Configs.isMultiTenantResourceBalanceEnable() && Boolean.parseBoolean(System.getProperty(SCHEDULE_RESOURCE_BALANCE_ENABLE, "true"));
    }

    public static boolean isPigeonResourceBalanceEnable() {
        return Configs.isMultiTenantResourceBalanceEnable() && Boolean.parseBoolean(System.getProperty(PIGEON_RESOURCE_BALANCE_ENABLE, "true"));
    }

    public static boolean isOpenapiResourceBalanceEnable() {
        return Configs.isMultiTenantResourceBalanceEnable() && Boolean.parseBoolean(System.getProperty(OPENAPI_RESOURCE_BALANCE_ENABLE, "false"));
    }

    public static boolean isWorkFlowResourceBalanceEnable() {
        return Configs.isMultiTenantResourceBalanceEnable() && Boolean.parseBoolean(System.getProperty(WORKFLOW_RESOURCE_BALANCE_ENABLE, "false"));
    }

    public static boolean isSomeTypeResourceBalanceEnable(String type) {
        return Configs.isMultiTenantResourceBalanceEnable() && Boolean.parseBoolean(System.getProperty(type + SUFFIX_RESOURCE_BALANCE_ENABLE, "false"));
    }

    public static int getOverBorrowThreshold() {
        return Integer.getInteger(RESOURCE_OVER_BORROW_THRESHOLD, 50);
    }

    public static int getOverflowPoolMaxThread() {
        return Integer.getInteger(OVERFLOW_POOL_MAX_THREAD_KEY, 10);
    }

    public static int getOverflowPoolThreshold() {
        return Integer.getInteger(RESOURCE_OVERFLOW_THRESHOLD, 20);
    }

    public static Integer getResourceMaxQueueSize(String resourceName) {
        Integer defaultValue = Integer.getInteger(RESOURCE_MAX_QUEUE_SIZE);
        if (resourceName == null) {
            return defaultValue;
        }
        String key = "bos.resource.threadpool.queuesize." + resourceName;
        Integer regionValue = Integer.getInteger(key);
        return regionValue == null ? defaultValue : regionValue;
    }

    public static Integer getResourceMinProportion(String resourceName) {
        Integer defaultValue = Integer.getInteger(TENANT_MIN_PROPORTION);
        if (resourceName == null) {
            return defaultValue;
        }
        String key = "bos.resource.tenant.minproportion." + resourceName;
        Integer regionValue = Integer.getInteger(key);
        return regionValue == null ? defaultValue : regionValue;
    }

    public static Integer getThreadPoolTimeoutThreshold(String resourceName) {
        Integer defaultValue = Integer.getInteger(RESOURCE_THREAD_TIMEOUT);
        if (resourceName == null) {
            return defaultValue;
        }
        String key = "bos.resource.threadpool.timeout." + resourceName;
        Integer regionValue = Integer.getInteger(key);
        return regionValue == null ? defaultValue : regionValue;
    }

    public static Integer getThreadPoolTimeoutRecyclePercent(String resourceName) {
        Integer defaultValue = Integer.getInteger(RESOURCE_THREAD_TIMEOUT_RECYCLE_PERCENT, 30);
        if (resourceName == null) {
            return defaultValue;
        }
        String key = "bos.resource.threadpool.recycle.percent." + resourceName;
        Integer regionValue = Integer.getInteger(key);
        return regionValue == null || regionValue < 0 ? defaultValue : regionValue;
    }

    public static String getTenantConfigDaoExtension() {
        return System.getProperty(TENANT_CONFIG_DAO, "monitor");
    }

    public static String getThreadPoolConfig() {
        return System.getProperty(THREAD_POOL_CONFIG);
    }

    public static long getMetricsReporterInterval() {
        return Long.getLong(METRICS_REPORTER_INTERVAL, 10L);
    }

    public static boolean isMetricsReporterEnable() {
        return Configs.isMultiTenantResourceBalanceEnable() && Boolean.parseBoolean(System.getProperty(METRICS_REPORTER_ENABLE, "true"));
    }

    public static int getFixedVirtualTenantProportion() {
        return Integer.getInteger(FIXED_VIRTUAL_TENANT_PROPORTION, 30);
    }

    public static int getEventDataReporterInterval() {
        return Integer.getInteger(EVENT_REPORT_INTERVAL, 60);
    }

    public static int getOverBorrowEventThreadThreshold() {
        return Integer.getInteger(OVERBORROW_EVENT_REPORT_THREAD_THRESHOLD, 30);
    }

    static {
        ConfigurationUtil.observeChange((String)MULTI_TENANT_RESOURCE_BALANCE_ENABLE, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                boolean val = Boolean.parseBoolean(System.getProperty(Configs.MULTI_TENANT_RESOURCE_BALANCE_ENABLE, "false"));
                if (!val) {
                    allEnable = false;
                }
            }
        });
    }
}

