/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.resource.balancer.allocator;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import kd.bos.exception.KDException;
import kd.bos.resource.balancer.ResourceBalanceErrorCode;
import kd.bos.resource.balancer.allocator.KQueue;
import kd.bos.resource.balancer.allocator.LoadScheduler;
import kd.bos.resource.balancer.allocator.threadpool.KDThreadPoolExecutor;
import kd.bos.resource.balancer.dimension.Isolator;

public class KMultQueue<E>
implements KQueue<E> {
    private Map<String, LinkedBlockingQueue<E>> queueContainer = new ConcurrentHashMap<String, LinkedBlockingQueue<E>>(2);
    private AtomicInteger totalCount = new AtomicInteger(0);
    private Isolator isolator = null;
    private LinkedBlockingQueue<E> permitedQueue = new LinkedBlockingQueue();

    @Override
    public boolean enqueue(E e) {
        String accountId = this.isolator.getDimensionIsolateValue().getIsolateValue();
        if (e == null) {
            return false;
        }
        if (((KDThreadPoolExecutor.WRunnable)e).hasDeductPermit.get()) {
            try {
                this.permitedQueue.put(e);
                this.totalCount.incrementAndGet();
                return true;
            }
            catch (InterruptedException ex) {
                throw new KDException(ResourceBalanceErrorCode.enqueueiserror, accountId, (Throwable)ex);
            }
        }
        LinkedBlockingQueue acctQueue = this.queueContainer.computeIfAbsent(accountId, k -> new LinkedBlockingQueue());
        int maxQueueSize = this.isolator.getMaxQueueSize(this.isolator.getDimensionIsolateValue());
        if (acctQueue.size() >= maxQueueSize) {
            return false;
        }
        try {
            acctQueue.put(e);
            this.totalCount.incrementAndGet();
        }
        catch (InterruptedException ex) {
            throw new KDException(ResourceBalanceErrorCode.enqueueiserror, accountId, (Throwable)ex);
        }
        return true;
    }

    @Override
    public E dequeue() {
        E e;
        if (this.totalCount.get() == 0) {
            LockSupport.parkNanos(100000000L);
            return null;
        }
        if (!this.permitedQueue.isEmpty() && (e = this.permitedQueue.poll()) != null) {
            this.totalCount.decrementAndGet();
            return e;
        }
        e = LoadScheduler.choose(this.isolator, this.queueContainer);
        if (e != null) {
            this.totalCount.decrementAndGet();
        } else {
            LockSupport.parkNanos(100000000L);
        }
        return e;
    }

    @Override
    public int size() {
        return this.totalCount.get();
    }

    @Override
    public int size(String isolateKey) {
        LinkedBlockingQueue<E> lbq = this.queueContainer.get(isolateKey);
        if (lbq != null) {
            return lbq.size();
        }
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return this.totalCount.get() == 0;
    }

    @Override
    public boolean remove(Object o) {
        AtomicBoolean ab = new AtomicBoolean(false);
        this.queueContainer.forEach((k, v) -> {
            boolean isRemoved = v.remove(o);
            ab.set(ab.get() || isRemoved);
        });
        return ab.get();
    }

    @Override
    public void setIsolator(Isolator isolator) {
        this.isolator = isolator;
    }

    @Override
    public Isolator getIsolator() {
        return this.isolator;
    }
}

