/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.resource.balancer.allocator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.types.MultiTenantResourceEvent;
import kd.bos.resource.balancer.Configs;
import kd.bos.resource.balancer.allocator.Callback;
import kd.bos.resource.balancer.allocator.KQueue;
import kd.bos.resource.balancer.allocator.threadpool.OverflowThreadPoolExecutor;
import kd.bos.resource.balancer.dimension.DimensionValue;
import kd.bos.resource.balancer.dimension.Isolator;
import kd.bos.resource.balancer.monitor.EventReporter;
import kd.bos.resource.balancer.monitor.ResourceRecycleManage;
import kd.bos.resource.balancer.monitor.metric.MonitorMetricInfo;

public class ResourceBalanceController<E> {
    private static Map<String, ResourceBalanceController> controllers = new ConcurrentHashMap<String, ResourceBalanceController>(2);
    private KQueue<E> workQueue;
    private final Isolator isolator;
    private final OverflowThreadPoolExecutor overflowPool;
    private final ResourceRecycleManage recycleManage;
    private String resourceType;
    private String resourceName;

    public static ResourceBalanceController getController(String resourceType, String resourceName) {
        return controllers.computeIfAbsent(resourceType + resourceName, k -> new ResourceBalanceController(resourceType, resourceName));
    }

    public static ResourceBalanceController getControllerWithIsolateType(String resourceType, String resourceName, String isolateType) {
        ResourceBalanceController resourceBalanceController = controllers.computeIfAbsent(resourceType + resourceName + isolateType, k -> new ResourceBalanceController(resourceType, resourceName, isolateType));
        return resourceBalanceController;
    }

    private ResourceBalanceController(String resourceType, String resourceName) {
        this.resourceType = resourceType;
        this.resourceName = resourceName;
        this.isolator = Isolator.getIsolator(resourceType, resourceName);
        this.overflowPool = OverflowThreadPoolExecutor.getOverflowPool(resourceType, resourceName);
        this.recycleManage = ResourceRecycleManage.getResourceRecycleManage(resourceType, resourceName);
    }

    private ResourceBalanceController(String resourceType, String resourceName, String isolateType) {
        this.resourceType = resourceType;
        this.resourceName = resourceName;
        this.isolator = Isolator.getIsolator(resourceType, resourceName);
        this.isolator.withIsolatorDimension(isolateType);
        this.overflowPool = OverflowThreadPoolExecutor.getOverflowPool(resourceType, resourceName, isolateType);
        this.recycleManage = ResourceRecycleManage.getResourceRecycleManage(resourceType, resourceName);
    }

    public Isolator getIsolator() {
        return this.isolator;
    }

    public ResourceRecycleManage getRecycleManage() {
        return this.recycleManage;
    }

    public void setQueue(KQueue<E> q) {
        this.workQueue = q;
        q.setIsolator(this.isolator);
    }

    public void setIsolatorDimensionKey(String s) {
        this.isolator.setIsolatorDimensionKey(s);
    }

    public boolean submit(Callback<E> c) {
        if (this.isOverflow() && this.overflowPool.submit((Runnable)c.getOriginal())) {
            StringBuilder builder = new StringBuilder("ResourceBalanceController ");
            builder.append(this.resourceName).append(":").append(this.resourceName);
            builder.append("is overflow.The final task was submitted by tenant account ").append(this.isolator.getDimensionIsolateValue().getIsolateValue());
            MultiTenantResourceEvent.OverflowEvent event = MultiTenantResourceEvent.OverflowEvent.getInstance();
            String eventKey = this.resourceType + this.resourceName + this.isolator.getDimensionIsolateValue().getIsolateValue() + event.getName();
            EventReporter.report(eventKey, (EventType)event, builder.toString());
            return true;
        }
        if (this.isolator.getResourceCap().left() <= 0L) {
            this.recycleManage.releaseTimeoutThread();
        }
        if (this.isolator.hasQuota()) {
            c.call();
            return true;
        }
        if (this.isTouchOverBorrowEvent()) {
            StringBuilder builder = new StringBuilder("ResourceBalanceController ");
            builder.append(this.resourceType).append(":").append(this.resourceName).append("\n");
            builder.append("The tenant account of ").append(this.isolator.getDimensionIsolateValue().getIsolateValue());
            builder.append(" has no resource quota.");
            builder.append(":\r\n");
            builder.append(this.getDimensionMonitorInfo(this.isolator.getDimensionIsolateValue()));
            MultiTenantResourceEvent.OverBorrowEvent event = MultiTenantResourceEvent.OverBorrowEvent.getInstance();
            String eventKey = this.resourceType + this.resourceName + this.isolator.getDimensionIsolateValue().getIsolateValue() + event.getName();
            EventReporter.report(eventKey, (EventType)event, builder.toString());
        }
        return this.workQueue.enqueue(c.getForQueue());
    }

    private boolean isOverflow() {
        DimensionValue dimensionIsolateValue = this.isolator.getDimensionIsolateValue();
        long using = this.isolator.inUsingForCurIsolation(dimensionIsolateValue);
        long quota = this.isolator.getQuota(dimensionIsolateValue);
        long utilizationRate = using * 100L / quota;
        return this.isolator.getResourceCap().left() <= 0L && utilizationRate < (long)Configs.getOverflowPoolThreshold();
    }

    private boolean isTouchOverBorrowEvent() {
        int maxQueued = this.isolator.getMaxQueueSize(this.isolator.getDimensionIsolateValue());
        int inQueued = this.getWorkQueue().size(this.isolator.getDimensionIsolateValue().getIsolateValue());
        long maxThread = this.isolator.getResourceCap().getMax();
        boolean isTouch = true;
        if (maxThread < (long)Configs.getOverBorrowEventThreadThreshold()) {
            isTouch = inQueued >= maxQueued / 2;
        }
        return isTouch;
    }

    public void initMaxResource(int maximumSize) {
        this.isolator.getResourceCap().initMax(maximumSize);
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public KQueue<E> getWorkQueue() {
        return this.workQueue;
    }

    public static String getMonitorInfo() {
        StringBuilder sb = new StringBuilder();
        controllers.forEach((k, resourceBalanceController) -> {
            sb.append("\r\n").append((String)k).append(":");
            Isolator isolator = resourceBalanceController.getIsolator();
            Set<String> keys = isolator.getIsolationKeys();
            for (String key : keys) {
                sb.append(" ").append(isolator.getIsolatorDimensionType()).append(" ").append(key);
                sb.append("[");
                DimensionValue dimensionIsolateValue = isolator.getDimensionIsolateValue(key);
                sb.append("using:").append(isolator.inUsingForCurIsolation(dimensionIsolateValue));
                sb.append(",quota:").append(isolator.getQuota(dimensionIsolateValue));
                sb.append(",queued:").append(resourceBalanceController.getWorkQueue().size(key));
                sb.append(",max queue:").append(isolator.getMaxQueueSize(dimensionIsolateValue));
                sb.append("]");
            }
            sb.append("\r\nresourceCap:[total:").append(isolator.getResourceCap().getMax()).append(",using:").append(isolator.getResourceCap().inUsing()).append("]");
        });
        return sb.toString();
    }

    public String getDimensionMonitorInfo(DimensionValue dimensionValue) {
        StringBuilder sb = new StringBuilder();
        sb.append("resourceType:").append(this.resourceType);
        sb.append("\r\nresourceName:").append(this.resourceName);
        sb.append("\r\ndimensionType:").append(this.isolator.getIsolatorDimensionType());
        sb.append("\r\naccountId:").append(dimensionValue.getIsolateValue());
        sb.append("[");
        sb.append("using:").append(this.isolator.inUsingForCurIsolation(dimensionValue));
        sb.append(",quota:").append(this.isolator.getQuota(dimensionValue));
        sb.append(",inQueue:").append(this.getWorkQueue().size(dimensionValue.getIsolateValue()));
        sb.append(",maxQueueSize:").append(this.isolator.getMaxQueueSize(dimensionValue));
        sb.append("]");
        sb.append("\r\nresourceCap:[total:").append(this.isolator.getResourceCap().getMax()).append(",using:").append(this.isolator.getResourceCap().inUsing()).append("]");
        return sb.toString();
    }

    public static List<MonitorMetricInfo> getMonitorMetricInfo() {
        ArrayList<MonitorMetricInfo> infoList = new ArrayList<MonitorMetricInfo>(32);
        controllers.forEach((k, resourceBalanceController) -> {
            Isolator isolator = resourceBalanceController.getIsolator();
            String resourceName = resourceBalanceController.getResourceName();
            Set<String> keys = isolator.getIsolationKeys();
            for (String key : keys) {
                DimensionValue dimensionIsolateValue = isolator.getDimensionIsolateValue(key);
                MonitorMetricInfo info = new MonitorMetricInfo(resourceName, dimensionIsolateValue.getIsolateValue());
                info.setMaxThread(isolator.getResourceCap().getMax());
                info.setQuota(isolator.getQuota(dimensionIsolateValue));
                info.setMaxQueueSize(isolator.getMaxQueueSize(dimensionIsolateValue));
                info.setActive(isolator.inUsingForCurIsolation(dimensionIsolateValue));
                info.setWaiting(resourceBalanceController.getWorkQueue().size(key));
                info.setRejected(isolator.getRejectedCount(dimensionIsolateValue));
                infoList.add(info);
            }
        });
        return infoList;
    }
}

