/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.resource.balancer.allocator.threadpool;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.reporter.EventDataReporter;
import kd.bos.govern.eventdata.types.MultiTenantResourceEvent;
import kd.bos.resource.balancer.Configs;
import kd.bos.resource.balancer.quota.ResourceConfigManage;

public class OverflowThreadPoolExecutor {
    private static Map<String, OverflowThreadPoolExecutor> overflowPools = new ConcurrentHashMap<String, OverflowThreadPoolExecutor>(2);
    private static final String POOL_NAME_SUFFIX = "OverflowThreadPool";
    private ThreadPoolExecutor executor;
    private String resourceType;
    private String resourceName;

    public static OverflowThreadPoolExecutor getOverflowPool(String resourceType, String resourceName) {
        return overflowPools.computeIfAbsent(resourceType + resourceName, k -> new OverflowThreadPoolExecutor(resourceType, resourceName));
    }

    public static OverflowThreadPoolExecutor getOverflowPool(String resourceType, String resourceName, String isolateType) {
        OverflowThreadPoolExecutor overflowThreadPool = overflowPools.computeIfAbsent(resourceType + resourceName + isolateType, k -> new OverflowThreadPoolExecutor(resourceType, resourceName, isolateType));
        return overflowThreadPool;
    }

    private OverflowThreadPoolExecutor(String resourceType, String resourceName) {
        this.resourceType = resourceType;
        this.resourceName = resourceName;
        this.initExecutor();
    }

    private OverflowThreadPoolExecutor(String resourceType, String resourceName, String isolateType) {
        this.resourceType = resourceType;
        this.resourceName = resourceName;
        this.initExecutor();
    }

    private String getPoolName() {
        return ResourceConfigManage.getThreadName(this.resourceName) + "-" + POOL_NAME_SUFFIX;
    }

    private void initExecutor() {
        this.executor = new ThreadPoolExecutor(0, Configs.getOverflowPoolMaxThread(), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
            private AtomicInteger atomicInteger = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, OverflowThreadPoolExecutor.this.getPoolName() + "-" + this.atomicInteger.incrementAndGet());
            }
        }, new ThreadPoolExecutor.AbortPolicy());
    }

    public boolean submit(Runnable r) {
        try {
            this.executor.execute(r);
        }
        catch (RejectedExecutionException e) {
            String msg = String.format("The tenant resource overflow thread pool is full! Rejected from executor => %s", this.getPoolName());
            EventDataReporter.report((EventType)MultiTenantResourceEvent.ThreadPoolRejectEvent.getInstance(), (String)msg);
            return false;
        }
        return true;
    }
}

