/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.resource.balancer.allocator.threadpool;

import java.util.concurrent.TimeUnit;
import kd.bos.resource.balancer.allocator.KMultQueue;
import kd.bos.resource.balancer.allocator.KQueue;
import kd.bos.resource.balancer.allocator.threadpool.AbstractKDBlockQueue;
import kd.bos.resource.balancer.allocator.threadpool.ResourceMonitor;
import kd.bos.resource.balancer.dimension.Isolator;

public class QueueForThreadPool<E>
extends AbstractKDBlockQueue<E>
implements KQueue<E> {
    private ResourceMonitor monitor;
    private KMultQueue<E> multQueue = new KMultQueue();
    private static ThreadLocal<Boolean> prepareAddWorker = ThreadLocal.withInitial(() -> false);

    protected void setMonitor(ResourceMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public E take() throws InterruptedException {
        return this.poll(Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        long expireTimeAt = System.currentTimeMillis() + unit.toMillis(timeout);
        do {
            E e;
            if ((e = this.multQueue.dequeue()) == null) continue;
            return e;
        } while (System.currentTimeMillis() <= expireTimeAt);
        return null;
    }

    @Override
    public boolean offer(E e) {
        if (this.monitor.getPoolCount() < this.monitor.getMaxPoolSize()) {
            prepareAddWorker.set(true);
            return false;
        }
        prepareAddWorker.set(false);
        return this.multQueue.enqueue(e);
    }

    public boolean isPrepareAddWorker() {
        return prepareAddWorker.get();
    }

    public void resetPrepareAddWorker() {
        prepareAddWorker.set(false);
    }

    @Override
    public boolean enqueue(E e) {
        return this.multQueue.enqueue(e);
    }

    @Override
    public E dequeue() {
        return this.multQueue.dequeue();
    }

    @Override
    public int size() {
        return this.multQueue.size();
    }

    @Override
    public int size(String isolateKey) {
        return this.multQueue.size(isolateKey);
    }

    @Override
    public boolean isEmpty() {
        return this.multQueue.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        return this.multQueue.remove(o);
    }

    @Override
    public void setIsolator(Isolator isolator) {
        this.multQueue.setIsolator(isolator);
    }

    @Override
    public Isolator getIsolator() {
        return this.multQueue.getIsolator();
    }
}

