/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.resource.balancer.cap;

import java.util.concurrent.atomic.AtomicLong;
import kd.bos.resource.balancer.Configs;
import kd.bos.resource.balancer.cap.limit.ResourceLimitManage;
import kd.bos.resource.balancer.cap.limit.ResourceLimiter;

public class ResourceCap {
    private final String type;
    private ResourceLimiter limiter;
    private long max = 1L;
    private AtomicLong inUsing = new AtomicLong(0L);

    protected ResourceCap(String type) {
        this.type = type;
        this.limiter = ResourceLimitManage.getLimiter(type);
    }

    public long getMax() {
        return this.max > 0L ? this.max : this.limiter.getMax();
    }

    public long inUsing() {
        return this.inUsing.get();
    }

    public long left() {
        long left = this.getMax() - this.inUsing();
        return left > 0L ? left : 0L;
    }

    public boolean canOverBorrow() {
        long max = this.getMax();
        if (max == 0L) {
            return false;
        }
        long usePercent = 100L * this.inUsing() / max;
        return usePercent < (long)Configs.getOverBorrowThreshold();
    }

    public void incrementUsing() {
        this.inUsing.incrementAndGet();
    }

    public void decrementUsing() {
        this.inUsing.decrementAndGet();
    }

    public void initMax(int maximumSize) {
        this.max = maximumSize;
    }
}

