/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.resource.balancer.dimension.impl;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.resource.balancer.cap.ResourceCap;
import kd.bos.resource.balancer.dimension.IsolatorDimension;
import kd.bos.resource.balancer.quota.ResourceQuota;
import kd.bos.resource.balancer.quota.WeightAndPriority;

public abstract class AbstractIsolatorDimension
implements IsolatorDimension {
    private Map<String, AtomicLong> isolationResouceUsage = new ConcurrentHashMap<String, AtomicLong>(1);
    private Map<String, AtomicLong> isolationResourceRejected = new ConcurrentHashMap<String, AtomicLong>(1);
    private Map<String, ResourceQuota> resourceQuotas = new ConcurrentHashMap<String, ResourceQuota>(1);
    private String resourceType;
    private String resourceName;
    private ResourceCap resourceCap;

    @Override
    public void setResourceTypeAndName(String resourceType, String resourceName, ResourceCap resourceCap) {
        this.resourceName = resourceName;
        this.resourceType = resourceType;
        this.resourceCap = resourceCap;
    }

    private ResourceQuota getResourceQuota(String isolationKey) {
        ResourceQuota resourceQuota = this.resourceQuotas.computeIfAbsent(isolationKey, k -> new ResourceQuota(this.resourceName, this.getWeighAndPriority(this.resourceName, isolationKey), this.resourceCap));
        return resourceQuota;
    }

    protected abstract WeightAndPriority getWeighAndPriority(String var1, String var2);

    @Override
    public long inUsingForCurIsolation(String isolationKey) {
        return this.isolationResouceUsage.computeIfAbsent(isolationKey, k -> new AtomicLong(0L)).get();
    }

    @Override
    public long getRejectedCount(String isolationKey) {
        return this.isolationResourceRejected.computeIfAbsent(isolationKey, k -> new AtomicLong(0L)).get();
    }

    @Override
    public void incrementUsing(String isolationKey) {
        this.isolationResouceUsage.computeIfAbsent(isolationKey, k -> new AtomicLong(0L)).incrementAndGet();
    }

    @Override
    public void decrementUsing(String isolationKey) {
        this.isolationResouceUsage.computeIfAbsent(isolationKey, k -> new AtomicLong(0L)).decrementAndGet();
    }

    @Override
    public void incrementRejected(String isolationKey) {
        this.isolationResourceRejected.computeIfAbsent(isolationKey, k -> new AtomicLong(0L)).incrementAndGet();
    }

    @Override
    public boolean hasQuota(String isolationKey) {
        long used = this.isolationResouceUsage.computeIfAbsent(isolationKey, k -> new AtomicLong(0L)).get();
        return used < this.getResourceQuota(isolationKey).getQuota();
    }

    @Override
    public long getQuota(String isolationKey) {
        return this.getResourceQuota(isolationKey).getQuota();
    }

    @Override
    public int getPriorityLevel(String isolationKey) {
        return this.getResourceQuota(isolationKey).getPriorityLevel();
    }

    @Override
    public int getMaxQueueSize(String isolationKey) {
        return this.getResourceQuota(isolationKey).getMaxQueueSize();
    }

    @Override
    public Set<String> getIsolationKeys() {
        return this.isolationResouceUsage.keySet();
    }
}

